/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchemaObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablespace;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;
import org.jkiss.utils.CommonUtils;

public class OracleRecycledObject
extends OracleSchemaObject
implements DBSObjectLazy<OracleDataSource> {
    private String recycledName;
    private Operation operation;
    private String objectType;
    private Object tablespace;
    private String createTime;
    private String dropTime;
    private String partitionName;
    private boolean canUndrop;
    private boolean canPurge;

    protected OracleRecycledObject(OracleSchema schema, ResultSet dbResult) {
        super(schema, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ORIGINAL_NAME"), true);
        this.recycledName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_NAME");
        this.operation = (Operation)CommonUtils.valueOf(Operation.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OPERATION"));
        this.objectType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE");
        this.tablespace = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TS_NAME");
        this.createTime = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CREATETIME");
        this.dropTime = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DROPTIME");
        this.partitionName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARTITION_NAME");
        this.canUndrop = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"CAN_UNDROP", (String)"Y");
        this.canPurge = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"CAN_PURGE", (String)"Y");
    }

    @Property(viewable=true, order=2)
    public String getRecycledName() {
        return this.recycledName;
    }

    @Property(viewable=true, order=3)
    public Operation getOperation() {
        return this.operation;
    }

    @Property(viewable=true, order=4)
    public String getObjectType() {
        return this.objectType;
    }

    @Property(viewable=true, order=5)
    @LazyProperty(cacheValidator=OracleTablespace.TablespaceReferenceValidator.class)
    public Object getTablespace(DBRProgressMonitor monitor) throws DBException {
        return OracleTablespace.resolveTablespaceReference(monitor, this, null);
    }

    @Property(order=6)
    public String getCreateTime() {
        return this.createTime;
    }

    @Property(order=7)
    public String getDropTime() {
        return this.dropTime;
    }

    @Property(order=8)
    public String getPartitionName() {
        return this.partitionName;
    }

    @Property(viewable=true, order=9)
    public boolean isCanUndrop() {
        return this.canUndrop;
    }

    @Property(viewable=true, order=10)
    public boolean isCanPurge() {
        return this.canPurge;
    }

    @Nullable
    public Object getLazyReference(Object propertyId) {
        return this.tablespace;
    }

    public static enum Operation {
        DROP,
        TRUNCATE;

    }
}

