/*
 * DO NOT EDIT THIS FILE. Generated by checkmk.
 * Edit the original source file "../../libdrgn/tests/parse_addr2line.c.in" instead.
 */

#include <check.h>

#line 1 "../../libdrgn/tests/parse_addr2line.c.in"
// Copyright (c) Meta Platforms, Inc. and affiliates.
// SPDX-License-Identifier: LGPL-2.1-or-later

#include "test_util.h"
#include "../error.h"
#include "../stack_trace.h"


START_TEST(symbol_name)
{
#line 11
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_no_err(drgn_parse_addr2line("my_symbol", &sym_name,
					    &sym_name_len, &offset));
	ck_assert_uint_eq(sym_name_len, strlen("my_symbol"));
	ck_assert_mem_eq(sym_name, "my_symbol", strlen("my_symbol"));
	ck_assert_uint_eq(offset, 0);
}

}
END_TEST

START_TEST(symbol_name_with_punctuation)
{
#line 23
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_no_err(drgn_parse_addr2line("my_symbol.cold", &sym_name,
					    &sym_name_len, &offset));
	ck_assert_uint_eq(sym_name_len, strlen("my_symbol.cold"));
	ck_assert_mem_eq(sym_name, "my_symbol.cold", strlen("my_symbol.cold"));
	ck_assert_uint_eq(offset, 0);
}

}
END_TEST

START_TEST(symbol_name_with_whitespace)
{
#line 35
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_no_err(drgn_parse_addr2line("  my_symbol\t", &sym_name,
					    &sym_name_len, &offset));
	ck_assert_uint_eq(sym_name_len, strlen("my_symbol"));
	ck_assert_mem_eq(sym_name, "my_symbol", strlen("my_symbol"));
	ck_assert_uint_eq(offset, 0);
}

}
END_TEST

START_TEST(symbol_name_starting_with_0x)
{
#line 47
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_no_err(drgn_parse_addr2line("0xfoobar", &sym_name,
					    &sym_name_len, &offset));
	ck_assert_uint_eq(sym_name_len, strlen("0xfoobar"));
	ck_assert_mem_eq(sym_name, "0xfoobar", strlen("0xfoobar"));
	ck_assert_uint_eq(offset, 0);

	drgn_ck_no_err(drgn_parse_addr2line("0Xnotaddress", &sym_name,
					    &sym_name_len, &offset));
	ck_assert_uint_eq(sym_name_len, strlen("0Xnotaddress"));
	ck_assert_mem_eq(sym_name, "0Xnotaddress", strlen("0Xnotaddress"));
	ck_assert_uint_eq(offset, 0);
}

}
END_TEST

START_TEST(symbol_name_with_hex_offset)
{
#line 65
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_no_err(drgn_parse_addr2line("my_symbol+0x10", &sym_name,
					    &sym_name_len, &offset));
	ck_assert_uint_eq(sym_name_len, strlen("my_symbol"));
	ck_assert_mem_eq(sym_name, "my_symbol", strlen("my_symbol"));
	ck_assert_uint_eq(offset, 16);
}

}
END_TEST

START_TEST(symbol_name_with_hex_offset_and_whitespace)
{
#line 77
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_no_err(drgn_parse_addr2line(" my_symbol +  0X10 ", &sym_name,
					    &sym_name_len, &offset));
	ck_assert_uint_eq(sym_name_len, strlen("my_symbol"));
	ck_assert_mem_eq(sym_name, "my_symbol", strlen("my_symbol"));
	ck_assert_uint_eq(offset, 16);
}

}
END_TEST

START_TEST(symbol_name_with_hex_offset_overflow)
{
#line 89
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_err(drgn_parse_addr2line("my_symbol+0x10000000000000000", &sym_name,
					 &sym_name_len, &offset),
		    DRGN_ERROR_OVERFLOW, "symbol offset out of range");
}

}
END_TEST

START_TEST(symbol_name_with_decimal_offset)
{
#line 99
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_no_err(drgn_parse_addr2line("my_symbol+10", &sym_name,
					    &sym_name_len, &offset));
	ck_assert_uint_eq(sym_name_len, strlen("my_symbol"));
	ck_assert_mem_eq(sym_name, "my_symbol", strlen("my_symbol"));
	ck_assert_uint_eq(offset, 10);
}

}
END_TEST

START_TEST(symbol_name_with_decimal_offset_leading_zero)
{
#line 111
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_no_err(drgn_parse_addr2line("my_symbol+010", &sym_name,
					    &sym_name_len, &offset));
	ck_assert_uint_eq(sym_name_len, strlen("my_symbol"));
	ck_assert_mem_eq(sym_name, "my_symbol", strlen("my_symbol"));
	ck_assert_uint_eq(offset, 10); // NB: not octal.
}

}
END_TEST

START_TEST(symbol_name_with_decimal_offset_overflow)
{
#line 123
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_err(drgn_parse_addr2line("my_symbol+18446744073709551616", &sym_name,
					 &sym_name_len, &offset),
		    DRGN_ERROR_OVERFLOW, "symbol offset out of range");
}

}
END_TEST

START_TEST(symbol_name_with_decimal_offset_and_whitespace)
{
#line 133
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_no_err(drgn_parse_addr2line(" my_symbol +  10 ", &sym_name,
					    &sym_name_len, &offset));
	ck_assert_uint_eq(sym_name_len, strlen("my_symbol"));
	ck_assert_mem_eq(sym_name, "my_symbol", strlen("my_symbol"));
	ck_assert_uint_eq(offset, 10);
}

}
END_TEST

START_TEST(symbol_name_with_garbage)
{
#line 145
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_err(drgn_parse_addr2line("my_symbol foo", &sym_name,
					 &sym_name_len, &offset),
		    DRGN_ERROR_INVALID_ARGUMENT,
		    "unexpected input after symbol name or address");
}

}
END_TEST

START_TEST(symbol_name_with_only_plus)
{
#line 156
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_err(drgn_parse_addr2line("my_symbol+", &sym_name,
					 &sym_name_len, &offset),
		    DRGN_ERROR_INVALID_ARGUMENT, "expected symbol offset");
}

}
END_TEST

START_TEST(symbol_name_with_plus_and_non_numeric)
{
#line 166
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_err(drgn_parse_addr2line("my_symbol+foo", &sym_name,
					 &sym_name_len, &offset),
		    DRGN_ERROR_INVALID_ARGUMENT, "expected symbol offset");
}

}
END_TEST

START_TEST(symbol_name_with_plus_and_0x)
{
#line 176
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_err(drgn_parse_addr2line("my_symbol+0x", &sym_name,
					 &sym_name_len, &offset),
		    DRGN_ERROR_INVALID_ARGUMENT, "expected symbol offset");
	drgn_ck_err(drgn_parse_addr2line("my_symbol+0X", &sym_name,
					 &sym_name_len, &offset),
		    DRGN_ERROR_INVALID_ARGUMENT, "expected symbol offset");
}

}
END_TEST

START_TEST(symbol_name_with_garbage_hex_offset)
{
#line 189
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_err(drgn_parse_addr2line("my_symbol+0xz", &sym_name,
					 &sym_name_len, &offset),
		    DRGN_ERROR_INVALID_ARGUMENT, "expected symbol offset");
	drgn_ck_err(drgn_parse_addr2line("my_symbol+0Xz", &sym_name,
					 &sym_name_len, &offset),
		    DRGN_ERROR_INVALID_ARGUMENT, "expected symbol offset");
}

}
END_TEST

START_TEST(symbol_name_with_garbage_after_offset)
{
#line 202
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_err(drgn_parse_addr2line("my_symbol+1foo", &sym_name,
					 &sym_name_len, &offset),
		    DRGN_ERROR_INVALID_ARGUMENT,
		    "unexpected input after symbol offset");
}

}
END_TEST

START_TEST(symbol_name_with_whitespace_and_garbage_after_offset)
{
#line 213
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_err(drgn_parse_addr2line("my_symbol+1 foo", &sym_name,
					 &sym_name_len, &offset),
		    DRGN_ERROR_INVALID_ARGUMENT,
		    "unexpected input after symbol offset");
}

}
END_TEST

START_TEST(address)
{
#line 224
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_no_err(drgn_parse_addr2line("0x1234", &sym_name,
					    &sym_name_len, &offset));
	ck_assert_uint_eq(sym_name_len, 0);
	ck_assert_uint_eq(offset, 0x1234);
}

}
END_TEST

START_TEST(address_with_whitespace)
{
#line 235
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_no_err(drgn_parse_addr2line("\t0x1234  ", &sym_name,
					    &sym_name_len, &offset));
	ck_assert_uint_eq(sym_name_len, 0);
	ck_assert_uint_eq(offset, 0x1234);
}

}
END_TEST

START_TEST(address_with_hex_offset)
{
#line 246
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_no_err(drgn_parse_addr2line("0x1234+0x10", &sym_name,
					    &sym_name_len, &offset));
	ck_assert_uint_eq(sym_name_len, 0);
	ck_assert_uint_eq(offset, 0x1244);
}

}
END_TEST

START_TEST(address_with_decimal_offset)
{
#line 257
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_no_err(drgn_parse_addr2line("0x1234+10", &sym_name,
					    &sym_name_len, &offset));
	ck_assert_uint_eq(sym_name_len, 0);
	ck_assert_uint_eq(offset, 0x123e);
}

}
END_TEST

START_TEST(address_overflow)
{
#line 268
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_err(drgn_parse_addr2line("0x10000000000000000", &sym_name,
					 &sym_name_len, &offset),
		    DRGN_ERROR_OVERFLOW, "address out of range");
}

}
END_TEST

START_TEST(address_with_garbage)
{
#line 278
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_err(drgn_parse_addr2line("0x1234 foo", &sym_name, &sym_name_len,
					 &offset),
		    DRGN_ERROR_INVALID_ARGUMENT,
		    "unexpected input after symbol name or address");
}

}
END_TEST

START_TEST(empty)
{
#line 289
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_err(drgn_parse_addr2line("", &sym_name, &sym_name_len, &offset),
		    DRGN_ERROR_INVALID_ARGUMENT,
		    "expected symbol name or address");
}

}
END_TEST

START_TEST(all_whitespace)
{
#line 299
{
	const char *sym_name;
	size_t sym_name_len;
	unsigned long long offset;
	drgn_ck_err(drgn_parse_addr2line("  ", &sym_name, &sym_name_len, &offset),
		    DRGN_ERROR_INVALID_ARGUMENT,
		    "expected symbol name or address");
}
}
END_TEST

int main(void)
{
    Suite *s1 = suite_create("parse_addr2line");
    TCase *tc1_1 = tcase_create("parse_addr2line");
    SRunner *sr = srunner_create(s1);
    int nf;

    suite_add_tcase(s1, tc1_1);
    tcase_add_test(tc1_1, symbol_name);
    tcase_add_test(tc1_1, symbol_name_with_punctuation);
    tcase_add_test(tc1_1, symbol_name_with_whitespace);
    tcase_add_test(tc1_1, symbol_name_starting_with_0x);
    tcase_add_test(tc1_1, symbol_name_with_hex_offset);
    tcase_add_test(tc1_1, symbol_name_with_hex_offset_and_whitespace);
    tcase_add_test(tc1_1, symbol_name_with_hex_offset_overflow);
    tcase_add_test(tc1_1, symbol_name_with_decimal_offset);
    tcase_add_test(tc1_1, symbol_name_with_decimal_offset_leading_zero);
    tcase_add_test(tc1_1, symbol_name_with_decimal_offset_overflow);
    tcase_add_test(tc1_1, symbol_name_with_decimal_offset_and_whitespace);
    tcase_add_test(tc1_1, symbol_name_with_garbage);
    tcase_add_test(tc1_1, symbol_name_with_only_plus);
    tcase_add_test(tc1_1, symbol_name_with_plus_and_non_numeric);
    tcase_add_test(tc1_1, symbol_name_with_plus_and_0x);
    tcase_add_test(tc1_1, symbol_name_with_garbage_hex_offset);
    tcase_add_test(tc1_1, symbol_name_with_garbage_after_offset);
    tcase_add_test(tc1_1, symbol_name_with_whitespace_and_garbage_after_offset);
    tcase_add_test(tc1_1, address);
    tcase_add_test(tc1_1, address_with_whitespace);
    tcase_add_test(tc1_1, address_with_hex_offset);
    tcase_add_test(tc1_1, address_with_decimal_offset);
    tcase_add_test(tc1_1, address_overflow);
    tcase_add_test(tc1_1, address_with_garbage);
    tcase_add_test(tc1_1, empty);
    tcase_add_test(tc1_1, all_whitespace);

    srunner_run_all(sr, CK_ENV);
    nf = srunner_ntests_failed(sr);
    srunner_free(sr);

    return nf == 0 ? 0 : 1;
}
