"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bindings = void 0;
var react_1 = __importDefault(require("react"));
var Schema_1 = require("./Schema");
var helpers_1 = require("../helpers");
var Bindings = function (_a) {
    var _b = _a.name, name = _b === void 0 ? 'Binding specific information' : _b, bindings = _a.bindings;
    if (!bindings || bindings.isEmpty()) {
        return null;
    }
    var renderedBindings = bindings.all().map(function (binding) {
        var bindingValue = binding.value();
        var schema = helpers_1.SchemaHelpers.jsonToSchema(bindingValue);
        var protocol = binding.protocol();
        var schemaName = (react_1.default.createElement("div", { className: "inline-block text-sm" },
            react_1.default.createElement("span", null, name),
            react_1.default.createElement("strong", { className: "bg-teal-500 no-underline text-white uppercase rounded mx-2 px-2 py-1 text-xs" }, protocol)));
        return (schema !== undefined && (react_1.default.createElement(Schema_1.Schema, { schemaName: schemaName, schema: schema, key: protocol, onlyTitle: true })));
    });
    return react_1.default.createElement(react_1.default.Fragment, null, renderedBindings);
};
exports.Bindings = Bindings;
//# sourceMappingURL=Bindings.js.map