/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.quadedge;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.math.DD;

public class TrianglePredicate {
    public static boolean isInCircleNonRobust(Coordinate a, Coordinate b, Coordinate c2, Coordinate p) {
        boolean isInCircle = (a.x * a.x + a.y * a.y) * TrianglePredicate.triArea(b, c2, p) - (b.x * b.x + b.y * b.y) * TrianglePredicate.triArea(a, c2, p) + (c2.x * c2.x + c2.y * c2.y) * TrianglePredicate.triArea(a, b, p) - (p.x * p.x + p.y * p.y) * TrianglePredicate.triArea(a, b, c2) > 0.0;
        return isInCircle;
    }

    public static boolean isInCircleNormalized(Coordinate a, Coordinate b, Coordinate c2, Coordinate p) {
        double adx = a.x - p.x;
        double ady = a.y - p.y;
        double alift = adx * adx + ady * ady;
        double bdx = b.x - p.x;
        double cdy = c2.y - p.y;
        double cdx = c2.x - p.x;
        double bdy = b.y - p.y;
        double bcdet = bdx * cdy - cdx * bdy;
        double blift = bdx * bdx + bdy * bdy;
        double cadet = cdx * ady - adx * cdy;
        double clift = cdx * cdx + cdy * cdy;
        double abdet = adx * bdy - bdx * ady;
        double disc = alift * bcdet + blift * cadet + clift * abdet;
        return disc > 0.0;
    }

    private static double triArea(Coordinate a, Coordinate b, Coordinate c2) {
        return (b.x - a.x) * (c2.y - a.y) - (b.y - a.y) * (c2.x - a.x);
    }

    public static boolean isInCircleRobust(Coordinate a, Coordinate b, Coordinate c2, Coordinate p) {
        return TrianglePredicate.isInCircleNormalized(a, b, c2, p);
    }

    public static boolean isInCircleDDSlow(Coordinate a, Coordinate b, Coordinate c2, Coordinate p) {
        DD px = DD.valueOf(p.x);
        DD py = DD.valueOf(p.y);
        DD ax = DD.valueOf(a.x);
        DD ay = DD.valueOf(a.y);
        DD bx = DD.valueOf(b.x);
        DD by = DD.valueOf(b.y);
        DD cx = DD.valueOf(c2.x);
        DD cy = DD.valueOf(c2.y);
        DD aTerm = ax.multiply(ax).add(ay.multiply(ay)).multiply(TrianglePredicate.triAreaDDSlow(bx, by, cx, cy, px, py));
        DD bTerm = bx.multiply(bx).add(by.multiply(by)).multiply(TrianglePredicate.triAreaDDSlow(ax, ay, cx, cy, px, py));
        DD cTerm = cx.multiply(cx).add(cy.multiply(cy)).multiply(TrianglePredicate.triAreaDDSlow(ax, ay, bx, by, px, py));
        DD pTerm = px.multiply(px).add(py.multiply(py)).multiply(TrianglePredicate.triAreaDDSlow(ax, ay, bx, by, cx, cy));
        DD sum = aTerm.subtract(bTerm).add(cTerm).subtract(pTerm);
        boolean isInCircle = sum.doubleValue() > 0.0;
        return isInCircle;
    }

    public static DD triAreaDDSlow(DD ax, DD ay, DD bx, DD by, DD cx, DD cy) {
        return bx.subtract(ax).multiply(cy.subtract(ay)).subtract(by.subtract(ay).multiply(cx.subtract(ax)));
    }

    public static boolean isInCircleDDFast(Coordinate a, Coordinate b, Coordinate c2, Coordinate p) {
        DD aTerm = DD.sqr(a.x).selfAdd(DD.sqr(a.y)).selfMultiply(TrianglePredicate.triAreaDDFast(b, c2, p));
        DD bTerm = DD.sqr(b.x).selfAdd(DD.sqr(b.y)).selfMultiply(TrianglePredicate.triAreaDDFast(a, c2, p));
        DD cTerm = DD.sqr(c2.x).selfAdd(DD.sqr(c2.y)).selfMultiply(TrianglePredicate.triAreaDDFast(a, b, p));
        DD pTerm = DD.sqr(p.x).selfAdd(DD.sqr(p.y)).selfMultiply(TrianglePredicate.triAreaDDFast(a, b, c2));
        DD sum = aTerm.selfSubtract(bTerm).selfAdd(cTerm).selfSubtract(pTerm);
        boolean isInCircle = sum.doubleValue() > 0.0;
        return isInCircle;
    }

    public static DD triAreaDDFast(Coordinate a, Coordinate b, Coordinate c2) {
        DD t1 = DD.valueOf(b.x).selfSubtract(a.x).selfMultiply(DD.valueOf(c2.y).selfSubtract(a.y));
        DD t2 = DD.valueOf(b.y).selfSubtract(a.y).selfMultiply(DD.valueOf(c2.x).selfSubtract(a.x));
        return t1.selfSubtract(t2);
    }

    public static boolean isInCircleDDNormalized(Coordinate a, Coordinate b, Coordinate c2, Coordinate p) {
        DD adx = DD.valueOf(a.x).selfSubtract(p.x);
        DD ady = DD.valueOf(a.y).selfSubtract(p.y);
        DD bdx = DD.valueOf(b.x).selfSubtract(p.x);
        DD bdy = DD.valueOf(b.y).selfSubtract(p.y);
        DD cdx = DD.valueOf(c2.x).selfSubtract(p.x);
        DD cdy = DD.valueOf(c2.y).selfSubtract(p.y);
        DD abdet = adx.multiply(bdy).selfSubtract(bdx.multiply(ady));
        DD bcdet = bdx.multiply(cdy).selfSubtract(cdx.multiply(bdy));
        DD cadet = cdx.multiply(ady).selfSubtract(adx.multiply(cdy));
        DD alift = adx.multiply(adx).selfAdd(ady.multiply(ady));
        DD blift = bdx.multiply(bdx).selfAdd(bdy.multiply(bdy));
        DD clift = cdx.multiply(cdx).selfAdd(cdy.multiply(cdy));
        DD sum = alift.selfMultiply(bcdet).selfAdd(blift.selfMultiply(cadet)).selfAdd(clift.selfMultiply(abdet));
        boolean isInCircle = sum.doubleValue() > 0.0;
        return isInCircle;
    }

    public static boolean isInCircleCC(Coordinate a, Coordinate b, Coordinate c2, Coordinate p) {
        Coordinate cc = Triangle.circumcentre(a, b, c2);
        double ccRadius = a.distance(cc);
        double pRadiusDiff = p.distance(cc) - ccRadius;
        return pRadiusDiff <= 0.0;
    }
}

