/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.CombinedIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTaskInnerHelper;
import com.intellij.database.util.ObjectPath;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B'\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/introspection/RegularIntrospectionTask;", "Lcom/intellij/database/introspection/CombinedIntrospectionTask;", "dataSourceId", "", "databaseName", "elementsToRefresh", "", "Lcom/intellij/database/util/ObjectPath;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Collection;)V", "getDatabaseName", "()Ljava/lang/String;", "taskTypeOrder", "", "getTaskTypeOrder", "()B", "getElementsToRefresh", "()Ljava/util/Collection;", "toString", "intellij.database.core.impl"})
public non-sealed class RegularIntrospectionTask
extends CombinedIntrospectionTask {
    @NotNull
    private final String databaseName;
    @NotNull
    private final Collection<ObjectPath> elementsToRefresh;

    @Override
    @NotNull
    public final String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public byte getTaskTypeOrder() {
        return 4;
    }

    @NotNull
    public final Collection<ObjectPath> getElementsToRefresh() {
        return this.elementsToRefresh;
    }

    public RegularIntrospectionTask(@NotNull String dataSourceId, @NotNull String databaseName, @NotNull Collection<? extends ObjectPath> elementsToRefresh) {
        Intrinsics.checkNotNullParameter((Object)dataSourceId, (String)"dataSourceId");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter(elementsToRefresh, (String)"elementsToRefresh");
        super(dataSourceId, null);
        this.databaseName = databaseName;
        this.elementsToRefresh = elementsToRefresh;
        IntrospectionTaskInnerHelper.INSTANCE.recordCreation$intellij_database_core_impl(this);
    }

    @NotNull
    public String toString() {
        int n = this.elementsToRefresh.size();
        StringBuilder b = new StringBuilder(n * 32);
        b.append("Regular introspect ").append(n).append(" element(s) ").append(this.getDatabaseDisplayName()).append(':');
        for (ObjectPath e : this.elementsToRefresh) {
            b.append("\n\t\t+ ").append(e.toString());
        }
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

