/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.redis.model.RedisKey;
import com.intellij.database.dialects.redis.model.properties.RedisKeyType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001)B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u0012J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\rJ\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016J$\u0010 \u001a\u000e\u0018\u00010!\u00a2\u0006\u0002\b\"\u00a2\u0006\u0002\b#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\rH\u0016J\u001a\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/database/dialects/redis/model/RedisModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "<init>", "()V", "STRING_VARIANT", "Lcom/intellij/database/dialects/redis/model/RedisModelHelper$RedisKeyVariant;", "LIST_VARIANT", "SET_VARIANT", "SORTED_SET_VARIANT", "HASH_TABLE_VARIANT", "STREAM_VARIANT", "JSON_DOCUMENT_VARIANT", "isRedisKeyOfType", "", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "types", "", "Lcom/intellij/database/dialects/redis/model/properties/RedisKeyType;", "(Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;[Lcom/intellij/database/dialects/redis/model/properties/RedisKeyType;)Z", "getVariant", "c", "Lcom/intellij/database/model/DasObject;", "getKeyVariant", "keyType", "getKeyVariants", "", "nativeOnly", "generationVariants", "Lcom/intellij/util/containers/JBIterable;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "getCustomName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "kind", "Lcom/intellij/database/model/ObjectKind;", "plural", "getIcon", "Ljavax/swing/Icon;", "RedisKeyVariant", "intellij.database.dialects.redis"})
@SourceDebugExtension(value={"SMAP\nRedisModelHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisModelHelper.kt\ncom/intellij/database/dialects/redis/model/RedisModelHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1#2:94\n1#2:108\n774#3:95\n865#3,2:96\n1617#3,9:98\n1869#3:107\n1870#3:109\n1626#3:110\n*S KotlinDebug\n*F\n+ 1 RedisModelHelper.kt\ncom/intellij/database/dialects/redis/model/RedisModelHelper\n*L\n58#1:108\n57#1:95\n57#1:96,2\n58#1:98,9\n58#1:107\n58#1:109\n58#1:110\n*E\n"})
public final class RedisModelHelper
extends ModelHelper {
    @NotNull
    public static final RedisModelHelper INSTANCE = new RedisModelHelper();
    @NotNull
    private static final RedisKeyVariant STRING_VARIANT;
    @NotNull
    private static final RedisKeyVariant LIST_VARIANT;
    @NotNull
    private static final RedisKeyVariant SET_VARIANT;
    @NotNull
    private static final RedisKeyVariant SORTED_SET_VARIANT;
    @NotNull
    private static final RedisKeyVariant HASH_TABLE_VARIANT;
    @NotNull
    private static final RedisKeyVariant STREAM_VARIANT;
    @NotNull
    private static final RedisKeyVariant JSON_DOCUMENT_VARIANT;

    private RedisModelHelper() {
    }

    public final boolean isRedisKeyOfType(@NotNull ModelHelper.ObjectKindVariant variant, RedisKeyType ... types) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        RedisKeyVariant redisKeyVariant = variant instanceof RedisKeyVariant ? (RedisKeyVariant)variant : null;
        if (redisKeyVariant == null) {
            return false;
        }
        RedisKeyVariant keyVariant = redisKeyVariant;
        return ArraysKt.contains((Object[])types, (Object)((Object)keyVariant.getType()));
    }

    @NotNull
    public ModelHelper.ObjectKindVariant getVariant(@NotNull DasObject c) {
        ModelHelper.ObjectKindVariant keyVariant;
        ModelHelper.ObjectKindVariant objectKindVariant;
        ModelHelper.ObjectKindVariant objectKindVariant2;
        RedisKeyType keyType;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        RedisKey redisKey = c instanceof RedisKey ? (RedisKey)c : null;
        RedisKeyType redisKeyType = keyType = redisKey != null ? redisKey.getType() : null;
        if (redisKeyType != null) {
            RedisKeyType it = redisKeyType;
            boolean bl = false;
            objectKindVariant2 = INSTANCE.getKeyVariant(it);
        } else {
            objectKindVariant2 = null;
        }
        if ((objectKindVariant = (keyVariant = objectKindVariant2)) == null) {
            ModelHelper.ObjectKindVariant objectKindVariant3 = super.getVariant(c);
            objectKindVariant = objectKindVariant3;
            Intrinsics.checkNotNullExpressionValue((Object)objectKindVariant3, (String)"getVariant(...)");
        }
        return objectKindVariant;
    }

    @Nullable
    public final ModelHelper.ObjectKindVariant getKeyVariant(@NotNull RedisKeyType keyType) {
        RedisKeyVariant redisKeyVariant;
        RedisKeyVariant keyVariant;
        Intrinsics.checkNotNullParameter((Object)((Object)keyType), (String)"keyType");
        RedisKeyVariant redisKeyVariant2 = keyVariant = (switch (WhenMappings.$EnumSwitchMapping$0[keyType.ordinal()]) {
            case 1 -> STRING_VARIANT;
            case 2 -> LIST_VARIANT;
            case 3 -> SET_VARIANT;
            case 4 -> SORTED_SET_VARIANT;
            case 5 -> HASH_TABLE_VARIANT;
            case 6 -> STREAM_VARIANT;
            case 7 -> JSON_DOCUMENT_VARIANT;
            case 8 -> null;
            default -> throw new NoWhenBranchMatchedException();
        });
        if (redisKeyVariant2 != null) {
            RedisKeyVariant redisKeyVariant3;
            RedisKeyVariant it = redisKeyVariant3 = redisKeyVariant2;
            boolean bl = false;
            redisKeyVariant = it.getType() == keyType ? redisKeyVariant3 : null;
        } else {
            redisKeyVariant = null;
        }
        return redisKeyVariant;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ModelHelper.ObjectKindVariant> getKeyVariants(boolean nativeOnly) {
        void $this$mapNotNullTo$iv$iv;
        List list;
        Iterable $this$filterTo$iv$iv;
        Collection destination$iv$iv;
        EnumEntries<RedisKeyType> allTypes = RedisKeyType.getEntries();
        if (nativeOnly) {
            Iterable $this$filter$iv = (Iterable)allTypes;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RedisKeyType it = (RedisKeyType)((Object)element$iv$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)RedisKeyType.Companion.isNative(it), (Object)true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = (List)allTypes;
        }
        List types = list;
        Iterable $this$mapNotNull$iv = types;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ModelHelper.ObjectKindVariant it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RedisKeyType it = (RedisKeyType)((Object)element$iv$iv);
            boolean bl2 = false;
            if (INSTANCE.getKeyVariant(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getKeyVariants$default(RedisModelHelper redisModelHelper, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return redisModelHelper.getKeyVariants(bl);
    }

    @NotNull
    public JBIterable<ModelHelper.ObjectKindVariant> generationVariants(@NotNull BasicMetaObject<?> meta) {
        JBIterable jBIterable;
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        if (Intrinsics.areEqual((Object)meta.kind, (Object)ObjectKind.REDIS_KEY)) {
            jBIterable = UtilKt.asJBIterable((Iterable)RedisModelHelper.getKeyVariants$default(this, false, 1, null));
        } else {
            JBIterable jBIterable2 = super.generationVariants(meta);
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"generationVariants(...)");
        }
        return jBIterable;
    }

    @Nullable
    public String getCustomName(@NotNull ObjectKind kind, boolean plural) {
        String string;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEMA)) {
            Object[] objectArray = new Object[]{plural ? 2 : 1};
            string = DatabaseBundle.message((String)"CustomObjectKind.database", (Object[])objectArray);
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.REDIS_KEY)) {
            Object[] objectArray = new Object[]{plural ? 2 : 1};
            string = DatabaseBundle.message((String)"CustomObjectKind.key", (Object[])objectArray);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public Icon getIcon(@NotNull ObjectKind kind, @NotNull ModelHelper.ObjectKindVariant variant) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEMA)) {
            icon = this.getIcon(ObjectKind.DATABASE);
        } else {
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.REDIS_KEY)) {
                RedisKeyType keyType;
                RedisKeyVariant redisKeyVariant = variant instanceof RedisKeyVariant ? (RedisKeyVariant)variant : null;
                RedisKeyType redisKeyType = keyType = redisKeyVariant != null ? redisKeyVariant.getType() : null;
                return switch (redisKeyType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[redisKeyType.ordinal()]) {
                    case 1 -> DatabaseIcons.StringKey;
                    case 2 -> DatabaseIcons.ListKey;
                    case 3 -> DatabaseIcons.SetKey;
                    case 4 -> DatabaseIcons.SortedSetKey;
                    case 5 -> DatabaseIcons.HashTableKey;
                    case 6 -> DatabaseIcons.StreamKey;
                    case 7 -> DatabaseIcons.JsonDocumentKey;
                    case -1, 8 -> DatabaseIcons.CollectionKey;
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
            icon = super.getIcon(kind, variant);
        }
        return icon;
    }

    static {
        Supplier supplier = DatabaseBundle.messagePointer((String)"ObjectKindVariant.string", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
        STRING_VARIANT = new RedisKeyVariant(RedisKeyType.STRING, supplier);
        Supplier supplier2 = DatabaseBundle.messagePointer((String)"ObjectKindVariant.list", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"messagePointer(...)");
        LIST_VARIANT = new RedisKeyVariant(RedisKeyType.LIST, supplier2);
        Supplier supplier3 = DatabaseBundle.messagePointer((String)"ObjectKindVariant.set", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier3, (String)"messagePointer(...)");
        SET_VARIANT = new RedisKeyVariant(RedisKeyType.SET, supplier3);
        Supplier supplier4 = DatabaseBundle.messagePointer((String)"ObjectKindVariant.sorted.set", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier4, (String)"messagePointer(...)");
        SORTED_SET_VARIANT = new RedisKeyVariant(RedisKeyType.SORTED_SET, supplier4);
        Supplier supplier5 = DatabaseBundle.messagePointer((String)"ObjectKindVariant.hash.table", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier5, (String)"messagePointer(...)");
        HASH_TABLE_VARIANT = new RedisKeyVariant(RedisKeyType.HASH_TABLE, supplier5);
        Supplier supplier6 = DatabaseBundle.messagePointer((String)"ObjectKindVariant.stream", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier6, (String)"messagePointer(...)");
        STREAM_VARIANT = new RedisKeyVariant(RedisKeyType.STREAM, supplier6);
        Supplier supplier7 = DatabaseBundle.messagePointer((String)"ObjectKindVariant.json.document", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier7, (String)"messagePointer(...)");
        JSON_DOCUMENT_VARIANT = new RedisKeyVariant(RedisKeyType.JSON_DOCUMENT, supplier7);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\"\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0011\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/redis/model/RedisModelHelper$RedisKeyVariant;", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "type", "Lcom/intellij/database/dialects/redis/model/properties/RedisKeyType;", "name", "Ljava/util/function/Supplier;", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lcom/intellij/database/dialects/redis/model/properties/RedisKeyType;Ljava/util/function/Supplier;)V", "getType", "()Lcom/intellij/database/dialects/redis/model/properties/RedisKeyType;", "intellij.database.dialects.redis"})
    public static final class RedisKeyVariant
    extends ModelHelper.ObjectKindVariant {
        @NotNull
        private final RedisKeyType type;

        public RedisKeyVariant(@NotNull RedisKeyType type, @NotNull Supplier<String> name2) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter(name2, (String)"name");
            super(name2);
            this.type = type;
        }

        @NotNull
        public final RedisKeyType getType() {
            return this.type;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RedisKeyType.values().length];
            try {
                nArray[RedisKeyType.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedisKeyType.LIST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedisKeyType.SET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedisKeyType.SORTED_SET.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedisKeyType.HASH_TABLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedisKeyType.STREAM.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedisKeyType.JSON_DOCUMENT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedisKeyType.OTHER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

