/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.editing;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.service.JSLanguageServiceProvider;
import com.intellij.lang.typescript.editing.TypeScriptServiceInlayHintsService;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Collection;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptServiceInlayHintsPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/Editor;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "doCollectInformation", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "isInlayHintPassCandidate", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDelay", "", "doApplyInformationToEditor", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nTypeScriptServiceInlayHintsPassFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptServiceInlayHintsPassFactory.kt\ncom/intellij/lang/typescript/editing/TypeScriptServiceInlayHintsPass\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n30#2,2:85\n1761#3,3:87\n*S KotlinDebug\n*F\n+ 1 TypeScriptServiceInlayHintsPassFactory.kt\ncom/intellij/lang/typescript/editing/TypeScriptServiceInlayHintsPass\n*L\n39#1:85,2\n62#1:87,3\n*E\n"})
public final class TypeScriptServiceInlayHintsPass
extends TextEditorHighlightingPass {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;

    public TypeScriptServiceInlayHintsPass(@NotNull Project project, @NotNull Document document, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(project, document);
        this.project = project;
        this.editor = editor;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        VirtualFile file = this.editor.getVirtualFile();
        if (file != null && this.isInlayHintPassCandidate(file)) {
            if (TypeScriptServiceInlayHintsService.Companion.getTestHints$intellij_javascript_backend()) {
                VirtualFile virtualFile = this.editor.getVirtualFile();
                Intrinsics.checkNotNull((Object)virtualFile);
                TypeScriptServiceInlayHintsService.RenderHintsRequest request2 = new TypeScriptServiceInlayHintsService.RenderHintsRequest(virtualFile, 0, true);
                ComponentManager $this$service$iv = (ComponentManager)this.project;
                boolean $i$f$service = false;
                Class<TypeScriptServiceInlayHintsService> serviceClass$iv = TypeScriptServiceInlayHintsService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((TypeScriptServiceInlayHintsService)object).enqueueRenderHints(request2);
                long start = System.currentTimeMillis();
                do {
                    progress.checkCanceled();
                    Thread.sleep(1L);
                    if (System.currentTimeMillis() - start <= 20000L) continue;
                    throw new TimeoutException("Inlay hints rendering exceeded timeout 20s");
                } while (request2.getState() != TypeScriptServiceInlayHintsService.RenderHintsRequestState.Done);
            } else {
                TypeScriptServiceInlayHintsService typeScriptServiceInlayHintsService = (TypeScriptServiceInlayHintsService)this.project.getService(TypeScriptServiceInlayHintsService.class);
                VirtualFile virtualFile = this.editor.getVirtualFile();
                Intrinsics.checkNotNull((Object)virtualFile);
                Document document = this.editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                typeScriptServiceInlayHintsService.enqueueRenderHints(new TypeScriptServiceInlayHintsService.RenderHintsRequest(virtualFile, this.getDelay(file, document), false, 4, null));
            }
        }
    }

    private final boolean isInlayHintPassCandidate(VirtualFile file) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = JSLanguageServiceProvider.Companion.getProviders(this.project);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JSLanguageServiceProvider it = (JSLanguageServiceProvider)element$iv;
                    boolean bl2 = false;
                    if (!it.isHighlightingCandidate(file)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final int getDelay(VirtualFile file, Document document) {
        int base = Registry.Companion.intValue("typescript.service.provideInlayHints.passDelayMs");
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(file);
        if (psiFile == null) {
            return base;
        }
        PsiFile psiFile2 = psiFile;
        int additionalDelayPer1000Lines = DialectDetector.isJSX((PsiElement)((PsiElement)psiFile2)) ? Registry.Companion.intValue("typescript.service.provideInlayHints.additionalPassDelayPer1000LinesMs.jsx") : Registry.Companion.intValue("typescript.service.provideInlayHints.additionalPassDelayPer1000LinesMs");
        return (int)Math.min((long)Registry.Companion.intValue("typescript.service.provideInlayHints.maxPassDelayMs"), (long)base + (long)document.getLineCount() * (long)additionalDelayPer1000Lines / (long)1000);
    }

    public void doApplyInformationToEditor() {
    }
}

