/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.ui;

import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElement;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;

public class JSClassCellRenderer
extends DefaultListCellRenderer {
    private final boolean myShowReadOnly;

    public JSClassCellRenderer() {
        this.setOpaque(true);
        this.myShowReadOnly = true;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        return JSClassCellRenderer.customizeRenderer(this, value, this.myShowReadOnly);
    }

    public static JLabel customizeRenderer(JLabel cellRendererComponent, Object value, boolean showReadOnly) {
        Icon icon;
        JSClass aClass = (JSClass)value;
        cellRendererComponent.setText(new JSNamedElementPresenter((PsiElement)aClass).getQualifiedName());
        int flags = 1;
        if (showReadOnly) {
            flags |= 2;
        }
        if ((icon = aClass.getIcon(flags)) != null) {
            cellRendererComponent.setIcon(icon);
        }
        return cellRendererComponent;
    }
}

