/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSSeparateDigitsIntention
extends JavaScriptIntention {
    @IntentionName
    private String myText = JavaScriptBundle.message((String)"js.separate.digits", (Object[])new Object[0]);

    private static int getComplicatedPartIndex(String text) {
        return StringUtil.indexOfAny((String)text, (String)"eE.");
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        boolean available;
        if (project == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element2)) {
            return false;
        }
        PsiElement parent = element2.getParent();
        boolean bl = available = parent instanceof JSLiteralExpression && ((JSLiteralExpression)parent).isNumericLiteral() && (DialectDetector.isES6((PsiElement)element2) || DialectDetector.isTypeScript((PsiElement)element2));
        if (!available) {
            return false;
        }
        String text = parent.getText();
        if (text.indexOf(95) != -1) {
            return false;
        }
        LiteralKind kind = LiteralKind.fromLiteralText(text);
        if (kind.isUnsupported()) {
            return false;
        }
        if (kind == LiteralKind.ComplicatedDec) {
            int index = JSSeparateDigitsIntention.getComplicatedPartIndex(text);
            assert (index != -1);
            text = text.substring(0, index);
        }
        if (text.length() - kind.getStartOffset() <= kind.getSeparationSize()) {
            return false;
        }
        this.myText = JavaScriptBundle.message((String)kind.getBundleId(), (Object[])new Object[0]);
        return true;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (project == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(4);
        }
        PsiElement parent = element2.getParent();
        assert (parent instanceof JSLiteralExpression);
        String text = parent.getText();
        LiteralKind literalKind = LiteralKind.fromLiteralText(text);
        JSLiteralExpression result2 = JSSeparateDigitsIntention.transform(text, literalKind, parent);
        ((JSLiteralExpression)parent).replace((JSExpression)result2);
    }

    private static JSLiteralExpression transform(String text, LiteralKind kind, PsiElement context2) {
        String postfix = "";
        if (kind == LiteralKind.ComplicatedDec) {
            int index = JSSeparateDigitsIntention.getComplicatedPartIndex(text);
            assert (index != -1);
            postfix = text.substring(index);
            text = text.substring(0, index);
        }
        int offset = text.startsWith("-") ? 1 : 0;
        String prefix = text.substring(0, offset += kind.getStartOffset());
        StringBuilder newString = new StringBuilder();
        int j = 0;
        for (int i = text.length() - 1; i > offset; --i) {
            newString.insert(0, text.charAt(i));
            if (++j % kind.getSeparationSize() != 0) continue;
            newString.insert(0, '_');
        }
        newString.insert(0, text.charAt(offset));
        newString.insert(0, prefix);
        newString.append(postfix);
        return (JSLiteralExpression)JSPsiElementFactory.createJSExpression((String)newString.toString(), (PsiElement)context2, JSLiteralExpression.class);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"js.separate.digits", (Object[])new Object[0]);
        if (string == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSSeparateDigitsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSSeparateDigitsIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }

    static enum LiteralKind {
        Boolean,
        LargeBoolean,
        Hex,
        LargeHex,
        Dec,
        Oct,
        ObsoleteOct,
        ComplicatedDec;


        public static LiteralKind fromLiteralText(String text) {
            if (text.startsWith("0b")) {
                return text.length() - 2 > 16 ? LargeBoolean : Boolean;
            }
            if (text.startsWith("0x")) {
                return text.length() - 2 > 8 ? LargeHex : Hex;
            }
            if (text.startsWith("0o")) {
                return Oct;
            }
            if (text.length() >= 2 && text.charAt(0) == '\u0000' && StringUtil.isOctalDigit((char)text.charAt(1))) {
                return ObsoleteOct;
            }
            return JSSeparateDigitsIntention.getComplicatedPartIndex(text) != -1 ? ComplicatedDec : Dec;
        }

        public String getBundleId() {
            return switch (this.ordinal()) {
                case 0 -> "js.separate.nibbles";
                case 1 -> "js.separate.bytes";
                case 2 -> "js.separate.bytes";
                case 3 -> "js.separate.words";
                case 4 -> "js.separate.thousands";
                case 7 -> "js.separate.thousands.in.integer.part";
                default -> throw new NotImplementedError(this.toString());
            };
        }

        public int getStartOffset() {
            return switch (this.ordinal()) {
                case 0, 1, 2, 3 -> 2;
                case 4, 7 -> 0;
                default -> throw new NotImplementedError(this.toString());
            };
        }

        public int getSeparationSize() {
            return switch (this.ordinal()) {
                case 0 -> 4;
                case 1 -> 8;
                case 2 -> 2;
                case 3 -> 4;
                case 4, 7 -> 3;
                default -> throw new NotImplementedError(this.toString());
            };
        }

        public boolean isUnsupported() {
            return this == Oct || this == ObsoleteOct;
        }
    }
}

