/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editor;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.findUsages.JSQualifiedNameProvider;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.xml.breadcrumbs.XmlLanguageBreadcrumbsInfoProvider;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBreadcrumbsProvider
implements BreadcrumbsProvider {
    public Language[] getLanguages() {
        return new Language[]{JavascriptLanguage.INSTANCE, JavaScriptSupportLoader.TYPESCRIPT};
    }

    public boolean acceptElement(@NotNull PsiElement element2) {
        JSQualifiedNamedElement assignedTo;
        if (element2 == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(0);
        }
        if (element2 instanceof JSXmlLiteralExpression) {
            return true;
        }
        if (element2 instanceof JSSwitchStatement) {
            return true;
        }
        if (!(element2 instanceof JSQualifiedNamedElement)) {
            return false;
        }
        if (element2 instanceof JSDefinitionExpression && ((JSDefinitionExpression)element2).getExpression() instanceof JSIndexedPropertyAccessExpression) {
            return false;
        }
        return !(element2 instanceof JSExpression) || (assignedTo = JSPsiImplUtils.getInitializedElement((JSExpression)((JSExpression)element2))) == null;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement element2) {
        JSExpression expression;
        if (element2 == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(1);
        }
        if (element2 instanceof JSXmlLiteralExpression) {
            String string = XmlLanguageBreadcrumbsInfoProvider.getInfo((PsiElement)element2);
            if (string == null) {
                JSBreadcrumbsProvider.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (element2 instanceof JSSwitchStatement) {
            JSExpression expression2 = ((JSSwitchStatement)element2).getSwitchExpression();
            String expr = expression2 != null ? StringUtil.trimLog((String)expression2.getText(), (int)20) : "...";
            String string = "switch (" + expr + ")";
            if (string == null) {
                JSBreadcrumbsProvider.$$$reportNull$$$0(3);
            }
            return string;
        }
        String callbackPresentation = JSBreadcrumbsProvider.getCallbackPresentation(element2);
        if (callbackPresentation != null) {
            String string = callbackPresentation;
            if (string == null) {
                JSBreadcrumbsProvider.$$$reportNull$$$0(4);
            }
            return string;
        }
        StringBuilder builder2 = new StringBuilder();
        String name = null;
        if (!(!(element2 instanceof JSDefinitionExpression) || (expression = ((JSDefinitionExpression)element2).getExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() instanceof JSThisExpression)) {
            name = ((JSDefinitionExpression)element2).getQualifiedName();
        }
        if (name == null && element2 instanceof JSQualifiedNamedElement) {
            name = ((JSQualifiedNamedElement)element2).getName();
        }
        if (name != null && (name.startsWith("[Symbol.") || name.indexOf(46) == -1)) {
            name = JSSymbolUtil.quoteIfSpecialPropertyName((String)name, (boolean)JSUtils.isPrivateSharpItem((PsiElement)element2), (char)'\"');
        }
        if (name == null) {
            name = JSFormatUtil.getAnonymousElementPresentation();
        }
        builder2.append(name);
        if (element2 instanceof JSFunction || element2 instanceof JSInitializerOwner && ((JSInitializerOwner)element2).getInitializer() instanceof JSFunction) {
            builder2.append("()");
        }
        String string = builder2.toString();
        if (string == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    @Nls
    public static String getCallbackPresentation(@NotNull PsiElement element2) {
        PsiElement psiElement;
        if (element2 == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(6);
        }
        if (!(element2 instanceof JSFunctionExpression) || ((JSFunctionExpression)element2).getName() != null) {
            return null;
        }
        PsiElement parent = element2.getParent();
        if (!(parent instanceof JSArgumentList) || !((psiElement = parent.getParent()) instanceof JSCallExpression)) {
            return null;
        }
        JSCallExpression callExpression = (JSCallExpression)psiElement;
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression == null) {
            return null;
        }
        IntRef maxActualChars = new IntRef(methodExpression.getTextLength());
        Object shortened = JSBreadcrumbsProvider.printLeaves(PsiTreeUtil.getDeepestFirst((PsiElement)methodExpression), true, 30, maxActualChars);
        if (maxActualChars.get() > 0) {
            String suffix = JSBreadcrumbsProvider.printLeaves(PsiTreeUtil.getDeepestLast((PsiElement)methodExpression), false, 10, maxActualChars);
            if (maxActualChars.get() > 0) {
                shortened = (String)shortened + "...";
            }
            shortened = (String)shortened + suffix;
        }
        String argumentsPresentation = JSBreadcrumbsProvider.getArgumentsPresentation(callExpression.getArguments());
        return JavaScriptBundle.message((String)"js.breadcrumbs.callback.for", (Object[])new Object[]{shortened, argumentsPresentation});
    }

    @NotNull
    private static String getArgumentsPresentation(JSExpression @NotNull [] arguments) {
        JSLiteralExpression literalExpression;
        if (arguments == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(7);
        }
        if (arguments.length == 0) {
            return "";
        }
        StringBuilder builder2 = new StringBuilder();
        JSExpression argument0 = arguments[0];
        if (argument0.getTextLength() <= 20 && !(argument0 instanceof JSFunction) || argument0 instanceof JSLiteralExpression && (literalExpression = (JSLiteralExpression)argument0).isStringLiteral()) {
            builder2.append(argument0.getText().replace('\n', ' '));
            if (arguments.length > 1) {
                builder2.append(", ...");
            }
        }
        String string = builder2.toString();
        if (string == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String printLeaves(@NotNull PsiElement leaf, boolean forward, int maxChars, @NotNull IntRef maxActualChars) {
        if (leaf == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(9);
        }
        if (maxActualChars == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(10);
        }
        StringBuilder result2 = new StringBuilder();
        while (leaf != null) {
            String append;
            String string = leaf instanceof PsiWhiteSpace ? " " : (append = leaf instanceof PsiComment ? "" : leaf.getText());
            if (result2.length() + append.length() > maxChars || !result2.isEmpty() && maxActualChars.get() - leaf.getTextLength() < 0) break;
            if (forward) {
                result2.append(append);
            } else {
                result2.insert(0, append);
            }
            maxActualChars.set(maxActualChars.get() - leaf.getTextLength());
            leaf = forward ? PsiTreeUtil.nextLeaf((PsiElement)leaf) : PsiTreeUtil.prevLeaf((PsiElement)leaf);
        }
        String string = result2.toString();
        if (string == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(12);
        }
        return element2 instanceof JSXmlLiteralExpression ? XmlLanguageBreadcrumbsInfoProvider.getTooltip((XmlTag)((XmlTag)element2)) : null;
    }

    @Nullable
    public PsiElement getParent(@NotNull PsiElement element2) {
        JSQualifiedNamedElement initializedElement;
        if (element2 == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(13);
        }
        if (element2 instanceof JSExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)((JSExpression)element2))) instanceof JSDefinitionExpression) {
            return initializedElement;
        }
        return element2.getParent();
    }

    @NotNull
    public List<? extends Action> getContextActions(final @NotNull PsiElement element2) {
        if (element2 == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(14);
        }
        List<1> list = Collections.singletonList(new AbstractAction(JavaScriptBundle.message((String)"js.copy.qualified.to.clipboard", (Object[])new Object[0])){

            @NotNull
            private static PsiElement evaluateElement(@NotNull PsiElement element22) {
                PsiElement resolved;
                PsiReference reference;
                if (element22 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element22 instanceof JSXmlLiteralExpression && (reference = element22.getReference()) != null && (resolved = reference.resolve()) != null) {
                    PsiElement psiElement = resolved;
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return psiElement;
                }
                PsiElement psiElement = element22;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiElement;
            }

            @Override
            public boolean isEnabled() {
                return !DumbService.isDumb((Project)element2.getProject()) && new JSQualifiedNameProvider().getQualifiedName(1.evaluateElement(element2)) != null;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String qualifiedName = new JSQualifiedNameProvider().getQualifiedName(1.evaluateElement(element2));
                if (qualifiedName != null) {
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(qualifiedName));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "evaluateElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "evaluateElement";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        });
        if (list == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(15);
        }
        return list;
    }

    public boolean isShownByDefault() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 8, 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxActualChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsPresentation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "printLeaves";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCallbackPresentation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentsPresentation";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "printLeaves";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getElementTooltip";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContextActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 8, 11, 15 -> new IllegalStateException(string);
        };
    }
}

