/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer.actions;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.BaseSourceMapAction;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.VisualizeSourceMapActionKt;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/visualizer/actions/VisualizeSourceMapAction;", "Lcom/intellij/javascript/debugger/sourcemap/visualizer/actions/BaseSourceMapAction;", "<init>", "()V", "perform", "", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.debugger.backend"})
public final class VisualizeSourceMapAction
extends BaseSourceMapAction {
    @Override
    protected void perform(@NotNull SourceMap sourceMap, @NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile generatedFile = null;
        if (sourceMap.getOutFile() == null) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String fileName = string;
            if (StringsKt.endsWith$default((String)fileName, (String)".map", (boolean)false, (int)2, null)) {
                generatedFile = file.getParent().findChild(StringsKt.removeSuffix((String)fileName, (CharSequence)".map"));
            }
        } else {
            VirtualFile virtualFile = file.getParent();
            String string = sourceMap.getOutFile();
            Intrinsics.checkNotNull((Object)string);
            VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(string);
            if (virtualFile2 == null) {
                String string2 = sourceMap.getOutFile();
                Intrinsics.checkNotNull((Object)string2);
                virtualFile2 = generatedFile = LocalFileFinder.findFile((String)string2);
            }
        }
        if (generatedFile == null) {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)((FileType)JavaScriptFileType.INSTANCE));
            descriptor.setTitle(JSDebuggerBundle.message("js.scripts.visualize.select.generated", new Object[0]));
            FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)file.getParent(), arg_0 -> VisualizeSourceMapAction.perform$lambda$1(arg_0 -> VisualizeSourceMapAction.perform$lambda$0(sourceMap, project, arg_0), arg_0));
        } else {
            VisualizeSourceMapActionKt.visualizeMap$default(sourceMap, generatedFile, null, project, null, 16, null);
        }
    }

    private static final Unit perform$lambda$0(SourceMap $sourceMap, Project $project, VirtualFile it) {
        Intrinsics.checkNotNull((Object)it);
        VisualizeSourceMapActionKt.visualizeMap$default($sourceMap, it, null, $project, null, 16, null);
        return Unit.INSTANCE;
    }

    private static final void perform$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

