/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebBrowserUrlProviderKt;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J$\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/debugger/BuiltInWebServerFileUrlMapper;", "Lcom/jetbrains/javascript/debugger/FileUrlMapper;", "<init>", "()V", "getUrls", "", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "currentAuthority", "", "getFile", "url", "requestor", "intellij.javascript.debugger.backend"})
final class BuiltInWebServerFileUrlMapper
extends FileUrlMapper {
    @NotNull
    public List<Url> getUrls(@NotNull VirtualFile file, @NotNull Project project, @Nullable String currentAuthority) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls$default((VirtualFile)file, (Project)project, (String)currentAuthority, (boolean)false, null, (int)16, null);
    }

    @Nullable
    public VirtualFile getFile(@NotNull Url url, @NotNull Project project, @Nullable Url requestor) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!BuiltInWebBrowserUrlProviderKt.compareAuthority((String)url.getAuthority())) {
            return null;
        }
        String string2 = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String projectName = string2;
        String string3 = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        String path = string3;
        if (!StringsKt.regionMatches((String)path, (int)1, (String)projectName, (int)0, (int)projectName.length(), (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0) && !BuiltInWebServerKt.compareNameAndProjectBasePath((String)projectName, (Project)project)) {
            return null;
        }
        int offset = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)1, (boolean)false, (int)4, null);
        WebServerPathToFileManager webServerPathToFileManager = WebServerPathToFileManager.Companion.getInstance(project);
        if (offset == -1 || offset == path.length() - 1) {
            string = "";
        } else {
            String string4 = path.substring(offset + 1);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        }
        return WebServerPathToFileManager.findVirtualFile$default((WebServerPathToFileManager)webServerPathToFileManager, (String)string, (boolean)false, null, (int)6, null);
    }
}

