/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class WCInfo {
    private final boolean myIsWcRoot;
    @NotNull
    private final Depth myStickyDepth;
    @NotNull
    private final RootUrlInfo myRootInfo;

    public WCInfo(@NotNull RootUrlInfo rootInfo, boolean isWcRoot, @NotNull Depth stickyDepth) {
        if (rootInfo == null) {
            WCInfo.$$$reportNull$$$0(0);
        }
        if (stickyDepth == null) {
            WCInfo.$$$reportNull$$$0(1);
        }
        this.myRootInfo = rootInfo;
        this.myIsWcRoot = isWcRoot;
        this.myStickyDepth = stickyDepth;
    }

    @NotNull
    public Depth getStickyDepth() {
        Depth depth = this.myStickyDepth;
        if (depth == null) {
            WCInfo.$$$reportNull$$$0(2);
        }
        return depth;
    }

    @NlsSafe
    @NotNull
    public String getPath() {
        String string = this.myRootInfo.getPath();
        if (string == null) {
            WCInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public VirtualFile getVcsRoot() {
        return null;
    }

    @NotNull
    public Url getUrl() {
        Url url = this.myRootInfo.getUrl();
        if (url == null) {
            WCInfo.$$$reportNull$$$0(4);
        }
        return url;
    }

    @NotNull
    public Url getRepoUrl() {
        Url url = this.myRootInfo.getRepositoryUrl();
        if (url == null) {
            WCInfo.$$$reportNull$$$0(5);
        }
        return url;
    }

    @NotNull
    public RootUrlInfo getRootInfo() {
        RootUrlInfo rootUrlInfo = this.myRootInfo;
        if (rootUrlInfo == null) {
            WCInfo.$$$reportNull$$$0(6);
        }
        return rootUrlInfo;
    }

    public boolean hasError() {
        return this.getRootInfo().getNode().hasError();
    }

    @Nls
    @NotNull
    public String getErrorMessage() {
        SvnBindException error = this.getRootInfo().getNode().getError();
        return error != null ? error.getMessage() : "";
    }

    @NotNull
    public WorkingCopyFormat getFormat() {
        WorkingCopyFormat workingCopyFormat = this.myRootInfo.getFormat();
        if (workingCopyFormat == null) {
            WCInfo.$$$reportNull$$$0(7);
        }
        return workingCopyFormat;
    }

    public boolean isIsWcRoot() {
        return this.myIsWcRoot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WCInfo)) {
            return false;
        }
        WCInfo wcInfo = (WCInfo)o;
        return this.getPath().equals(wcInfo.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    @Nullable
    public NestedCopyType getType() {
        return this.myRootInfo.getType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stickyDepth";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/WCInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/WCInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStickyDepth";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepoUrl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

