/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.jetbrains.relocated.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.jetbrains.relocated.apache.batik.ext.awt.image.rendered.CachableRed;
import org.jetbrains.relocated.apache.batik.ext.awt.image.rendered.TileStore;

public class TileCacheRed
extends AbstractTiledRed {
    public TileCacheRed(CachableRed cr) {
        super(cr, null);
    }

    public TileCacheRed(CachableRed cr, int tileWidth, int tileHeight) {
        ColorModel cm = cr.getColorModel();
        Rectangle bounds = cr.getBounds();
        if (tileWidth > bounds.width) {
            tileWidth = bounds.width;
        }
        if (tileHeight > bounds.height) {
            tileHeight = bounds.height;
        }
        SampleModel sm = cm.createCompatibleSampleModel(tileWidth, tileHeight);
        this.init(cr, bounds, cm, sm, cr.getTileGridXOffset(), cr.getTileGridYOffset(), null);
    }

    @Override
    public void genRect(WritableRaster wr) {
        CachableRed src = (CachableRed)this.getSources().get(0);
        src.copyData(wr);
    }

    public void flushCache(Rectangle rect2) {
        int tx0 = this.getXTile(rect2.x);
        int ty0 = this.getYTile(rect2.y);
        int tx1 = this.getXTile(rect2.x + rect2.width - 1);
        int ty1 = this.getYTile(rect2.y + rect2.height - 1);
        if (tx0 < this.minTileX) {
            tx0 = this.minTileX;
        }
        if (ty0 < this.minTileY) {
            ty0 = this.minTileY;
        }
        if (tx1 >= this.minTileX + this.numXTiles) {
            tx1 = this.minTileX + this.numXTiles - 1;
        }
        if (ty1 >= this.minTileY + this.numYTiles) {
            ty1 = this.minTileY + this.numYTiles - 1;
        }
        if (tx1 < tx0 || ty1 < ty0) {
            return;
        }
        TileStore store = this.getTileStore();
        for (int y2 = ty0; y2 <= ty1; ++y2) {
            for (int x2 = tx0; x2 <= tx1; ++x2) {
                store.setTile(x2, y2, null);
            }
        }
    }
}

