/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.datetime.DateTime;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkHelper;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkPredicate;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunksList;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunksListForWrite;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkITXT;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkPHYS;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkPLTE;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkTEXT;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkTIME;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkTRNS;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkTextVar;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkZTXT;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010 \u001a\u00020\u000fJ\u0006\u0010!\u001a\u00020\u0015J\u0010\u0010\"\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010\u001dJ\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\b\u0010#\u001a\u0004\u0018\u00010\u001dH\u0002J\u001a\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020\u0013H\u0007J\u000e\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020.J\u0018\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0002J\u001a\u00100\u001a\u00020&2\b\u0010#\u001a\u0004\u0018\u00010\u001d2\b\u00101\u001a\u0004\u0018\u00010\u001dJ,\u00100\u001a\u00020&2\b\u0010#\u001a\u0004\u0018\u00010\u001d2\b\u00101\u001a\u0004\u0018\u00010\u001d2\u0006\u00102\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u0013H\u0002J\u000e\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u000206J6\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u0002092\u0006\u0010;\u001a\u0002092\u0006\u0010<\u001a\u0002092\u0006\u0010=\u001a\u0002092\u0006\u0010>\u001a\u000209R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006?"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngMetadata;", "", "chunks", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunksList;", "(Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunksList;)V", "chunkList", "chunkListW", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunksListForWrite;", "getChunkListW", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunksListForWrite;", "dpi", "", "getDpi", "()[D", "pLTE", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkPLTE;", "getPLTE", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkPLTE;", "readonly", "", "tRNS", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkTRNS;", "getTRNS", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkTRNS;", "time", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkTIME;", "getTime", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkTIME;", "timeAsString", "", "getTimeAsString", "()Ljava/lang/String;", "createPLTEChunk", "createTRNSChunk", "getTxtForKey", "k", "getTxtsForKey", "", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkTextVar;", "queueChunk", "", "c", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk;", "lazyOverwrite", "setDpi", "x", "", "y", "setText", "val", "useLatin1", "compress", "setTimeNow", "dateTime", "Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime;", "setTimeYMDHMS", "yearx", "", "monx", "dayx", "hourx", "minx", "secx", "plot-api"})
@SourceDebugExtension(value={"SMAP\nPngMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PngMetadata.kt\norg/jetbrains/letsPlot/util/pngj/chunks/PngMetadata\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,230:1\n1549#2:231\n1620#2,3:232\n107#3:235\n79#3,22:236\n*S KotlinDebug\n*F\n+ 1 PngMetadata.kt\norg/jetbrains/letsPlot/util/pngj/chunks/PngMetadata\n*L\n177#1:231\n177#1:232,3\n192#1:235\n192#1:236,22\n*E\n"})
public final class PngMetadata {
    @NotNull
    private final ChunksList chunkList;
    private boolean readonly;

    public PngMetadata(@NotNull ChunksList chunks) {
        Intrinsics.checkNotNullParameter((Object)chunks, (String)"chunks");
        this.chunkList = chunks;
        this.readonly = !(chunks instanceof ChunksListForWrite);
    }

    @JvmOverloads
    public final void queueChunk(@NotNull PngChunk c, boolean lazyOverwrite) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        ChunksListForWrite cl = this.getChunkListW();
        if (this.readonly) {
            throw new PngjException("cannot set chunk : readonly metadata");
        }
        if (lazyOverwrite) {
            ChunkHelper.INSTANCE.trimList(cl.getQueuedChunks(), new ChunkPredicate(c){
                final /* synthetic */ PngChunk $c;
                {
                    this.$c = $c;
                }

                public boolean match(@NotNull PngChunk chunk) {
                    Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
                    return ChunkHelper.INSTANCE.equivalent(this.$c, chunk);
                }
            });
        }
        cl.queue(c);
    }

    public static /* synthetic */ void queueChunk$default(PngMetadata pngMetadata, PngChunk pngChunk, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        pngMetadata.queueChunk(pngChunk, bl);
    }

    private final ChunksListForWrite getChunkListW() {
        ChunksList chunksList = this.chunkList;
        Intrinsics.checkNotNull((Object)chunksList, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.util.pngj.chunks.ChunksListForWrite");
        return (ChunksListForWrite)chunksList;
    }

    @NotNull
    public final double[] getDpi() {
        double[] dArray;
        PngChunk c;
        PngChunk pngChunk = c = this.chunkList.getById1("pHYs", true);
        if (pngChunk == null) {
            double[] dArray2 = new double[]{-1.0, -1.0};
            dArray = dArray2;
        } else {
            dArray = ((PngChunkPHYS)pngChunk).getAsDpi2();
        }
        return dArray;
    }

    public final void setDpi(double x2) {
        this.setDpi(x2, x2);
    }

    private final void setDpi(double x2, double y2) {
        PngChunkPHYS c = new PngChunkPHYS(this.chunkList.getImageInfo());
        c.setAsDpi2(x2, y2);
        PngMetadata.queueChunk$default(this, c, false, 2, null);
    }

    @NotNull
    public final PngChunkTIME setTimeNow(@NotNull DateTime dateTime) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        PngChunkTIME c = new PngChunkTIME(this.chunkList.getImageInfo());
        c.setNow(dateTime);
        PngMetadata.queueChunk$default(this, c, false, 2, null);
        return c;
    }

    @NotNull
    public final PngChunkTIME setTimeYMDHMS(int yearx, int monx, int dayx, int hourx, int minx, int secx) {
        PngChunkTIME c = new PngChunkTIME(this.chunkList.getImageInfo());
        c.setYMDHMS(yearx, monx, dayx, hourx, minx, secx);
        this.queueChunk(c, true);
        return c;
    }

    @Nullable
    public final PngChunkTIME getTime() {
        PngChunk pngChunk = this.chunkList.getById1("tIME");
        return pngChunk instanceof PngChunkTIME ? (PngChunkTIME)pngChunk : null;
    }

    @NotNull
    public final String getTimeAsString() {
        Object object = this.getTime();
        if (object == null || (object = ((PngChunkTIME)object).getAsString()) == null) {
            object = "";
        }
        return object;
    }

    private final PngChunkTextVar setText(String k, String val, boolean useLatin1, boolean compress) {
        if (compress && !useLatin1) {
            throw new PngjException("cannot compress non latin text");
        }
        PngChunkTextVar c = useLatin1 ? (compress ? (PngChunkTextVar)new PngChunkZTXT(this.chunkList.getImageInfo()) : (PngChunkTextVar)new PngChunkTEXT(this.chunkList.getImageInfo())) : (PngChunkTextVar)new PngChunkITXT(this.chunkList.getImageInfo());
        c.setKeyVal(k, val);
        this.queueChunk(c, true);
        return c;
    }

    @NotNull
    public final PngChunkTextVar setText(@Nullable String k, @Nullable String val) {
        return this.setText(k, val, false, false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PngChunkTextVar> getTxtsForKey(String k) {
        void $this$mapTo$iv$iv;
        List c = new ArrayList();
        c.addAll((Collection)this.chunkList.getById("tEXt", k));
        c.addAll((Collection)this.chunkList.getById("zTXt", k));
        c.addAll((Collection)this.chunkList.getById("iTXt", k));
        Iterable $this$map$iv = c;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PngChunk pngChunk = (PngChunk)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.util.pngj.chunks.PngChunkTextVar");
            collection.add((PngChunkTextVar)it);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String getTxtForKey(@Nullable String k) {
        List<PngChunkTextVar> li = this.getTxtsForKey(k);
        if (li.isEmpty()) {
            return "";
        }
        StringBuilder t = new StringBuilder();
        for (PngChunkTextVar c : li) {
            t.append(c.getValue()).append("\n");
        }
        String string = t.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    @NotNull
    public final PngChunkPLTE getPLTE() {
        PngChunk pngChunk = this.chunkList.getById1("PLTE");
        Intrinsics.checkNotNull((Object)pngChunk, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.util.pngj.chunks.PngChunkPLTE");
        return (PngChunkPLTE)pngChunk;
    }

    @NotNull
    public final PngChunkPLTE createPLTEChunk() {
        PngChunkPLTE plte = new PngChunkPLTE(this.chunkList.getImageInfo());
        PngMetadata.queueChunk$default(this, plte, false, 2, null);
        return plte;
    }

    @Nullable
    public final PngChunkTRNS getTRNS() {
        PngChunk pngChunk = this.chunkList.getById1("tRNS");
        return pngChunk instanceof PngChunkTRNS ? (PngChunkTRNS)pngChunk : null;
    }

    @NotNull
    public final PngChunkTRNS createTRNSChunk() {
        PngChunkTRNS trns = new PngChunkTRNS(this.chunkList.getImageInfo());
        PngMetadata.queueChunk$default(this, trns, false, 2, null);
        return trns;
    }

    @JvmOverloads
    public final void queueChunk(@NotNull PngChunk c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        PngMetadata.queueChunk$default(this, c, false, 2, null);
    }
}

