/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.plugins.sass.SASSFileType;
import org.jetbrains.plugins.sass.psi.SASSFile;
import org.jetbrains.plugins.sass.psi.impl.ISASSMixinDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssVariable;
import org.jetbrains.plugins.scss.psi.SassScssVariableDeclaration;

public final class SASSElementGenerator {
    private SASSElementGenerator() {
    }

    public static SASSFile createFileFromText(Project project, String text) {
        return (SASSFile)PsiFileFactory.getInstance((Project)project).createFileFromText("foo.sass", (FileType)SASSFileType.SASS, (CharSequence)text);
    }

    public static PsiElement createMixinName(Project project, String name) {
        SASSFile file = SASSElementGenerator.createFileFromText(project, "@mixin " + name + "\n");
        return ((ISASSMixinDeclaration)PsiTreeUtil.findChildOfType((PsiElement)file, ISASSMixinDeclaration.class)).getNameIdentifier();
    }

    public static CssDeclaration createSASSDeclaration(Project project, String name, String value) {
        SASSFile file = SASSElementGenerator.createFileFromText(project, ".border \n  " + name + ": " + value + "\n");
        return (CssDeclaration)PsiTreeUtil.findChildOfType((PsiElement)file, CssDeclaration.class);
    }

    public static SassScssVariableDeclaration createSASSVariableDeclaration(Project project, String name, String value) {
        String assignmentText = "$" + name + ": " + value;
        SASSFile file = SASSElementGenerator.createFileFromText(project, assignmentText);
        return (SassScssVariableDeclaration)PsiTreeUtil.findChildOfType((PsiElement)file, SassScssVariableDeclaration.class);
    }

    public static SassScssVariable createSASSVariable(Project project, String name) {
        return SASSElementGenerator.createSASSVariableDeclaration(project, name, "fake").getNameIdentifier();
    }
}

