/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.compressed;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0016\u0017\u0018B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\rH&JG\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u00010\u000f\"\u0010\b\u0000\u0010\u0011*\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0012\u001a\u0002H\u00112\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u0002H\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0014H\u0004\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0003\u0019\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/profiler/compressed/CompressedDumpDescriptor;", "", "file", "Ljava/io/File;", "compressorName", "", "<init>", "(Ljava/io/File;Ljava/lang/String;)V", "getFile", "()Ljava/io/File;", "getCompressorName", "()Ljava/lang/String;", "createUnderlyingSingleFileInputStream", "Ljava/io/InputStream;", "navigatedToEntry", "Lorg/apache/commons/compress/archivers/ArchiveInputStream;", "Lorg/apache/commons/compress/archivers/ArchiveEntry;", "T", "stream", "nextEntry", "Lkotlin/Function1;", "(Lorg/apache/commons/compress/archivers/ArchiveInputStream;Lkotlin/jvm/functions/Function1;)Lorg/apache/commons/compress/archivers/ArchiveInputStream;", "Commons", "Gz", "TarGz", "Lcom/intellij/profiler/compressed/CompressedDumpDescriptor$Commons;", "Lcom/intellij/profiler/compressed/CompressedDumpDescriptor$Gz;", "Lcom/intellij/profiler/compressed/CompressedDumpDescriptor$TarGz;", "intellij.profiler.common"})
public abstract sealed class CompressedDumpDescriptor {
    @NotNull
    private final File file;
    @NotNull
    private final String compressorName;

    private CompressedDumpDescriptor(File file, String compressorName) {
        this.file = file;
        this.compressorName = compressorName;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final String getCompressorName() {
        return this.compressorName;
    }

    @Nullable
    public abstract InputStream createUnderlyingSingleFileInputStream();

    @Nullable
    protected final <T extends ArchiveInputStream<? extends ArchiveEntry>> ArchiveInputStream<? extends ArchiveEntry> navigatedToEntry(@NotNull T stream, @NotNull Function1<? super T, ? extends ArchiveEntry> nextEntry) {
        Intrinsics.checkNotNullParameter(stream, (String)"stream");
        Intrinsics.checkNotNullParameter(nextEntry, (String)"nextEntry");
        ArchiveEntry entry = (ArchiveEntry)nextEntry.invoke(stream);
        while (entry != null) {
            if (stream.canReadEntryData(entry) && !entry.isDirectory()) {
                return stream;
            }
            entry = (ArchiveEntry)nextEntry.invoke(stream);
        }
        return null;
    }

    public /* synthetic */ CompressedDumpDescriptor(File file, String compressorName, DefaultConstructorMarker $constructor_marker) {
        this(file, compressorName);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/compressed/CompressedDumpDescriptor$Commons;", "Lcom/intellij/profiler/compressed/CompressedDumpDescriptor;", "file", "Ljava/io/File;", "compressorName", "", "<init>", "(Ljava/io/File;Ljava/lang/String;)V", "createUnderlyingSingleFileInputStream", "Ljava/io/InputStream;", "intellij.profiler.common"})
    public static final class Commons
    extends CompressedDumpDescriptor {
        public Commons(@NotNull File file, @NotNull String compressorName) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)compressorName, (String)"compressorName");
            super(file, compressorName, null);
        }

        @Override
        @Nullable
        public InputStream createUnderlyingSingleFileInputStream() {
            ArchiveInputStream archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream(this.getCompressorName(), (InputStream)new FileInputStream(this.getFile()));
            Intrinsics.checkNotNullExpressionValue((Object)archiveInputStream, (String)"createArchiveInputStream(...)");
            return (InputStream)this.navigatedToEntry(archiveInputStream, Commons::createUnderlyingSingleFileInputStream$lambda$0);
        }

        private static final ArchiveEntry createUnderlyingSingleFileInputStream$lambda$0(ArchiveInputStream t) {
            return t.getNextEntry();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/compressed/CompressedDumpDescriptor$Gz;", "Lcom/intellij/profiler/compressed/CompressedDumpDescriptor;", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "createUnderlyingSingleFileInputStream", "Ljava/io/InputStream;", "intellij.profiler.common"})
    public static final class Gz
    extends CompressedDumpDescriptor {
        public Gz(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(file, "gz", null);
        }

        @Override
        @NotNull
        public InputStream createUnderlyingSingleFileInputStream() {
            return new GZIPInputStream(new FileInputStream(this.getFile()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/compressed/CompressedDumpDescriptor$TarGz;", "Lcom/intellij/profiler/compressed/CompressedDumpDescriptor;", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "createUnderlyingSingleFileInputStream", "Ljava/io/InputStream;", "intellij.profiler.common"})
    public static final class TarGz
    extends CompressedDumpDescriptor {
        public TarGz(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(file, "tar.gz", null);
        }

        @Override
        @Nullable
        public InputStream createUnderlyingSingleFileInputStream() {
            return (InputStream)this.navigatedToEntry((ArchiveInputStream)new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(this.getFile()))), TarGz::createUnderlyingSingleFileInputStream$lambda$0);
        }

        private static final ArchiveEntry createUnderlyingSingleFileInputStream$lambda$0(TarArchiveInputStream t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            return (ArchiveEntry)t.getNextTarEntry();
        }
    }
}

