/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DatabaseServiceViewContributor;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseClientLogViewBase;
import com.intellij.database.console.session.DatabaseInEditorResults;
import com.intellij.database.console.session.DatabaseLogView;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.ConsoleGridDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanView;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ScriptingClientDataConsumer;
import com.intellij.database.run.SqlNotebookModel;
import com.intellij.database.run.actions.NotebookGridPatcher;
import com.intellij.database.run.actions.NotebookGridPatcherKt;
import com.intellij.database.run.actions.ShowPaginationActionKt;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.settings.DataGridAppearanceSettings;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import icons.DatabaseIcons;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DatabaseClientLogView
extends DatabaseLogView<DatabaseSessionClientWithFile>
implements DatabaseClientLogViewBase<DatabaseSessionClientWithFile> {
    private static final Key<PlanView> PLAN_VIEW_KEY = Key.create((String)"PlanView");
    private final List<ConsoleGridDataHookUp> myHookUps;
    private final DatabaseChooser myChooser;

    public DatabaseClientLogView(@NotNull LanguageConsoleView languageConsole, @NotNull DatabaseSessionClientWithFile owner) {
        if (languageConsole == null) {
            DatabaseClientLogView.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            DatabaseClientLogView.$$$reportNull$$$0(1);
        }
        super(languageConsole, owner, new ClientLogViewController(owner), DatabaseClientLogView.getPlaceholder(owner));
        this.myHookUps = new ArrayList<ConsoleGridDataHookUp>();
        this.myChooser = new DatabaseChooser(this);
        RunnerLayoutUi runnerLayoutUi = this.getUi();
        if (runnerLayoutUi instanceof RunnerLayoutUiImpl) {
            RunnerLayoutUiImpl ui = (RunnerLayoutUiImpl)runnerLayoutUi;
            ui.getLayout().setTabLabelsHidden(false);
        }
    }

    @NotNull
    public ScriptingClientDataConsumer.ResultsPlaceChooser getResultsPlaceChooser() {
        DatabaseChooser databaseChooser = this.myChooser;
        if (databaseChooser == null) {
            DatabaseClientLogView.$$$reportNull$$$0(2);
        }
        return databaseChooser;
    }

    @Override
    public boolean isEmpty() {
        return this.myHookUps.isEmpty() && this.findPlanContent(false) == null && this.getConsoleView().getHistoryViewer().getDocument().getTextLength() == 0;
    }

    @Override
    @NotNull
    protected LocalDataSource getDataSource() {
        LocalDataSource localDataSource = ((DatabaseConnectionPoint)((DatabaseSession)((DatabaseSessionClientWithFile)this.getTarget()).getSession()).getTarget()).getDataSource();
        if (localDataSource == null) {
            DatabaseClientLogView.$$$reportNull$$$0(3);
        }
        return localDataSource;
    }

    public void registerHookUp(@NotNull Disposable disposable, @NotNull ConsoleGridDataHookUp hookUp) {
        if (disposable == null) {
            DatabaseClientLogView.$$$reportNull$$$0(4);
        }
        if (hookUp == null) {
            DatabaseClientLogView.$$$reportNull$$$0(5);
        }
        this.myHookUps.add(hookUp);
        Disposer.register((Disposable)disposable, () -> this.myHookUps.remove(hookUp));
    }

    public void showPlan(@Nullable PlanModel plan) {
        Content planContent = this.findPlanContent(true);
        if (plan != null) {
            this.ensureContentInitialized();
            if (planContent == null) {
                planContent = this.createPlanContent();
                this.getUi().addContent(planContent, -1, PlaceInGrid.bottom, false);
                this.getUi().setBouncing(planContent, true);
            }
            ((PlanView)PLAN_VIEW_KEY.get((UserDataHolder)planContent)).setModel(plan);
            this.getUi().selectAndFocus(planContent, true, false);
        } else if (planContent != null) {
            this.getUi().removeContent(planContent, true);
        }
    }

    private Content findPlanContent(boolean toReuse) {
        for (Content content : this.getUi().getContents()) {
            if (PLAN_VIEW_KEY.get((UserDataHolder)content) == null || toReuse && content.isPinned()) continue;
            return content;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTarget(@NotNull DatabaseSessionClientWithFile target, @NotNull DataBus.Consuming bus) {
        if (target == null) {
            DatabaseClientLogView.$$$reportNull$$$0(6);
        }
        if (bus == null) {
            DatabaseClientLogView.$$$reportNull$$$0(7);
        }
        try {
            if (this.myHookUps != null) {
                for (ConsoleGridDataHookUp hookUp : this.myHookUps) {
                    hookUp.setParent((DataRequest.OwnerEx)target);
                    hookUp.setSession((DatabaseSession)target.getSession());
                }
            }
        }
        finally {
            super.setTarget(target, bus);
        }
    }

    public void setConsoleTitle(@NlsContexts.TabTitle @NotNull String title) {
        if (title == null) {
            DatabaseClientLogView.$$$reportNull$$$0(8);
        }
        this.getConsoleView().setTitle(title);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && ((DatabaseSessionClientWithFile)this.getTarget()).getVirtualFile().isValid();
    }

    @NotNull
    private Content createPlanContent() {
        PlanView view = PlanView.createView(this.getProject());
        Content content = this.getUi().createContent("Input", view.getComponent(), DatabaseBundle.message((String)"DatabaseClientViewLog.plan", (Object[])new Object[0]), DatabaseIcons.Table, view.getPreferredFocusedComponent());
        content.setCloseable(true);
        content.setPinnable(true);
        PLAN_VIEW_KEY.set((UserDataHolder)content, (Object)view);
        Disposer.register((Disposable)content, (Disposable)view);
        Content content2 = content;
        if (content2 == null) {
            DatabaseClientLogView.$$$reportNull$$$0(9);
        }
        return content2;
    }

    @NlsContexts.StatusText
    @NotNull
    private static String getPlaceholder(@NotNull DatabaseSessionClientWithFile owner) {
        if (owner == null) {
            DatabaseClientLogView.$$$reportNull$$$0(10);
        }
        String string = DatabaseBundle.message((String)"jdbc.console.tab.title.output", (Object[])new Object[]{StringUtil.capitalize((String)owner.getDepartment().getCommonName())});
        if (string == null) {
            DatabaseClientLogView.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageConsole";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/session/DatabaseClientLogView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/session/DatabaseClientLogView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultsPlaceChooser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlanContent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerHookUp";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTarget";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setConsoleTitle";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 9, 11 -> new IllegalStateException(string);
        };
    }

    private static class ClientLogViewController
    extends DatabaseLogView.DatabaseServiceViewController<DatabaseSessionClientWithFile, DatabaseClientLogView> {
        ClientLogViewController(@NotNull DatabaseSessionClientWithFile owner) {
            if (owner == null) {
                ClientLogViewController.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        @NotNull
        protected Promise<Void> selectNode(@NotNull Project project, @NotNull DatabaseSessionClientWithFile owner, boolean activate, boolean requestFocus, @Nullable LogView.OutputType outputType) {
            if (project == null) {
                ClientLogViewController.$$$reportNull$$$0(1);
            }
            if (owner == null) {
                ClientLogViewController.$$$reportNull$$$0(2);
            }
            if (DatabaseSettings.getSettings().showOutputInTab) {
                DatabaseServiceViewContributor.extractNode(project, (VisibleDatabaseSessionClient)owner);
            }
            Promise<Void> promise = DatabaseServiceViewContributor.selectNode(project, (VisibleDatabaseSessionClient)owner, activate, requestFocus, outputType);
            if (promise == null) {
                ClientLogViewController.$$$reportNull$$$0(3);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/session/DatabaseClientLogView$ClientLogViewController";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/session/DatabaseClientLogView$ClientLogViewController";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "selectNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "selectNode";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class DatabaseChooser
    implements ScriptingClientDataConsumer.ResultsPlaceChooser {
        private final ScriptingClientDataConsumer.ResultsPlace myDefaultPlace;
        private final Map<ConsoleDataRequest.ResultSetSubQuery, ScriptingClientDataConsumer.ResultsPlace> myCustomPlaces;
        private final LogView<?> myView;
        private final DatabaseInEditorResults myResults;

        DatabaseChooser(@NotNull LogView<?> view) {
            if (view == null) {
                DatabaseChooser.$$$reportNull$$$0(0);
            }
            this.myDefaultPlace = new ScriptingClientDataConsumer.LogViewResultsPlace(view);
            this.myCustomPlaces = new ConcurrentHashMap<ConsoleDataRequest.ResultSetSubQuery, ScriptingClientDataConsumer.ResultsPlace>();
            this.myView = view;
            this.myResults = new DatabaseInEditorResults();
        }

        @Override
        public void requestStarted(@NotNull GridDataRequest.Context context) {
            JdbcConsole console;
            DataRequest.Context c2;
            if (context == null) {
                DatabaseChooser.$$$reportNull$$$0(1);
            }
            if ((c2 = (DataRequest.Context)ObjectUtils.tryCast((Object)context, DataRequest.Context.class)) == null) {
                return;
            }
            ConsoleDataRequest request = (ConsoleDataRequest)ObjectUtils.tryCast((Object)c2.request, ConsoleDataRequest.class);
            EditorEx editor2 = request == null ? null : (EditorEx)ObjectUtils.tryCast((Object)request.getEditor(), EditorEx.class);
            JdbcConsole jdbcConsole = console = editor2 == null ? null : (JdbcConsole)((Object)ObjectUtils.tryCast((Object)c2.request.owner, JdbcConsole.class));
            if (console == null || !console.isNotebookMode()) {
                return;
            }
            request.getResultSetSubQueries().forEach(subQuery -> {
                DatabaseInEditorResults.Arguments arguments = new DatabaseInEditorResults.Arguments(editor2, console, request, (ConsoleDataRequest.ResultSetSubQuery)subQuery);
                ReadAction.run(() -> this.myCustomPlaces.put((ConsoleDataRequest.ResultSetSubQuery)subQuery, new InEditorPlaceWrapper(this.myDefaultPlace, arguments, this.myResults)));
            });
        }

        @Override
        public void requestFinished(@NotNull GridDataRequest.Context context) {
            DataRequest.Context c2;
            ConsoleDataRequest request;
            if (context == null) {
                DatabaseChooser.$$$reportNull$$$0(2);
            }
            ConsoleDataRequest consoleDataRequest = request = (c2 = (DataRequest.Context)ObjectUtils.tryCast((Object)context, DataRequest.Context.class)) == null ? null : (ConsoleDataRequest)ObjectUtils.tryCast((Object)c2.request, ConsoleDataRequest.class);
            if (request == null) {
                return;
            }
            request.getResultSetSubQueries().forEach(subQuery -> {
                this.getResultsPlace((ConsoleDataRequest.ResultSetSubQuery)subQuery).requestFinished();
                this.myCustomPlaces.remove(subQuery);
            });
        }

        @Override
        @NotNull
        public ScriptingClientDataConsumer.ResultsPlace getResultsPlace(@Nullable ConsoleDataRequest.ResultSetSubQuery resultSetSubQuery) {
            ScriptingClientDataConsumer.ResultsPlace customPlace = resultSetSubQuery == null ? null : this.myCustomPlaces.get(resultSetSubQuery);
            ScriptingClientDataConsumer.ResultsPlace resultsPlace = customPlace == null ? this.myDefaultPlace : customPlace;
            if (resultsPlace == null) {
                DatabaseChooser.$$$reportNull$$$0(3);
            }
            return resultsPlace;
        }

        @Override
        @NotNull
        public Collection<RunnerLayoutUi> getAllUis() {
            ArrayList<RunnerLayoutUi> uis = new ArrayList<RunnerLayoutUi>();
            uis.add(this.myView.getUi());
            uis.addAll(this.myResults.getUis());
            ArrayList<RunnerLayoutUi> arrayList = uis;
            if (arrayList == null) {
                DatabaseChooser.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @Override
        @NotNull
        public Collection<? extends DatabaseInEditorResults.Result> getEmbeddedResults(@NotNull Editor editor2) {
            if (editor2 == null) {
                DatabaseChooser.$$$reportNull$$$0(5);
            }
            Collection<? extends DatabaseInEditorResults.Result> collection = this.myResults.getResults(editor2);
            if (collection == null) {
                DatabaseChooser.$$$reportNull$$$0(6);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/session/DatabaseClientLogView$DatabaseChooser";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/session/DatabaseClientLogView$DatabaseChooser";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultsPlace";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllUis";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEmbeddedResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "requestStarted";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "requestFinished";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getEmbeddedResults";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 6 -> new IllegalStateException(string);
            };
        }

        private static class InEditorPlaceWrapper
        implements ScriptingClientDataConsumer.ResultsPlace {
            private final DatabaseInEditorResults myHelper;
            private final ScriptingClientDataConsumer.ResultsPlace myServicesPlace;
            private final DatabaseInEditorResults.Arguments myArguments;
            private Ref<DatabaseInEditorResults.ResultConstructor> myResult;

            InEditorPlaceWrapper(@NotNull ScriptingClientDataConsumer.ResultsPlace servicesPlace, @NotNull DatabaseInEditorResults.Arguments arguments, @NotNull DatabaseInEditorResults helper) {
                if (servicesPlace == null) {
                    InEditorPlaceWrapper.$$$reportNull$$$0(0);
                }
                if (arguments == null) {
                    InEditorPlaceWrapper.$$$reportNull$$$0(1);
                }
                if (helper == null) {
                    InEditorPlaceWrapper.$$$reportNull$$$0(2);
                }
                this.myServicesPlace = servicesPlace;
                this.myArguments = arguments;
                this.myHelper = helper;
                PsiFile file = arguments.console.getFile();
                SqlNotebookModel.getCellAccessor(file, arguments.console.getScriptModel(), (Condition<? super TextRange>)Conditions.alwaysTrue());
            }

            @Override
            @NotNull
            public RunnerLayoutUi getOrCreateUi() {
                DatabaseInEditorResults.Result result2;
                if (this.myResult == null) {
                    result2 = this.myHelper.getOrCreateResult(this.myArguments);
                    this.myResult = Ref.create((Object)result2);
                    if (result2 != null) {
                        result2.setInProgress(true);
                    }
                }
                RunnerLayoutUi runnerLayoutUi = (result2 = (DatabaseInEditorResults.Result)this.myResult.get()) == null ? this.myServicesPlace.getOrCreateUi() : result2.getUi();
                if (runnerLayoutUi == null) {
                    InEditorPlaceWrapper.$$$reportNull$$$0(3);
                }
                return runnerLayoutUi;
            }

            @Override
            @NotNull
            public Promise<Void> showIfNeeded(@NotNull DataRequest.Owner owner) {
                DatabaseInEditorResults.Result result2;
                if (owner == null) {
                    InEditorPlaceWrapper.$$$reportNull$$$0(4);
                }
                if ((result2 = (DatabaseInEditorResults.Result)this.myResult.get()) == null) {
                    Promise<Void> promise = this.myServicesPlace.showIfNeeded(owner);
                    if (promise == null) {
                        InEditorPlaceWrapper.$$$reportNull$$$0(5);
                    }
                    return promise;
                }
                this.myHelper.scrollTo(result2, (Editor)this.myArguments.editor);
                Promise promise = Promises.resolvedPromise();
                if (promise == null) {
                    InEditorPlaceWrapper.$$$reportNull$$$0(6);
                }
                return promise;
            }

            @Override
            public void requestFinished() {
                Ref<DatabaseInEditorResults.ResultConstructor> result2 = this.myResult;
                if (result2 == null) {
                    return;
                }
                DatabaseInEditorResults.ResultConstructor constructor = (DatabaseInEditorResults.ResultConstructor)result2.get();
                if (constructor != null) {
                    constructor.setInProgress(false);
                }
            }

            @Override
            public void moveFocusToEditor(AnActionEvent e) {
                this.myArguments.editor.getContentComponent().requestFocus();
            }

            @Override
            public void configure(final @NotNull DataGrid grid, @NotNull DataGridAppearance appearance) {
                if (grid == null) {
                    InEditorPlaceWrapper.$$$reportNull$$$0(7);
                }
                if (appearance == null) {
                    InEditorPlaceWrapper.$$$reportNull$$$0(8);
                }
                appearance.setTransparentColumnHeaderBackground(true);
                appearance.setTransparentRowHeaderBackground(true);
                appearance.setResultViewStriped(DataGridAppearanceSettings.getSettings().isStripedTable());
                DataGridSettings settings = GridUtil.getSettings((DataGrid)grid);
                boolean isEnablePagingInInEditorResultsByDefault = settings != null && settings.isEnablePagingInInEditorResultsByDefault();
                ShowPaginationActionKt.enablePagination((DataGrid)grid, (boolean)isEnablePagingInInEditorResultsByDefault, null);
                grid.putUserData(GridUtil.IN_EDITOR_RESULTS, (Object)true);
                grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).addListener((GridModel.Listener)new GridModel.Listener<GridRow, GridColumn>(this){

                    public void columnsAdded(ModelIndexSet<GridColumn> columns) {
                    }

                    public void columnsRemoved(ModelIndexSet<GridColumn> columns) {
                    }

                    public void rowsAdded(ModelIndexSet<GridRow> rows) {
                    }

                    public void rowsRemoved(ModelIndexSet<GridRow> rows) {
                    }

                    public void cellsUpdated(ModelIndexSet<GridRow> rows, ModelIndexSet<GridColumn> columns, @Nullable GridRequestSource.RequestPlace place) {
                        if (grid.getPanel().getBottomHeaderComponent() == null) {
                            GridUtil.addBottomHeader((DataGrid)grid);
                            NotebookGridPatcher patcher = (NotebookGridPatcher)grid.getUserData(NotebookGridPatcherKt.RESULTS_PATCHER);
                            if (patcher != null) {
                                patcher.updateHeight();
                            }
                        }
                    }
                }, (Disposable)grid);
            }

            @Override
            public boolean isUseConsoleFonts() {
                return false;
            }

            @Override
            public void readyToShow(@NotNull Content content) {
                DatabaseInEditorResults.Result result2;
                if (content == null) {
                    InEditorPlaceWrapper.$$$reportNull$$$0(9);
                }
                if ((result2 = (DatabaseInEditorResults.Result)this.myResult.get()) != null) {
                    this.myHelper.show(result2, content, (Editor)this.myArguments.editor);
                    return;
                }
                this.myServicesPlace.readyToShow(content);
            }

            @Override
            public boolean showImmediate() {
                return false;
            }

            @Override
            public JComponent addHeader(@NotNull DataGrid grid) {
                if (grid == null) {
                    InEditorPlaceWrapper.$$$reportNull$$$0(10);
                }
                JComponent header = GridUtil.addVerticalGridHeaderComponent((DataGrid)grid, (String)"Console.InEditorTableResult.Vertical.Group");
                header.setBorder(new CompoundBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Editor.BORDER_COLOR, (int)1, (int)0, (int)1, (int)1), header.getBorder()));
                grid.getPanel().getCenterComponent().setBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Editor.BORDER_COLOR, (int)1));
                return header;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3, 5, 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "servicesPlace";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arguments";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "helper";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/session/DatabaseClientLogView$DatabaseChooser$InEditorPlaceWrapper";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "owner";
                        break;
                    }
                    case 7: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "grid";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "appearance";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "content";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/session/DatabaseClientLogView$DatabaseChooser$InEditorPlaceWrapper";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOrCreateUi";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "showIfNeeded";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "showIfNeeded";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "configure";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "readyToShow";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "addHeader";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3, 5, 6 -> new IllegalStateException(string);
                };
            }
        }
    }
}

