/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.logging.LogManager;

public final class RemoteLogManagerConfigurator {
    public static void updateConfiguration(String config) throws Exception {
        ByteArrayInputStream configAsStream = new ByteArrayInputStream(config.getBytes(Charset.defaultCharset()));
        Method updateConfigurationMethod = RemoteLogManagerConfigurator.findUpdateConfigurationMethod();
        if (updateConfigurationMethod != null) {
            updateConfigurationMethod.invoke((Object)LogManager.getLogManager(), configAsStream, null);
        } else {
            LogManager.getLogManager().readConfiguration(configAsStream);
        }
    }

    private static Method findUpdateConfigurationMethod() {
        try {
            return LogManager.getLogManager().getClass().getMethod("updateConfiguration", InputStream.class, Class.forName("java.util.function.Function"));
        }
        catch (Throwable t) {
            return null;
        }
    }
}

