/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.time.Duration;
import org.assertj.core.error.BasicErrorMessageFactory;

public class ShouldHaveDuration
extends BasicErrorMessageFactory {
    private static final String EXPECTED_PREFIX = "%nExpecting Duration:%n  %s%nto have %s ";

    public static ShouldHaveDuration shouldHaveNanos(Duration actual, long actualNanos, long expectedNanos) {
        String metric = expectedNanos == 1L || expectedNanos == -1L ? "nano" : "nanos";
        return new ShouldHaveDuration(actual, actualNanos, expectedNanos, metric);
    }

    public static ShouldHaveDuration shouldHaveMillis(Duration actual, long actualMillis, long expectedMillis) {
        String metric = expectedMillis == 1L || expectedMillis == -1L ? "milli" : "millis";
        return new ShouldHaveDuration(actual, actualMillis, expectedMillis, metric);
    }

    public static ShouldHaveDuration shouldHaveSeconds(Duration actual, long actualSeconds, long expectedSeconds) {
        String metric = expectedSeconds == 1L || expectedSeconds == -1L ? "second" : "seconds";
        return new ShouldHaveDuration(actual, actualSeconds, expectedSeconds, metric);
    }

    public static ShouldHaveDuration shouldHaveMinutes(Duration actual, long actualMinutes, long expectedMinutes) {
        String metric = expectedMinutes == 1L || expectedMinutes == -1L ? "minute" : "minutes";
        return new ShouldHaveDuration(actual, actualMinutes, expectedMinutes, metric);
    }

    public static ShouldHaveDuration shouldHaveHours(Duration actual, long actualHours, long expectedHours) {
        String metric = expectedHours == 1L || expectedHours == -1L ? "hour" : "hours";
        return new ShouldHaveDuration(actual, actualHours, expectedHours, metric);
    }

    public static ShouldHaveDuration shouldHaveDays(Duration actual, long actualDays, long expectedDays) {
        String metric = expectedDays == 1L || expectedDays == -1L ? "day" : "days";
        return new ShouldHaveDuration(actual, actualDays, expectedDays, metric);
    }

    private ShouldHaveDuration(Duration actual, long actualSpecific, long expectedSpecific, String metric) {
        super(EXPECTED_PREFIX + metric + " but had %s", actual, expectedSpecific, actualSpecific);
    }
}

