/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramBuilderFactory;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.actions.DiagramToolbarActionsProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.core.actions.ChangeCreationEdgeMode;
import com.intellij.uml.core.actions.UmlActions;
import com.intellij.uml.core.actions.UmlCategorySwitcher;
import com.intellij.uml.core.actions.UmlShowDependencies;
import com.intellij.uml.core.actions.ordering.DiagramChangeOrderingActionGroup;
import com.intellij.uml.core.actions.scopes.UmlScopesActionGroup;
import com.intellij.uml.core.actions.visibility.UmlVisibilityActionGroup;
import com.intellij.util.ObjectUtils;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramToolbarActionsProviderImpl
implements DiagramToolbarActionsProvider {
    @Override
    public void addToolbarActionsTo(@NotNull DefaultActionGroup group, @NotNull DiagramBuilder builder) {
        if (group == null) {
            DiagramToolbarActionsProviderImpl.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            DiagramToolbarActionsProviderImpl.$$$reportNull$$$0(1);
        }
        DiagramToolbarActionsProviderImpl.addSwitchCategoryActionsTo(group, builder);
        DiagramToolbarActionsProviderImpl.addChangeOrderingActionsTo(group, builder);
        DiagramToolbarActionsProviderImpl.addChangeVisibilityActionsTo(group, builder);
        DiagramToolbarActionsProviderImpl.addChangeScopeActionsTo(group, builder);
        DiagramToolbarActionsProviderImpl.addChangeCreationEdgeModeActionsTo(group, builder);
        group.addSeparator();
        group.add((AnAction)UmlActions.getCommonToolbarActions());
    }

    @Override
    @Nullable
    public DefaultActionGroup getCurrentToolbarActions(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramToolbarActionsProviderImpl.$$$reportNull$$$0(2);
        }
        return Optional.ofNullable(builder.getEditor()).map(it -> (UmlFileEditorImpl)ObjectUtils.tryCast((Object)it, UmlFileEditorImpl.class)).map(it -> it.getGraphComponent().getToolbarActionGroup()).orElse(null);
    }

    private static void addSwitchCategoryActionsTo(@NotNull DefaultActionGroup group, @NotNull DiagramBuilder builder) {
        if (group == null) {
            DiagramToolbarActionsProviderImpl.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            DiagramToolbarActionsProviderImpl.$$$reportNull$$$0(4);
        }
        if (builder.getPresentationModel().allowChangeVisibleCategories()) {
            DiagramCategory[] categories;
            for (DiagramCategory category : categories = builder.getDataModel().getNodeContentManager().getContentCategories()) {
                group.add((AnAction)new UmlCategorySwitcher(category, builder));
            }
        }
        if (DiagramBuilderFactory.getInstance().getModelBuilder(builder).getDataModel().isDependencyDiagramSupported()) {
            group.add((AnAction)new UmlShowDependencies());
        }
    }

    private static void addChangeOrderingActionsTo(@NotNull DefaultActionGroup group, @NotNull DiagramBuilder builder) {
        DiagramChangeOrderingActionGroup orderingActionGroup;
        if (group == null) {
            DiagramToolbarActionsProviderImpl.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            DiagramToolbarActionsProviderImpl.$$$reportNull$$$0(6);
        }
        if ((orderingActionGroup = new DiagramChangeOrderingActionGroup(builder)).getChildrenCount() > 0) {
            group.add((AnAction)orderingActionGroup);
        }
    }

    private static void addChangeVisibilityActionsTo(@NotNull DefaultActionGroup group, @NotNull DiagramBuilder builder) {
        UmlVisibilityActionGroup visibilityActionGroup;
        if (group == null) {
            DiagramToolbarActionsProviderImpl.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            DiagramToolbarActionsProviderImpl.$$$reportNull$$$0(8);
        }
        if ((visibilityActionGroup = new UmlVisibilityActionGroup(builder)).getChildrenCount() > 0) {
            group.add((AnAction)visibilityActionGroup);
        }
    }

    private static void addChangeScopeActionsTo(@NotNull DefaultActionGroup group, @NotNull DiagramBuilder builder) {
        DiagramScopeManager<?> scopeManager;
        if (group == null) {
            DiagramToolbarActionsProviderImpl.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            DiagramToolbarActionsProviderImpl.$$$reportNull$$$0(10);
        }
        if ((scopeManager = builder.getDataModel().getScopeManager()) != null) {
            group.add((AnAction)new UmlScopesActionGroup(builder, scopeManager));
        }
    }

    private static void addChangeCreationEdgeModeActionsTo(@NotNull DefaultActionGroup group, @NotNull DiagramBuilder builder) {
        if (group == null) {
            DiagramToolbarActionsProviderImpl.$$$reportNull$$$0(11);
        }
        if (builder == null) {
            DiagramToolbarActionsProviderImpl.$$$reportNull$$$0(12);
        }
        if (builder.getProvider().getEdgeCreationPolicy() != null) {
            group.add((AnAction)new Separator());
            group.add((AnAction)new ChangeCreationEdgeMode());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/core/actions/DiagramToolbarActionsProviderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addToolbarActionsTo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentToolbarActions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addSwitchCategoryActionsTo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addChangeOrderingActionsTo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addChangeVisibilityActionsTo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addChangeScopeActionsTo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addChangeCreationEdgeModeActionsTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

