/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.jinja.template.DjangoTemplateFileType;
import com.intellij.jinja.template.DjangoTemplateFileViewProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.python.django.lang.template.inspection.DjangoLocalInspectionTool;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.lang.template.ref.DjangoStaticFileReferenceSet;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.inspections.PyUnresolvedReferenceQuickFixProvider;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class UnresolvedStaticReferenceInspection
extends DjangoLocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "DjangoUnresolvedStaticReferenceInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Module module;
        FileViewProvider vp;
        if (file == null) {
            UnresolvedStaticReferenceInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            UnresolvedStaticReferenceInspection.$$$reportNull$$$0(1);
        }
        if (file.getFileType().equals((Object)DjangoTemplateFileType.INSTANCE) && (vp = file.getViewProvider()) instanceof DjangoTemplateFileViewProvider) {
            file = vp.getPsi(((DjangoTemplateFileViewProvider)vp).getTemplateDataLanguage());
        }
        if ((file.getFileType().equals((Object)HtmlFileType.INSTANCE) || file.getFileType().equals((Object)XmlFileType.INSTANCE)) && DjangoFacet.isPresent((Module)(module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)))) {
            UnresolvedStaticReferenceVisitor visitor2 = UnresolvedStaticReferenceInspection.createVisitor(manager);
            file.accept((PsiElementVisitor)visitor2);
            List<ProblemDescriptor> problems = visitor2.getProblems();
            if (!problems.isEmpty()) {
                ProblemDescriptor[] arr = new ProblemDescriptor[problems.size()];
                problems.toArray(arr);
                return arr;
            }
        }
        return super.checkFile(file, manager, isOnTheFly);
    }

    private static UnresolvedStaticReferenceVisitor createVisitor(InspectionManager manager) {
        return new UnresolvedStaticReferenceVisitor(manager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/django/lang/template/inspection/UnresolvedStaticReferenceInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class UnresolvedStaticReferenceVisitor
    extends XmlRecursiveElementVisitor {
        private final List<ProblemDescriptor> myProblems = new ArrayList<ProblemDescriptor>();
        private final InspectionManager myManager;

        public List<ProblemDescriptor> getProblems() {
            return this.myProblems;
        }

        private UnresolvedStaticReferenceVisitor(InspectionManager manager) {
            this.myManager = manager;
        }

        public void visitXmlAttributeValue(@NotNull XmlAttributeValue value) {
            if (value == null) {
                UnresolvedStaticReferenceVisitor.$$$reportNull$$$0(0);
            }
            for (PsiReference ref : value.getReferences()) {
                if (!(ref instanceof DjangoStaticFileReferenceSet.DjangoStaticFileReference) || ((DjangoStaticFileReferenceSet.DjangoStaticFileReference)ref).multiResolve(false).length != 0) continue;
                this.reportUnresolvedStaticReference(ref, value);
                break;
            }
        }

        private void reportUnresolvedStaticReference(PsiReference ref, XmlAttributeValue stringLiteral) {
            this.reportProblem(ref, (PsiElement)stringLiteral, DjangoBundle.message((String)"inspection.unresolved-static-reference.error-msg", (Object[])new Object[]{stringLiteral.getText()}));
        }

        private void reportProblem(PsiReference ref, PsiElement elem, @InspectionMessage String msg) {
            ProblemDescriptor d = this.myManager.createProblemDescriptor(elem, new TextRange(0, elem.getTextLength()), msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, this.getQuickFixActions(ref));
            this.myProblems.add(d);
        }

        public LocalQuickFix[] getQuickFixActions(PsiReference reference) {
            ArrayList actions2 = new ArrayList();
            for (PyUnresolvedReferenceQuickFixProvider provider : PyUnresolvedReferenceQuickFixProvider.EP_NAME.getExtensionList()) {
                provider.registerQuickFixes(reference, actions2);
            }
            return actions2.toArray(LocalQuickFix.EMPTY_ARRAY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/python/django/lang/template/inspection/UnresolvedStaticReferenceInspection$UnresolvedStaticReferenceVisitor", "visitXmlAttributeValue"));
        }
    }
}

