/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.codeGen;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.python.django.codeGen.DjangoResolvedPlace;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ \u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/python/django/codeGen/DjangoFileCreationUtils;", "", "<init>", "()V", "UPPER_CASE_MATCHER", "Lkotlin/text/Regex;", "resolveRootFor", "Lcom/jetbrains/python/psi/PyFile;", "moduleName", "", "parentDirectory", "Lcom/intellij/psi/PsiDirectory;", "resolvePlace", "Lcom/intellij/python/django/codeGen/DjangoResolvedPlace;", "pyClass", "Lcom/jetbrains/python/psi/PyClass;", "fileName", "generateFileNameByPyClassName", "intellij.python.django"})
public final class DjangoFileCreationUtils {
    @NotNull
    public static final DjangoFileCreationUtils INSTANCE = new DjangoFileCreationUtils();
    @NotNull
    private static final Regex UPPER_CASE_MATCHER = new Regex("[A-Z]");

    private DjangoFileCreationUtils() {
    }

    @Nullable
    public final PyFile resolveRootFor(@NotNull String moduleName, @NotNull PsiDirectory parentDirectory) {
        PyFile pyModule;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)parentDirectory, (String)"parentDirectory");
        String fileName = moduleName + ".py";
        PsiFile psiFile = parentDirectory.findFile(fileName);
        PyFile pyFile = pyModule = psiFile instanceof PyFile ? (PyFile)psiFile : null;
        if (pyModule != null) {
            return pyModule;
        }
        PsiDirectory subdirectory = parentDirectory.findSubdirectory(moduleName);
        if (subdirectory != null) {
            PyFile initPyInFolder;
            PsiFile psiFile2 = subdirectory.findFile("__init__.py");
            PyFile pyFile2 = initPyInFolder = psiFile2 instanceof PyFile ? (PyFile)psiFile2 : null;
            if (initPyInFolder != null) {
                return initPyInFolder;
            }
        }
        return null;
    }

    @Nullable
    public final DjangoResolvedPlace resolvePlace(@NotNull PyClass pyClass, @NotNull PsiDirectory parentDirectory, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)pyClass, (String)"pyClass");
        Intrinsics.checkNotNullParameter((Object)parentDirectory, (String)"parentDirectory");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        String string = this.generateFileNameByPyClassName(pyClass);
        if (string == null) {
            return null;
        }
        String fileName = string;
        return this.resolvePlace(parentDirectory, moduleName, fileName);
    }

    @Nullable
    public final DjangoResolvedPlace resolvePlace(@NotNull PsiDirectory parentDirectory, @NotNull String moduleName, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)parentDirectory, (String)"parentDirectory");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        PyFile module = this.resolveRootFor(moduleName, parentDirectory);
        if (module != null) {
            if (Intrinsics.areEqual((Object)"__init__.py", (Object)module.getName())) {
                PsiDirectory psiDirectory = (PsiDirectory)module.getParent();
                if (psiDirectory == null) {
                    return null;
                }
                PsiDirectory parentDirectory2 = psiDirectory;
                PsiFile file = parentDirectory2.findFile(fileName);
                if (file != null) {
                    return new DjangoResolvedPlace.UpdateExistingFile(file, (PsiFile)module);
                }
                return new DjangoResolvedPlace.CreateNewFile(parentDirectory2, fileName, (PsiFile)module);
            }
            return new DjangoResolvedPlace.UpdateExistingFile((PsiFile)module, null);
        }
        DjangoResolvedPlace.CreateNewFile place = new DjangoResolvedPlace.CreateNewFile(parentDirectory, moduleName + ".py", null);
        return place;
    }

    /*
     * WARNING - void declaration
     */
    private final String generateFileNameByPyClassName(PyClass pyClass) {
        String string;
        block6: {
            block5: {
                String string2;
                string = pyClass.getName();
                if (string == null) break block5;
                String string3 = string;
                if (((CharSequence)string3).length() > 0) {
                    void it;
                    char c = string3.charAt(0);
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl = false;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.lowercase((char)it, (Locale)locale));
                    String string4 = string3;
                    int n = 1;
                    String string5 = string4.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    string2 = stringBuilder2.append(string5).toString();
                } else {
                    string2 = string = string3;
                }
                if (string2 != null) break block6;
            }
            return null;
        }
        String decapitalizedDjangoModelClassName = string;
        return UPPER_CASE_MATCHER.replace((CharSequence)decapitalizedDjangoModelClassName, DjangoFileCreationUtils::generateFileNameByPyClassName$lambda$1) + ".py";
    }

    private static final CharSequence generateFileNameByPyClassName$lambda$1(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getValue().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return "_" + string;
    }
}

