/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSIconProvider;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSIndexableImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitParameterStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubElementTypeHolder;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ComparatorUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImplicitElementImpl
extends FakePsiElement
implements JSIndexableImplicitElement,
JSOptionalOwner {
    @NotNull
    protected final JSImplicitElementStructureImpl myStructure;
    @Nullable
    protected final PsiElement myProvider;

    public JSImplicitElementImpl(@NotNull String name, @Nullable PsiElement provider) {
        if (name == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(0);
        }
        this(new Builder(name, provider));
    }

    public JSImplicitElementImpl(@NotNull String name, @Nullable JSQualifiedName namespace, @NotNull PsiElement provider) {
        if (name == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(2);
        }
        this(new Builder(name, provider).setNamespace(namespace));
    }

    public JSImplicitElementImpl(@NotNull Builder builder) {
        if (builder == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(3);
        }
        this.myStructure = this.createStructure(builder);
        this.myProvider = builder.myProvider;
        assert (this.getType() == JSImplicitElement.Type.Function == this instanceof JSFunctionItem);
    }

    public JSImplicitElementImpl(@NotNull JSImplicitElementStructureImpl structure, @Nullable PsiElement provider) {
        if (structure == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(4);
        }
        this.myStructure = structure;
        this.myProvider = provider;
    }

    protected JSImplicitElementStructureImpl createStructure(Builder builder) {
        return new JSImplicitElementStructureImpl(builder);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(5);
        }
        if (state == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(6);
        }
        if (place == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(7);
        }
        return processor.execute((PsiElement)this, state);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myStructure.getName();
        if (string == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    public JSQualifiedName getNamespace() {
        return this.myStructure.getNamespace();
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String string = this.myStructure.getQualifiedName();
        if (string == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        return this.myStructure.isNamespaceExplicitlyDeclared();
    }

    @Override
    @Nullable
    public String getUserString() {
        return this.myStructure.getUserString();
    }

    @Override
    @Nullable
    public String getUserStringData() {
        return this.myStructure.getUserStringData();
    }

    @Override
    @NotNull
    public JSImplicitElement.Type getType() {
        JSImplicitElement.Type type = this.myStructure.getType();
        if (type == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(10);
        }
        return type;
    }

    @Override
    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = this.myStructure.getJSContext();
        if (jSContext == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(11);
        }
        return jSContext;
    }

    @Override
    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = this.myStructure.getAccessType();
        if (accessType == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(12);
        }
        return accessType;
    }

    @Override
    public boolean hasMinorImportance() {
        return this.myStructure.hasMinorImportance();
    }

    @Override
    public boolean isDeprecated() {
        return this.myStructure.isDeprecated();
    }

    @Override
    @Deprecated
    @Nullable
    public String getTypeString() {
        return this.myStructure.getTypeString();
    }

    public PsiElement getParent() {
        return this.myProvider;
    }

    @Nullable
    public TextRange getTextRange() {
        if (this.myProvider != null) {
            return this.myProvider.getTextRange();
        }
        return super.getTextRange();
    }

    @NotNull
    public Language getLanguage() {
        return JSImplicitElementImpl.doGetLanguage(this.myProvider);
    }

    @Override
    @Nullable
    public JSType getJSType() {
        JSStubElementTypeHolder holder = this.myStructure.myTypeHolder;
        return holder != null ? holder.getTypeOrFromSerialized((PsiElement)this, false, true) : null;
    }

    @Override
    public boolean isOptional() {
        return this.myStructure.isOptional();
    }

    @NotNull
    public static Language doGetLanguage(PsiElement provider) {
        JSLanguageDialect dialect;
        if (provider != null && (dialect = DialectDetector.languageDialectOfElement(provider)) != null) {
            JSLanguageDialect jSLanguageDialect = dialect;
            if (jSLanguageDialect == null) {
                JSImplicitElementImpl.$$$reportNull$$$0(13);
            }
            return jSLanguageDialect;
        }
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        if (javascriptLanguage == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(14);
        }
        return javascriptLanguage;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        JSImplicitElementImpl jSImplicitElementImpl = this.myProvider != null ? this.myProvider : this;
        if (jSImplicitElementImpl == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(15);
        }
        return jSImplicitElementImpl;
    }

    @Override
    public boolean isConst() {
        return this.myStructure.isConst();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(16);
        }
        if (this.myProvider instanceof JSLiteralExpression) {
            String qName = this.getQualifiedName();
            int qNameStart = this.myProvider.getText().indexOf(qName);
            if (qNameStart >= 0) {
                String oldName = this.getName();
                TextRange range = TextRange.from((int)(qNameStart + qName.length() - oldName.length()), (int)oldName.length());
                ElementManipulators.handleContentChange((PsiElement)this.myProvider, (TextRange)range, (String)name);
            } else {
                ElementManipulators.handleContentChange((PsiElement)this.myProvider, (String)name);
            }
        }
        for (PsiElement parent = this.myProvider; parent != null && !(parent instanceof JSFile); parent = parent.getParent()) {
            if (!(parent instanceof PsiNamedElement) || !StringUtil.equals((CharSequence)this.getName(), (CharSequence)((PsiNamedElement)parent).getName())) continue;
            ((PsiNamedElement)parent).setName(name);
            break;
        }
        return this.toBuilder().setName(name).toImplicitElement();
    }

    @NotNull
    public Builder toBuilder() {
        Builder builder = new Builder(this.getName(), this.myProvider);
        this.fillBuilder(builder);
        Builder builder2 = builder;
        if (builder2 == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(17);
        }
        return builder2;
    }

    protected void fillBuilder(@NotNull Builder builder) {
        if (builder == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(18);
        }
        this.myStructure.fillBuilder(builder);
        builder.setProvider(this.myProvider);
    }

    @Nullable
    public Icon getIcon(boolean open) {
        JSImplicitElement.Type type = this.getType();
        return JSImplicitElementImpl.getIconForType(type, (PsiElement)this);
    }

    public static Icon getIconForType(@NotNull JSImplicitElement.Type type, @NotNull PsiElement element) {
        if (type == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(19);
        }
        if (element == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(20);
        }
        IconManager iconManager = IconManager.getInstance();
        return switch (type) {
            default -> throw new MatchException(null, null);
            case JSImplicitElement.Type.Variable -> iconManager.getPlatformIcon(PlatformIcons.Variable);
            case JSImplicitElement.Type.Function -> JSStubElementImpl.blendFlags(iconManager.getPlatformIcon(PlatformIcons.Method), true, false);
            case JSImplicitElement.Type.Method -> JSStubElementImpl.blendFlags(iconManager.getPlatformIcon(PlatformIcons.Method), false, false);
            case JSImplicitElement.Type.Property -> iconManager.getPlatformIcon(PlatformIcons.Property);
            case JSImplicitElement.Type.Namespace, JSImplicitElement.Type.Class, JSImplicitElement.Type.Interface -> {
                JSIconProvider iconProvider = JSIconProvider.getForLanguage((PsiElement)element.getContainingFile());
                if (type == JSImplicitElement.Type.Interface) {
                    yield iconProvider.getInterfaceIcon();
                }
                yield iconProvider.getClassIcon();
            }
            case JSImplicitElement.Type.Tag -> IconManager.getInstance().getPlatformIcon(PlatformIcons.Tag);
        };
    }

    protected Icon computeBaseIcon(int flags) {
        return this.getIcon(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSImplicitElementImpl element = (JSImplicitElementImpl)o;
        if (!this.myStructure.equals(element.myStructure)) {
            return false;
        }
        return Objects.equals(this.myProvider, element.myProvider);
    }

    public int hashCode() {
        int result = this.myStructure.hashCode();
        result = 31 * result + (this.myProvider != null ? this.myProvider.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JSImplicitElement(" + String.valueOf(this.myProvider) + ")";
    }

    public ItemPresentation getPresentation() {
        return new JSItemPresentation(this);
    }

    @Override
    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = this.myStructure.isClassOrInterface();
        if (classOrInterface == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(21);
        }
        return classOrInterface;
    }

    @Override
    @NotNull
    public JSNamespace getJSNamespace() {
        JSNamespace jSNamespace = (JSNamespace)this.myStructure.myNamespaceHolder.getTypeOrFromSerialized((PsiElement)this, false, this.isNamespaceExplicitlyDeclared());
        if (jSNamespace == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(22);
        }
        return jSNamespace;
    }

    @Override
    public boolean hasJSDoc() {
        return this.myStructure.hasJSDoc();
    }

    @Override
    @NotNull
    public JSImplicitElementStructureImpl getStructure() {
        JSImplicitElementStructureImpl jSImplicitElementStructureImpl = this.myStructure;
        if (jSImplicitElementStructureImpl == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(23);
        }
        return jSImplicitElementStructureImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 13, 14, 15, 17, 21, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetLanguage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "toBuilder";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fillBuilder";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getIconForType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 13, 14, 15, 17, 21, 22, 23 -> new IllegalStateException(string);
        };
    }

    public static final class Builder {
        @NotNull
        private static final String DEFAULT_NAMESPACE = JSTypeUtils.serializeType(JSNamedTypeFactory.createNamespace((JSQualifiedName)null, JSTypeSourceFactory.empty(JSTypeSource.SourceLanguage.JS, true), JSTypeContext.UNKNOWN, false));
        @NotNull
        String myName;
        int myFlags;
        @NotNull
        String mySerializedNamespace;
        @Nullable
        String mySerializedType;
        @Nullable
        PsiElement myProvider;
        @Nullable
        String myUserString;
        @Nullable
        String myUserStringData;
        @Nullable
        List<JSImplicitParameterStructure> myParameters;
        private int myOffset;
        private PsiFile myFile;
        boolean myAllowAstAccess;
        boolean myOptional;

        public Builder(@NotNull JSQualifiedName qualifiedName, @Nullable PsiElement provider) {
            if (qualifiedName == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this(qualifiedName.getName(), provider);
            this.setNamespace(qualifiedName.getParent());
        }

        public Builder(@NotNull String name, @Nullable PsiElement provider) {
            if (name == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.mySerializedNamespace = DEFAULT_NAMESPACE;
            this.myAllowAstAccess = true;
            this.myOptional = false;
            this.myName = name;
            this.myProvider = provider;
            this.setNamespaceExplicitlyDeclared(true);
            this.setType(JSImplicitElement.Type.Property);
            this.setAccessType(JSAttributeList.AccessType.PACKAGE_LOCAL);
        }

        public Builder setName(@NotNull String name) {
            if (name == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myName = name;
            return this;
        }

        public Builder setNamespace(@NotNull JSNamespace namespace) {
            if (namespace == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.mySerializedNamespace = JSTypeUtils.serializeType(namespace);
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.NAMESPACE_EXPLICITLY_DECLARED_FLAG, namespace.isSourceStrict());
            return this;
        }

        public Builder setNamespace(@Nullable JSQualifiedName namespace) {
            JSTypeSource typeSource = JSTypeSourceFactory.empty(JSTypeSource.SourceLanguage.JS, JSImplicitElementStructureImpl.readFlag(JSImplicitElementStructureImpl.NAMESPACE_EXPLICITLY_DECLARED_FLAG, this.myFlags));
            JSTypeContext context = !Strings.areSameInstance((String)this.mySerializedNamespace, (String)DEFAULT_NAMESPACE) ? ((JSNamespace)JSTypeParser.parseSerializedType(this.mySerializedNamespace, typeSource)).getTypeContext() : JSTypeContext.UNKNOWN;
            return this.setNamespace(JSNamedTypeFactory.createNamespace(namespace, typeSource, context, false));
        }

        @Deprecated
        public Builder setContext(JSContext context) {
            JSTypeSource typeSource = JSTypeSourceFactory.empty(JSTypeSource.SourceLanguage.JS, JSImplicitElementStructureImpl.readFlag(JSImplicitElementStructureImpl.NAMESPACE_EXPLICITLY_DECLARED_FLAG, this.myFlags));
            JSNamespace ns = ((JSNamespace)JSTypeParser.parseSerializedType(this.mySerializedNamespace, typeSource)).copyWithTypeContext(JSTypeContext.fromJSContext(context, false));
            return this.setNamespace(ns);
        }

        public Builder setOptional(boolean isOptional) {
            this.myOptional = isOptional;
            return this;
        }

        public Builder setNamespaceExplicitlyDeclared(boolean namespaceExplicitlyDeclared) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.NAMESPACE_EXPLICITLY_DECLARED_FLAG, namespaceExplicitlyDeclared);
            return this;
        }

        public Builder setProperties(JSImplicitElement.Property ... properties) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.PROPERTIES_FLAG, EnumSet.of(properties[0], properties));
            return this;
        }

        public Builder setProperties(@Nullable EnumSet<JSImplicitElement.Property> properties) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.PROPERTIES_FLAG, properties);
            return this;
        }

        public Builder setType(JSImplicitElement.Type type) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.TYPE_FLAG, type);
            return this;
        }

        public Builder setAccessType(JSAttributeList.AccessType accessType) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.ACCESS_TYPE_FLAG, accessType);
            return this;
        }

        @Deprecated
        public Builder setTypeString(@Nullable String typeString) {
            JSType type = JSTypeParser.createType(typeString, JSTypeSource.EMPTY);
            this.setJSType(type);
            return this;
        }

        public Builder setJSType(@Nullable JSType type) {
            this.mySerializedType = JSTypeUtils.serializeType(type);
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.HAS_TYPE_STRING_FLAG, this.mySerializedType != null);
            return this;
        }

        public Builder forbidAstAccess() {
            this.myAllowAstAccess = false;
            return this;
        }

        @Nullable
        public PsiElement getProvider() {
            return this.myProvider;
        }

        public Builder setProvider(@Nullable PsiElement provider) {
            this.myProvider = provider;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder setUserString(@Nullable String userString) {
            return this.setPossiblyUnregisteredUserString(userString);
        }

        public Builder setUserString(@NotNull FrameworkIndexingHandler indexingHandler, @NotNull String userString) {
            if (indexingHandler == null) {
                Builder.$$$reportNull$$$0(4);
            }
            if (userString == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return this.setUserStringWithData(indexingHandler, userString, null);
        }

        public Builder setUserStringWithData(@NotNull FrameworkIndexingHandler indexingHandler, @NotNull String userString, @Nullable String data) {
            if (indexingHandler == null) {
                Builder.$$$reportNull$$$0(6);
            }
            if (userString == null) {
                Builder.$$$reportNull$$$0(7);
            }
            if (!indexingHandler.getJSImplicitElementUserStringKeys().contains(userString)) {
                Logger.getInstance(Builder.class).error(userString + " is not registered in " + indexingHandler.getClass().getName());
            }
            this.setPossiblyUnregisteredUserString(userString);
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.HAS_USER_STRING_DATA_FLAG, data != null);
            this.myUserStringData = data;
            return this;
        }

        Builder setPossiblyUnregisteredUserString(@Nullable String userString) {
            this.myUserString = userString;
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.HAS_USER_STRING_FLAG, userString != null);
            return this;
        }

        public Builder setFlags(int flags) {
            this.myFlags = flags;
            return this;
        }

        public Builder setParameters(@Nullable List<JSImplicitParameterStructure> parameters) {
            this.myParameters = parameters;
            return this;
        }

        public Builder setOffset(int offset) {
            this.myOffset = offset;
            return this;
        }

        public Builder setFile(PsiFile file) {
            this.myFile = file;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder builder = (Builder)o;
            return this.myFlags == builder.myFlags && this.myName.equals(builder.myName) && ComparatorUtil.equalsNullable((Object)this.mySerializedNamespace, (Object)builder.mySerializedNamespace) && ComparatorUtil.equalsNullable((Object)this.mySerializedType, (Object)builder.mySerializedType) && ComparatorUtil.equalsNullable((Object)this.myProvider, (Object)builder.myProvider) && ComparatorUtil.equalsNullable((Object)this.myUserString, (Object)builder.myUserString) && ComparatorUtil.equalsNullable((Object)this.myUserStringData, (Object)builder.myUserStringData) && ComparatorUtil.equalsNullable(this.myParameters, builder.myParameters);
        }

        public int hashCode() {
            return Objects.hash(this.myName, this.mySerializedNamespace, this.myFlags, this.mySerializedType, this.myProvider, this.myUserString, this.myUserStringData);
        }

        @NotNull
        public JSImplicitElementImpl toImplicitElement() {
            if (this.myFile != null) {
                return new JSOffsetBasedImplicitElement(this, this.myOffset, this.myFile);
            }
            if (JSImplicitElementStructureImpl.readFlag(JSImplicitElementStructureImpl.TYPE_FLAG, this.myFlags).isFunction()) {
                return new JSImplicitFunctionImpl(this);
            }
            return new JSImplicitElementImpl(this);
        }

        @NotNull
        public Builder copy() {
            Builder copy = new Builder(this.myName, this.myProvider);
            this.copyFieldsTo(copy);
            Builder builder = copy;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        private void copyFieldsTo(@NotNull Builder builder) {
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            builder.mySerializedNamespace = this.mySerializedNamespace;
            builder.myFlags = this.myFlags;
            builder.mySerializedType = this.mySerializedType;
            builder.myUserString = this.myUserString;
            builder.myUserStringData = this.myUserStringData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexingHandler";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userString";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setNamespace";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setUserString";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setUserStringWithData";
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "copyFieldsTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8 -> new IllegalStateException(string);
            };
        }
    }
}

