/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.xmlSchemeGenerator.schemaEnrichers;

import com.intellij.css.xmlSchemeGenerator.webrefGenerator.XmlBuilderImpl;
import com.intellij.util.io.URLUtil;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\nJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/css/xmlSchemeGenerator/schemaEnrichers/XmlSchemaRuleEnricher;", "", "<init>", "()V", "propertyToRulesMap", "", "", "getPropertyToRulesMap", "()Ljava/util/Map;", "enrichSchema", "", "setPageModuleData", "enrichRuleAttribute", "extractProperties", "", "document", "Lorg/jsoup/nodes/Document;", "headerId", "intellij.css.xmlSchemeGenerator"})
@SourceDebugExtension(value={"SMAP\nXmlSchemaRuleEnricher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlSchemaRuleEnricher.kt\ncom/intellij/css/xmlSchemeGenerator/schemaEnrichers/XmlSchemaRuleEnricher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1869#2,2:88\n1869#2,2:90\n1#3:92\n*S KotlinDebug\n*F\n+ 1 XmlSchemaRuleEnricher.kt\ncom/intellij/css/xmlSchemeGenerator/schemaEnrichers/XmlSchemaRuleEnricher\n*L\n35#1:88,2\n38#1:90,2\n*E\n"})
public final class XmlSchemaRuleEnricher {
    @NotNull
    private final Map<String, String> propertyToRulesMap = new LinkedHashMap();

    @NotNull
    public final Map<String, String> getPropertyToRulesMap() {
        return this.propertyToRulesMap;
    }

    public final void enrichSchema() {
        this.setPageModuleData();
        this.enrichRuleAttribute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPageModuleData() {
        String it;
        String url = "https://www.w3.org/TR/css-page-3";
        URL specUrl = URI.create(url).toURL();
        List<String> pageProps = null;
        pageProps = CollectionsKt.emptyList();
        List<String> marginProps = null;
        marginProps = CollectionsKt.emptyList();
        Closeable closeable = URLUtil.openStream((URL)specUrl);
        Throwable throwable = null;
        try {
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            Document document = Jsoup.parse((InputStream)inputStream, (String)"UTF-8", (String)"");
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
            Document document2 = document;
            pageProps = this.extractProperties(document2, "page-property-list");
            marginProps = this.extractProperties(document2, "margin-property-list");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Iterable $this$forEach$iv = pageProps;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            this.propertyToRulesMap.put(it, "noname,@page");
        }
        $this$forEach$iv = marginProps;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            if (this.propertyToRulesMap.containsKey(it)) {
                this.propertyToRulesMap.put(it, this.propertyToRulesMap.get(it) + ",page-margin");
                continue;
            }
            this.propertyToRulesMap.put(it, "noname,page-margin");
        }
    }

    public final void enrichRuleAttribute() {
        File directory = new File("plugins/css/xmlSchemeGenerator/resources/result/webref/");
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        File[] listFiles = directory.listFiles();
        Intrinsics.checkNotNull((Object)listFiles);
        for (File file : listFiles) {
            org.w3c.dom.Document xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            NodeList properties = xmlDoc.getElementsByTagName("property");
            boolean modified = false;
            int n = properties.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = properties.item(i);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element property = (Element)node;
                if (Intrinsics.areEqual((Object)property.getAttribute("declared-in"), (Object)"")) continue;
                String id = property.getAttribute("id");
                String ruleAttr = property.getAttribute("rules");
                Intrinsics.checkNotNull((Object)ruleAttr);
                if (!(((CharSequence)ruleAttr).length() == 0) || !this.propertyToRulesMap.containsKey(id)) continue;
                property.setAttribute("rules", this.propertyToRulesMap.get(id));
                modified = true;
            }
            if (!modified) continue;
            new XmlBuilderImpl().outputContent(new StreamResult(file), new DOMSource(xmlDoc));
        }
    }

    private final List<String> extractProperties(Document document, String headerId) {
        org.jsoup.nodes.Element element = document.getElementById(headerId);
        if (element == null) {
            return CollectionsKt.emptyList();
        }
        org.jsoup.nodes.Element header = element;
        org.jsoup.nodes.Element element2 = header.nextElementSibling();
        if (element2 == null || (element2 = element2.nextElementSibling()) == null) {
            return CollectionsKt.emptyList();
        }
        org.jsoup.nodes.Element table = element2;
        ArrayList<String> properties = new ArrayList<String>();
        Iterator iterator = table.getElementsByTag("tbody").iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Iterator iterator3;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            org.jsoup.nodes.Element tbody = (org.jsoup.nodes.Element)e;
            Intrinsics.checkNotNullExpressionValue((Object)tbody.getElementsByTag("tr").iterator(), (String)"iterator(...)");
            while (iterator3.hasNext()) {
                String string;
                String string2;
                Object e2 = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
                org.jsoup.nodes.Element row = (org.jsoup.nodes.Element)e2;
                org.jsoup.nodes.Element element3 = row.lastElementChild();
                if (element3 == null || (string2 = element3.text()) == null) continue;
                String it = string = string2;
                boolean bl = false;
                String string3 = !StringsKt.isBlank((CharSequence)it) ? string : null;
                if (string3 == null) continue;
                String p0 = string3;
                boolean bl2 = false;
                properties.add(p0);
            }
        }
        return properties;
    }
}

