/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.console.single;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.httpClient.http.request.run.console.HttpClientConsolePrinter;
import com.intellij.httpClient.http.request.run.console.HttpClientMessagePrinter;
import com.intellij.httpClient.http.request.run.console.single.HttpResponseConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorEmbeddedComponentManager;
import com.intellij.openapi.util.Disposer;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J$\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0016J$\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/httpClient/http/request/run/console/single/HttpClientSingleConsolePrinter;", "Lcom/intellij/httpClient/http/request/run/console/HttpClientConsolePrinter;", "consoleView", "Lcom/intellij/httpClient/http/request/run/console/single/HttpResponseConsoleView;", "<init>", "(Lcom/intellij/httpClient/http/request/run/console/single/HttpResponseConsoleView;)V", "getConsoleView", "()Lcom/intellij/httpClient/http/request/run/console/single/HttpResponseConsoleView;", "flush", "", "addInlineEmbeddedComponent", "Lcom/intellij/openapi/editor/Inlay;", "component", "Ljavax/swing/JComponent;", "componentDisposable", "Lcom/intellij/openapi/Disposable;", "addInlineElementOnCurrentPosition", "aboveOffset", "", "rendererProvider", "Ljava/util/function/Function;", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "addBlockElementOnCurrentPosition", "above", "", "isPreviewSupported", "intellij.restClient"})
public final class HttpClientSingleConsolePrinter
extends HttpClientConsolePrinter {
    @NotNull
    private final HttpResponseConsoleView consoleView;

    public HttpClientSingleConsolePrinter(@NotNull HttpResponseConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)((Object)consoleView), (String)"consoleView");
        super((ConsoleView)consoleView);
        this.consoleView = consoleView;
    }

    @NotNull
    public final HttpResponseConsoleView getConsoleView() {
        return this.consoleView;
    }

    @Override
    public void flush() {
        this.consoleView.flush();
    }

    @Nullable
    public Inlay<?> addInlineEmbeddedComponent(@NotNull JComponent component2, @Nullable Disposable componentDisposable) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.flush();
        Editor editor2 = this.consoleView.getEditor();
        int lastOffset = editor2.getDocument().getTextLength();
        int line = Math.max(0, editor2.offsetToLogicalPosition((int)lastOffset).line - 1);
        int offset = editor2.getDocument().getLineStartOffset(line);
        EditorEmbeddedComponentManager editorEmbeddedComponentManager = EditorEmbeddedComponentManager.getInstance();
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        Inlay inlay = editorEmbeddedComponentManager.addComponent((EditorEx)editor2, component2, new EditorEmbeddedComponentManager.Properties(EditorEmbeddedComponentManager.ResizePolicy.none(), null, false, false, 100, offset));
        if (componentDisposable != null) {
            if (inlay != null) {
                Disposer.register((Disposable)((Disposable)inlay), (Disposable)componentDisposable);
            }
            Disposer.register((Disposable)((Disposable)this.consoleView), (Disposable)componentDisposable);
        }
        return inlay;
    }

    @Override
    public void addInlineElementOnCurrentPosition(int aboveOffset, @NotNull Function<Editor, EditorCustomElementRenderer> rendererProvider) {
        Intrinsics.checkNotNullParameter(rendererProvider, (String)"rendererProvider");
        this.flush();
        Editor editor2 = this.consoleView.getEditor();
        int lastOffset = editor2.getDocument().getTextLength();
        editor2.getInlayModel().addInlineElement(lastOffset - aboveOffset, false, 10, rendererProvider.apply(editor2));
    }

    @Override
    public void addBlockElementOnCurrentPosition(boolean above, @NotNull Function<Editor, EditorCustomElementRenderer> rendererProvider) {
        Intrinsics.checkNotNullParameter(rendererProvider, (String)"rendererProvider");
        this.flush();
        Editor editor2 = this.consoleView.getEditor();
        int lastOffset = editor2.getDocument().getTextLength();
        EditorCustomElementRenderer editorCustomElementRenderer2 = rendererProvider.apply(editor2);
        Intrinsics.checkNotNullExpressionValue((Object)editorCustomElementRenderer2, (String)"apply(...)");
        EditorCustomElementRenderer elementRenderer = editorCustomElementRenderer2;
        Inlay inlay = editor2.getInlayModel().addBlockElement(lastOffset, false, above, 10, elementRenderer);
        if (inlay != null && elementRenderer instanceof HttpClientMessagePrinter.ParentDisposableProvider) {
            Disposable parentDisposable = ((HttpClientMessagePrinter.ParentDisposableProvider)elementRenderer).getParentDisposable();
            Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)inlay));
            Disposer.register((Disposable)((Disposable)this.consoleView), (Disposable)parentDisposable);
        }
    }

    @Override
    public boolean isPreviewSupported() {
        return true;
    }
}

