/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.JupyterCellData;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellConverterTask;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesActionUtil;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesDocumentUtils;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellsContents;
import com.intellij.jupyter.core.core.impl.actions.RemoveOutputsUndoableAction;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.lang.JupyterLangData;
import com.intellij.notebooks.jupyter.core.jupyter.CellType;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellConverter;", "", "convertCell", "", "task", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellConverterTask;", "Companion", "intellij.jupyter.core"})
public interface NotebookCellConverter {
    @NotNull
    public static final Companion Companion = com.intellij.jupyter.core.core.impl.actions.NotebookCellConverter$Companion.$$INSTANCE;

    public boolean convertCell(@NotNull NotebookCellConverterTask var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0017J,\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellConverter$Companion;", "", "<init>", "()V", "EP_NAME", "", "EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellConverter;", "convertCells", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "cellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "cellSelection", "Lcom/intellij/notebooks/visualization/NotebookCellSelectionModel;", "newType", "Lcom/intellij/jupyter/core/jupyter/lang/JupyterLangData;", "defaultConvertCell", "", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "task", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellConverterTask;", "replaceCellWithUndoSupport", "cellText", "interval", "notebookCellLines", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nNotebookCellConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellConverter.kt\ncom/intellij/jupyter/core/core/impl/actions/NotebookCellConverter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n295#2,2:88\n1#3:90\n*S KotlinDebug\n*F\n+ 1 NotebookCellConverter.kt\ncom/intellij/jupyter/core/core/impl/actions/NotebookCellConverter$Companion\n*L\n42#1:88,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String EP_NAME = "com.intellij.jupyter.core.core.impl.actions.notebookCellConverter";
        @NotNull
        private static final ExtensionPointName<NotebookCellConverter> EP;

        private Companion() {
        }

        public final void convertCells(@NotNull Editor editor, @NotNull NotebookCellLines cellLines, @NotNull NotebookCellSelectionModel cellSelection, @NotNull JupyterLangData newType) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
            Intrinsics.checkNotNullParameter((Object)cellSelection, (String)"cellSelection");
            Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
            ThreadingAssertions.assertWriteAccess();
            NotebookCellLinesEditHelper notebookCellLinesEditHelper = NotebookCellLinesEditHelper.Companion.getOrNull(editor);
            if (notebookCellLinesEditHelper == null) {
                return;
            }
            NotebookCellLinesEditHelper editHelper = notebookCellLinesEditHelper;
            List selectedCells = cellSelection.getSelectedCells();
            for (NotebookCellLines.Interval interval : CollectionsKt.reversed((Iterable)selectedCells)) {
                Object object;
                Object v1;
                NotebookCellConverterTask task;
                block3: {
                    if (Intrinsics.areEqual((Object)JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(interval), (Object)newType.getJupyterCellType())) continue;
                    task = new NotebookCellConverterTask(interval, newType, editor, editHelper, cellLines);
                    Iterable $this$firstOrNull$iv = EP.getExtensionList();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        NotebookCellConverter it = (NotebookCellConverter)element$iv;
                        boolean bl = false;
                        if (!it.convertCell(task)) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                if ((object = (NotebookCellConverter)v1) != null) continue;
                object = this.defaultConvertCell(task);
            }
        }

        @Nullable
        public final List<NotebookCellLines.Interval> defaultConvertCell(@NotNull NotebookCellConverterTask task) {
            String string;
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            Editor editor = task.getEditor();
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            CharSequence cellText = task.getInterval().getContentText(document2);
            String it = string = task.getNewType().getHeaderSuffix();
            boolean bl = false;
            String headerSuffix = task.getNewType().getCellType() == CellType.CODE ? string : null;
            String newText = task.getEditHelper().makeCell(((Object)cellText).toString(), task.getNewType().getCellType(), headerSuffix);
            List<NotebookCellLines.Interval> result2 = null;
            if (newText != null) {
                result2 = this.replaceCellWithUndoSupport(editor, newText, task.getInterval(), task.getCellLines());
            }
            return result2;
        }

        @NotNull
        public final List<NotebookCellLines.Interval> replaceCellWithUndoSupport(@NotNull Editor editor, @NotNull String cellText, @NotNull NotebookCellLines.Interval interval, @NotNull NotebookCellLines notebookCellLines) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)cellText, (String)"cellText");
            Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
            Intrinsics.checkNotNullParameter((Object)notebookCellLines, (String)"notebookCellLines");
            ThreadingAssertions.assertWriteAccess();
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            List inserted = NotebookCellLinesDocumentUtils.insertCells$default(NotebookCellLinesDocumentUtils.INSTANCE, document, notebookCellLines, cellText, interval.getOrdinal() + 1, false, 8, null);
            NotebookCellsContents cellContent = NotebookCellsContents.Companion.invoke(editor, CollectionsKt.listOf((Object)interval));
            RemoveOutputsUndoableAction undoableAction = new RemoveOutputsUndoableAction(editor, cellContent);
            Project project = editor.getProject();
            if (project != null) {
                Project p0 = project;
                boolean bl = false;
                UndoManager undoManager = UndoManager.getInstance((Project)p0);
                project = undoManager;
                if (undoManager != null) {
                    project.undoableActionPerformed((UndoableAction)undoableAction);
                }
            }
            NotebookCellLinesActionUtil.INSTANCE.moveCarets(editor, CollectionsKt.listOf((Object)interval), inserted);
            List<JupyterCellData> toBeRemovedCells = NotebookCellsContents.Companion.invoke(editor, CollectionsKt.listOf((Object)interval)).getJupyterCells();
            if (toBeRemovedCells != null) {
                NotebookCellLinesActionUtil.INSTANCE.setCellData(editor, NotebookCellLines.Companion.get(editor), inserted, toBeRemovedCells, false, false);
            }
            Document document2 = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            NotebookCellLinesDocumentUtils.INSTANCE.removeCell(document2, interval, NotebookIntervalPointerFactory.Companion.getOrNull(editor));
            NotebookCellLines.Interval interval2 = notebookCellLines.getCell(interval.getLines().getFirst());
            Intrinsics.checkNotNull((Object)interval2);
            return CollectionsKt.listOf((Object)interval2);
        }

        static {
            $$INSTANCE = new Companion();
            EP = new ExtensionPointName(EP_NAME);
        }
    }
}

