/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.com.ibm.icu.charset;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.graalvm.shadowed.com.ibm.icu.charset.CharsetICU;
import org.graalvm.shadowed.com.ibm.icu.charset.CharsetMBCS;
import org.graalvm.shadowed.com.ibm.icu.charset.UConverterAlias;
import org.graalvm.shadowed.com.ibm.icu.impl.InvalidFormatException;

public final class CharsetProviderICU
extends CharsetProvider {
    private static List<Charset> icuCharsets = Collections.emptyList();

    @Override
    public final Charset charsetForName(String charsetName) {
        try {
            String icuCanonicalName;
            String optionsString = "";
            if (charsetName.endsWith(",swaplfnl")) {
                optionsString = ",swaplfnl";
                charsetName = charsetName.substring(0, charsetName.length() - optionsString.length());
            }
            if ((icuCanonicalName = CharsetProviderICU.getICUCanonicalName(charsetName)) == null || icuCanonicalName.length() == 0) {
                icuCanonicalName = charsetName;
            }
            return CharsetProviderICU.getCharset(icuCanonicalName, optionsString);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public final Charset charsetForName(String charsetName, String classPath) {
        return this.charsetForName(charsetName, classPath, null);
    }

    public Charset charsetForName(String charsetName, String classPath, ClassLoader loader) {
        CharsetMBCS cs = null;
        try {
            cs = new CharsetMBCS(charsetName, charsetName, new String[0], classPath, loader);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        return cs;
    }

    @Deprecated
    public static final String getICUCanonicalName(String enc) throws UnsupportedCharsetException {
        String canonicalName = null;
        String ret = null;
        try {
            if (enc != null) {
                canonicalName = UConverterAlias.getCanonicalName(enc, "MIME");
                ret = canonicalName != null ? canonicalName : ((canonicalName = UConverterAlias.getCanonicalName(enc, "IANA")) != null ? canonicalName : ((canonicalName = UConverterAlias.getAlias(enc, 0)) != null ? canonicalName : (enc.indexOf("x-") == 0 || enc.indexOf("X-") == 0 ? ((canonicalName = UConverterAlias.getAlias(enc.substring(2), 0)) != null ? canonicalName : "") : "")));
            }
            return ret;
        }
        catch (IOException ex) {
            throw new UnsupportedCharsetException(enc);
        }
    }

    private static final Charset getCharset(String icuCanonicalName, String optionsString) throws IOException {
        String[] aliases = CharsetProviderICU.getAliases(icuCanonicalName);
        String canonicalName = CharsetProviderICU.getJavaCanonicalName(icuCanonicalName);
        return CharsetICU.getCharset(icuCanonicalName + optionsString, canonicalName, aliases);
    }

    @Deprecated
    public static String getJavaCanonicalName(String charsetName) {
        if (charsetName == null) {
            return null;
        }
        try {
            Object cName = null;
            cName = UConverterAlias.getStandardName(charsetName, "MIME");
            if (cName == null && (cName = UConverterAlias.getStandardName(charsetName, "IANA")) == null) {
                String name;
                int aliasNum = UConverterAlias.countAliases(charsetName);
                for (int i = 0; i < aliasNum; ++i) {
                    name = UConverterAlias.getAlias(charsetName, i);
                    if (name == null || name.indexOf("x-") != 0) continue;
                    cName = name;
                    break;
                }
                if (cName == null || ((String)cName).length() == 0) {
                    name = UConverterAlias.getStandardName(charsetName, "UTR22");
                    if (name == null && charsetName.indexOf(",") != -1) {
                        name = UConverterAlias.getAlias(charsetName, 1);
                    }
                    if (name == null) {
                        name = charsetName;
                    }
                    cName = "x-" + name;
                }
            }
            return cName;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Deprecated
    private static final String[] getAliases(String encName) throws IOException {
        String[] ret = null;
        int aliasNum = 0;
        int i = 0;
        int j = 0;
        String[] aliasArray = new String[50];
        if (encName != null) {
            aliasNum = UConverterAlias.countAliases(encName);
            j = 0;
            for (i = 0; i < aliasNum; ++i) {
                String name = UConverterAlias.getAlias(encName, i);
                if (name.indexOf(44) != -1) continue;
                aliasArray[j++] = name;
            }
            ret = new String[j];
            while (--j >= 0) {
                ret[j] = aliasArray[j];
            }
        }
        return ret;
    }

    private static final synchronized void loadAvailableICUCharsets() {
        if (!icuCharsets.isEmpty()) {
            return;
        }
        LinkedList<Charset> icucs = new LinkedList<Charset>();
        int num = UConverterAlias.countAvailable();
        for (int i = 0; i < num; ++i) {
            String name = UConverterAlias.getAvailableName(i);
            try {
                Charset cs = CharsetProviderICU.getCharset(name, "");
                icucs.add(cs);
                continue;
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        icuCharsets = Collections.unmodifiableList(icucs);
    }

    @Override
    public final Iterator<Charset> charsets() {
        CharsetProviderICU.loadAvailableICUCharsets();
        return icuCharsets.iterator();
    }

    @Deprecated
    public static final String[] getAvailableNames() {
        CharsetProviderICU.loadAvailableICUCharsets();
        String[] names = new String[icuCharsets.size()];
        int i = 0;
        for (Charset cs : icuCharsets) {
            names[i++] = cs.name();
        }
        return names;
    }

    @Deprecated
    public static final String[] getAllNames() {
        int num = UConverterAlias.countAvailable();
        String[] names = new String[num];
        for (int i = 0; i < num; ++i) {
            names[i] = UConverterAlias.getAvailableName(i);
        }
        return names;
    }
}

