/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.css.util.CssConstants;
import com.intellij.ide.highlighter.custom.tokens.TokenInfo;
import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.EmbedmentLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.lexing.CssLexer;
import com.intellij.psi.css.util.CssTermTypeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.BitUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CssHighlighterLexer
extends DelegateLexer
implements EmbedmentLexer {
    private static final TokenSet END_DECLARATION_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_SEMICOLON, CssElementTypes.CSS_RBRACE});
    private char[] myOneTokenBuffer;
    private int myNextLBraceIndex;
    private int myNextEndDeclarationTokenIndex;
    private int myBlockNestingDepth;
    protected IElementType lastElementType;
    protected boolean myInsideBlock;
    protected boolean myAfterColon;
    protected boolean myAfterMediaOrSupports;
    private boolean myAfterKeyframes;
    protected boolean myInKeyframes;
    private boolean myAfterPeriod;
    protected boolean myJustAfterColon;
    protected boolean myInPropertyValue;
    protected boolean myAfterLeftBrace;
    private boolean myAfterRightBrace;
    protected boolean myAfterSemicolon;
    protected int myFunctionNestingDepth;
    private boolean myInsideAttribute;
    private static final int MY_DELEGATE_STATE_SHIFT = 4;
    private static final int MY_DELEGATE_STATE_MASK = 15;
    protected static final int MY_BASE_STATE_SHIFT = 24;
    private static final int BLOCK_LEVEL_MASK = 983040;
    private static final int FUNCTIONS_LEVEL_MASK = 15;
    private static final int MY_JUST_AFTER_COLON_MASK = 16;
    private static final int MY_INSIDE_KEYFRAMES_MASK = 32;
    private static final int MY_AFTER_MEDIA_OR_SUPPORTS_MASK = 64;
    private static final int MY_AFTER_COLON_MASK = 128;
    private static final int MY_AFTER_KEYFRAMES_MASK = 256;
    private static final int MY_AFTER_PERIOD_MASK = 512;
    private static final int MY_IN_PROPERTY_VALUE_MASK = 1024;
    private static final int MY_AFTER_SEMICOLON = 2048;
    private static final int MY_AFTER_LEFT_BRACE = 4096;
    private static final int MY_AFTER_RIGHT_BRACE = 8192;
    private static final int MY_INSIDE_BLOCK_MASK = 65536;
    private static final int MY_INSIDE_ATTRIBUTE_MASK = 32768;

    @Deprecated
    public CssHighlighterLexer(@NotNull Set<String> propertyValues) {
        if (propertyValues == null) {
            CssHighlighterLexer.$$$reportNull$$$0(0);
        }
        this((Lexer)new CssLexer());
    }

    public CssHighlighterLexer() {
        this((Lexer)new CssLexer());
    }

    public CssHighlighterLexer(@NotNull Lexer lexer) {
        if (lexer == null) {
            CssHighlighterLexer.$$$reportNull$$$0(1);
        }
        super(lexer);
        this.myNextLBraceIndex = -1;
        this.myNextEndDeclarationTokenIndex = -1;
        this.myBlockNestingDepth = 0;
        this.myFunctionNestingDepth = 0;
        this.myInsideAttribute = false;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            CssHighlighterLexer.$$$reportNull$$$0(2);
        }
        this.getDelegate().start(buffer, startOffset, endOffset, initialState & 0xF);
        this.lastElementType = null;
        this.initState(initialState);
    }

    protected void initState(int initialState) {
        int i = initialState >> 4;
        this.myInsideBlock = BitUtil.isSet((int)i, (int)65536);
        this.myInKeyframes = BitUtil.isSet((int)i, (int)32);
        this.myAfterKeyframes = BitUtil.isSet((int)i, (int)256);
        this.myAfterColon = BitUtil.isSet((int)i, (int)128);
        this.myAfterMediaOrSupports = BitUtil.isSet((int)i, (int)64);
        this.myAfterPeriod = BitUtil.isSet((int)i, (int)512);
        this.myJustAfterColon = BitUtil.isSet((int)i, (int)16);
        this.myInPropertyValue = BitUtil.isSet((int)i, (int)1024);
        this.myAfterLeftBrace = BitUtil.isSet((int)i, (int)4096);
        this.myAfterRightBrace = BitUtil.isSet((int)i, (int)8192);
        this.myAfterSemicolon = BitUtil.isSet((int)i, (int)2048);
        this.myInsideAttribute = BitUtil.isSet((int)i, (int)32768);
        this.myFunctionNestingDepth = i & 0xF;
        this.myBlockNestingDepth = (i & 0xF0000) >> 16;
        this.myNextLBraceIndex = -1;
        this.myNextEndDeclarationTokenIndex = -1;
    }

    public int getState() {
        int state = 0;
        state |= this.myAfterColon ? 128 : 0;
        state |= this.myAfterMediaOrSupports ? 64 : 0;
        state |= this.myInKeyframes ? 32 : 0;
        state |= this.myAfterKeyframes ? 256 : 0;
        state |= this.myAfterPeriod ? 512 : 0;
        state |= this.myInsideBlock ? 65536 : 0;
        state |= this.myJustAfterColon ? 16 : 0;
        state |= this.myInPropertyValue ? 1024 : 0;
        state |= this.myAfterLeftBrace ? 4096 : 0;
        state |= this.myAfterRightBrace ? 8192 : 0;
        state |= this.myAfterSemicolon ? 2048 : 0;
        state |= this.myInsideAttribute ? 32768 : 0;
        state |= Math.min(this.myFunctionNestingDepth, 15);
        return this.getDelegate().getState() | (state |= Math.min(this.myBlockNestingDepth, 15) << 16) << 4;
    }

    public void advance() {
        IElementType tokenType = this.getTokenType();
        if (tokenType == CssElementTypes.CSS_LBRACE && !this.myAfterKeyframes) {
            ++this.myBlockNestingDepth;
        }
        if (tokenType == CssElementTypes.CSS_RBRACE && !this.myInKeyframes && this.myBlockNestingDepth > 0) {
            --this.myBlockNestingDepth;
        }
        this.myAfterPeriod = false;
        this.myJustAfterColon = false;
        this.myAfterSemicolon &= CssElementTypes.WHITESPACES.contains(tokenType);
        this.myAfterRightBrace &= CssElementTypes.WHITESPACES.contains(tokenType);
        this.myAfterLeftBrace &= CssElementTypes.WHITESPACES.contains(tokenType);
        if (tokenType == CssElementTypes.CSS_FUNCTION_TOKEN) {
            ++this.myFunctionNestingDepth;
        }
        if (tokenType == CssElementTypes.CSS_RPAREN && this.myFunctionNestingDepth > 0) {
            --this.myFunctionNestingDepth;
        }
        if (tokenType == CssElementTypes.CSS_PROPERTY_NAME) {
            this.myInPropertyValue = true;
            this.myInsideAttribute = false;
        }
        if (tokenType == CssElementTypes.CSS_KEYFRAMES_SYM) {
            this.myAfterKeyframes = true;
            this.myAfterColon = false;
            this.myInsideAttribute = false;
        }
        if (tokenType == CssElementTypes.CSS_LBRACKET) {
            this.myInsideAttribute = true;
        }
        if (tokenType == CssElementTypes.CSS_RBRACKET) {
            this.myInsideAttribute = false;
        } else if (tokenType == CssElementTypes.CSS_LBRACE) {
            if (this.myAfterKeyframes) {
                this.myAfterKeyframes = false;
                this.myInKeyframes = true;
            } else if (this.myAfterMediaOrSupports) {
                this.myAfterMediaOrSupports = false;
            }
            this.myInsideAttribute = false;
            this.myAfterColon = false;
            this.myAfterLeftBrace = true;
            this.myInPropertyValue = false;
        } else if (tokenType == CssElementTypes.CSS_RBRACE) {
            if (this.myInKeyframes && !this.myInsideBlock) {
                this.myInKeyframes = false;
            }
            this.myInsideAttribute = false;
            this.myAfterRightBrace = true;
            this.myInsideBlock = false;
            this.myAfterColon = false;
            this.myInPropertyValue = false;
        } else if (tokenType == CssElementTypes.CSS_COLON) {
            this.myInsideAttribute = false;
            this.myAfterColon = true;
            this.myJustAfterColon = true;
        } else if (tokenType == CssElementTypes.CSS_SEMICOLON) {
            this.myInsideAttribute = false;
            this.myAfterColon = false;
            this.myAfterSemicolon = true;
            this.myInPropertyValue = false;
        } else if (tokenType == CssElementTypes.CSS_KEYWORD) {
            this.myInsideAttribute = false;
            IElementType realType = this.getDelegate().getTokenType();
            if (realType == CssElementTypes.CSS_MEDIA_SYM || realType == CssElementTypes.CSS_SUPPORTS_SYM) {
                this.myAfterMediaOrSupports = true;
                this.myAfterColon = false;
            }
        } else if (tokenType == CssElementTypes.CSS_PERIOD) {
            this.myInsideAttribute = false;
            this.myAfterPeriod = true;
        } else if (this.myAfterMediaOrSupports && (this.isAndOrIdentifier(tokenType, this.getTokenText()) || !this.myAfterColon && tokenType == CssElementTypes.CSS_LPAREN)) {
            this.myInsideAttribute = false;
            this.myAfterColon = false;
            this.myInsideBlock = false;
            this.myInPropertyValue = false;
        }
        this.getDelegate().advance();
        this.lastElementType = null;
        this.updateMyInsideBlock();
    }

    protected void updateMyInsideBlock() {
        this.myInsideBlock = this.myBlockNestingDepth > 0;
    }

    protected boolean isAndOrIdentifier(IElementType type, String tokenText) {
        return type == CssElementTypes.CSS_IDENT && ("and".equalsIgnoreCase(tokenText) || "or".equalsIgnoreCase(tokenText));
    }

    protected boolean isSelectorAllowed() {
        boolean propertyRuleset = this.lookAhead(1) == CssElementTypes.CSS_COLON && this.lookAhead(2) == CssElementTypes.CSS_LBRACE;
        return !this.myInPropertyValue && this.myFunctionNestingDepth <= 0 && !this.myAfterMediaOrSupports && !propertyRuleset && !this.isTerminatedDeclaration();
    }

    public IElementType getTokenType() {
        if (this.lastElementType != null) {
            return this.lastElementType;
        }
        IElementType type = this.getDelegate().getTokenType();
        if ((type == CssElementTypes.CSS_NUMBER || type == CssElementTypes.CSS_PERCENT) && this.myInKeyframes && !this.myAfterColon) {
            return CssElementTypes.CSS_IDENT;
        }
        if (type == CssElementTypes.CSS_HASH && this.isPropertyValueAllowed() && !this.isSelectorAllowed()) {
            type = CssElementTypes.CSS_COLOR;
        } else if ((type == CssElementTypes.CSS_FUNCTION_TOKEN || type == CssElementTypes.CSS_IDENT) && this.isPseudoSelectorAllowed()) {
            type = CssElementTypes.CSS_PSEUDO;
        } else if (type == CssElementTypes.CSS_ASTERISK && !this.myAfterPeriod && this.isSelectorAllowed()) {
            type = CssElementTypes.CSS_TAG_NAME;
        } else if (type == CssElementTypes.CSS_IDENT) {
            String tokenText = this.getCurrentTokenText();
            boolean afterPeriod = this.myAfterPeriod;
            if (this.myInKeyframes && !this.myInsideBlock || this.myInsideAttribute || CssConstants.CONDITION_KEYWORDS.contains(this.getCurrentTokenText())) {
                return CssElementTypes.CSS_IDENT;
            }
            if (!this.isSelectorAllowed()) {
                if (!afterPeriod && this.isPropertyNameAllowed()) {
                    type = CssElementTypes.CSS_PROPERTY_NAME;
                } else if (this.isPropertyValueAllowed() && !tokenText.startsWith("--")) {
                    type = CssTermTypeUtil.getTypeBySuffix(tokenText) != CssTermType.UNKNOWN ? CssElementTypes.CSS_UNIT : CssElementTypes.CSS_PROPERTY_VALUE;
                }
            }
        } else if (CssElementTypes.KEYWORDS.contains(type)) {
            type = CssElementTypes.CSS_KEYWORD;
        } else if (this.myAfterPeriod && this.isSelectorAllowed()) {
            type = CssElementTypes.CSS_IDENT;
        } else if (type == CssElementTypes.CSS_EXPRESSION) {
            type = CssElementTypes.CSS_FUNCTION_TOKEN;
        }
        this.lastElementType = type;
        return this.lastElementType;
    }

    private boolean isPseudoSelectorAllowed() {
        return this.myJustAfterColon && this.isSelectorAllowed() && !this.isPropertyValueAllowed() && !this.isPropertyNameAllowed();
    }

    public boolean isPropertyValueAllowed() {
        return !(!this.myAfterMediaOrSupports && !this.myInsideBlock || !this.myInPropertyValue && this.myFunctionNestingDepth <= 0);
    }

    protected boolean isPropertyNameAllowed() {
        return !this.myAfterColon && (this.myAfterMediaOrSupports || this.myInsideBlock) && !this.myInPropertyValue && this.myFunctionNestingDepth <= 0;
    }

    protected String getCurrentTokenText() {
        int start = this.getTokenStart();
        int len = this.getTokenEnd() - start;
        if (this.myOneTokenBuffer == null || this.myOneTokenBuffer.length < len) {
            this.myOneTokenBuffer = new char[len];
        }
        CharSequence buffer = this.getBufferSequence();
        for (int i = 0; i < len; ++i) {
            this.myOneTokenBuffer[i] = Character.toLowerCase(buffer.charAt(start + i));
        }
        return new String(this.myOneTokenBuffer, 0, len);
    }

    public int getEmbeddedInitialState(IElementType tokenType) {
        if (tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
            return 0x100000;
        }
        if (tokenType == XmlTokenType.XML_REAL_WHITE_SPACE) {
            return 0x100000;
        }
        return 0;
    }

    protected Lexer getLookAheadLexer() {
        return this.getDelegate();
    }

    protected IElementType lookAhead(int steps) {
        return this.lookAhead(steps, true);
    }

    protected IElementType lookAhead(int steps, boolean skipWhitespaces) {
        return this.lookAheadInfo(steps, skipWhitespaces).getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TokenInfo lookAheadInfo(int steps, boolean skipWhitespaces) {
        LexerPosition currentPosition = this.getDelegate().getCurrentPosition();
        Lexer lookAheadLexer = this.getLookAheadLexer();
        lookAheadLexer.restore(currentPosition);
        try {
            while (steps > 0) {
                lookAheadLexer.advance();
                IElementType type = lookAheadLexer.getTokenType();
                if (type == null) break;
                if (skipWhitespaces && CssHighlighterLexer.isWhitespace(type)) continue;
                --steps;
            }
            TokenInfo result = new TokenInfo();
            result.updateData(lookAheadLexer.getTokenStart(), lookAheadLexer.getTokenEnd(), lookAheadLexer.getTokenType());
            TokenInfo tokenInfo = result;
            return tokenInfo;
        }
        finally {
            lookAheadLexer.restore(currentPosition);
        }
    }

    private static boolean isWhitespace(IElementType type) {
        return CssElementTypes.WHITESPACES.contains(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTerminatedDeclaration() {
        int start = this.getTokenStart();
        if (start <= this.myNextLBraceIndex) {
            return false;
        }
        if (start <= this.myNextEndDeclarationTokenIndex) {
            return true;
        }
        LexerPosition currentPosition = this.getDelegate().getCurrentPosition();
        Lexer lookAheadLexer = this.getLookAheadLexer();
        lookAheadLexer.restore(currentPosition);
        try {
            while (true) {
                ProgressManager.checkCanceled();
                lookAheadLexer.advance();
                IElementType type = lookAheadLexer.getTokenType();
                if (type == CssElementTypes.CSS_LBRACE) {
                    this.myNextLBraceIndex = lookAheadLexer.getTokenStart();
                    break;
                }
                if (type != null && !END_DECLARATION_TOKENS.contains(type)) continue;
                this.myNextEndDeclarationTokenIndex = lookAheadLexer.getTokenStart();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            lookAheadLexer.restore(currentPosition);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyValues";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/impl/util/CssHighlighterLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

