/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.grpc.requests.execution;

import com.intellij.httpClient.grpc.requests.execution.GrpcPrepareExecutionEnvironmentTaskKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.protobuf.ide.settings.PbImportPathsConfiguration;
import com.intellij.protobuf.ide.settings.PbProjectSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u001a\b\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"extractImportPathsToDisk", "", "", "project", "Lcom/intellij/openapi/project/Project;", "extractCustomProtoFromJar", "pathInJar", "tempPluginFolder", "Ljava/io/File;", "intellij.httpClient.grpc"})
@SourceDebugExtension(value={"SMAP\nGrpcPrepareExecutionEnvironmentTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcPrepareExecutionEnvironmentTask.kt\ncom/intellij/httpClient/grpc/requests/execution/GrpcPrepareExecutionEnvironmentTaskKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class GrpcPrepareExecutionEnvironmentTaskKt {
    @NotNull
    public static final Collection<String> extractImportPathsToDisk(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PbProjectSettings pbProjectSettings = PbProjectSettings.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)pbProjectSettings, (String)"getInstance(...)");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.plus((Sequence)SequencesKt.map((Sequence)PbImportPathsConfiguration.computeDeterministicImportPaths((Project)project, (PbProjectSettings)pbProjectSettings), (Function1)extractImportPathsToDisk.1.INSTANCE), (Iterable)PbImportPathsConfiguration.getOrComputeImportPathsForAllImportStatements((Project)project)), GrpcPrepareExecutionEnvironmentTaskKt::extractImportPathsToDisk$lambda$0));
    }

    private static final String extractCustomProtoFromJar(String pathInJar) {
        Path path;
        MessageDigest $this$extractCustomProtoFromJar_u24lambda_u240 = DigestUtil.md5();
        boolean bl = false;
        String string = PathUtil.toSystemIndependentName((String)pathInJar);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        $this$extractCustomProtoFromJar_u24lambda_u240.update(byArray);
        String jarPathHash = DigestUtil.digestToHash((MessageDigest)$this$extractCustomProtoFromJar_u24lambda_u240);
        Path extractedPath = FilesKt.resolve((File)GrpcPrepareExecutionEnvironmentTaskKt.tempPluginFolder(), (String)jarPathHash).toPath();
        Object object = URLUtil.splitJarUrl((String)pathInJar);
        if (object != null && (object = (String)object.first) != null) {
            Object it = object;
            boolean bl2 = false;
            path = Path.of((String)it, new String[0]);
        } else {
            path = null;
        }
        Intrinsics.checkNotNull(path);
        Path pathOrNull = path;
        try {
            ZipUtil.extract((Path)pathOrNull, (Path)extractedPath, GrpcPrepareExecutionEnvironmentTaskKt::extractCustomProtoFromJar$lambda$2, (boolean)true);
        }
        catch (IOException exception) {
            Logger.getInstance((String)"GrpcPrepareExecutionRequest").warn("Error during extracting proto files from jars", (Throwable)exception);
            FileUtil.delete((Path)extractedPath);
        }
        Intrinsics.checkNotNull((Object)extractedPath);
        return ((Object)extractedPath.toAbsolutePath()).toString();
    }

    private static final File tempPluginFolder() {
        File file = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("grpc").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private static final String extractImportPathsToDisk$lambda$0(String importUrl) {
        String string;
        String string2 = URLUtil.extractPath((String)importUrl);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"extractPath(...)");
        String importPath = string2;
        Intrinsics.checkNotNull((Object)importUrl);
        if (StringsKt.startsWith$default((String)importUrl, (String)"jar", (boolean)false, (int)2, null)) {
            void var2_2;
            String extractedPath = GrpcPrepareExecutionEnvironmentTaskKt.extractCustomProtoFromJar(importPath);
            string = var2_2;
        } else {
            string = importPath;
        }
        return string;
    }

    private static final boolean extractCustomProtoFromJar$lambda$2(File file, String name) {
        return Intrinsics.areEqual((Object)FileUtilRt.getExtension((String)name), (Object)"proto");
    }
}

