/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import java.util.Objects;

public class ToolSpecification {
    private final String name;
    private final String description;
    private final JsonObjectSchema parameters;

    private ToolSpecification(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.parameters = builder.parameters;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public JsonObjectSchema parameters() {
        return this.parameters;
    }

    public boolean equals(Object another) {
        ToolSpecification ts;
        if (this == another) {
            return true;
        }
        return another instanceof ToolSpecification && this.equalTo(ts = (ToolSpecification)another);
    }

    private boolean equalTo(ToolSpecification another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && Objects.equals(this.parameters, another.parameters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.parameters);
        return h;
    }

    public String toString() {
        return "ToolSpecification { name = " + Utils.quoted(this.name) + ", description = " + Utils.quoted(this.description) + ", parameters = " + String.valueOf(this.parameters) + " }";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String description;
        private JsonObjectSchema parameters;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parameters(JsonObjectSchema parameters) {
            this.parameters = parameters;
            return this;
        }

        public ToolSpecification build() {
            return new ToolSpecification(this);
        }
    }
}

