/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.extractFunction;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionDialog;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfoKt;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableParameterInfo;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0002\u0011\u0014\u0018\u00002\u00020\u0001:\u0001&B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\bH\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\bH\u0014J\b\u0010%\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006'"}, d2={"Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "originalInfo", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;", "helper", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper;", "doRefactor", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper;Lkotlin/jvm/functions/Function1;)V", "functionNameField", "Lcom/intellij/ui/EditorTextField;", "tableModel", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionDialog$ParameterModel;", "signatureView", "com/intellij/sql/refactoring/extractFunction/SqlExtractFunctionDialog$signatureView$1", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionDialog$signatureView$1;", "centerPanel", "com/intellij/sql/refactoring/extractFunction/SqlExtractFunctionDialog$centerPanel$1", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionDialog$centerPanel$1;", "setupHighlighting", "Lcom/intellij/openapi/editor/ex/EditorEx;", "createCenterPanel", "Ljavax/swing/JSplitPane;", "getPreferredFocusedComponent", "createTopPanel", "Ljavax/swing/JComponent;", "createParametersTable", "createSignaturePanel", "createParametersListTable", "Lcom/intellij/util/ui/table/JBListTable;", "updateSignature", "isOKActionEnabled", "", "doOKAction", "createFunctionInfo", "ParameterModel", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlExtractFunctionDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlExtractFunctionDialog.kt\ncom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n1563#2:270\n1634#2,3:271\n1563#2:274\n1634#2,3:275\n*S KotlinDebug\n*F\n+ 1 SqlExtractFunctionDialog.kt\ncom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionDialog\n*L\n72#1:270\n72#1:271,3\n267#1:274\n267#1:275,3\n*E\n"})
public final class SqlExtractFunctionDialog
extends DialogWrapper {
    @NotNull
    private final SqlExtractFunctionInfo originalInfo;
    @NotNull
    private final SqlExtractFunctionHelper helper;
    @NotNull
    private final Function1<SqlExtractFunctionInfo, Unit> doRefactor;
    @NotNull
    private final EditorTextField functionNameField;
    @NotNull
    private final ListTableModel<ParameterModel> tableModel;
    @NotNull
    private final signatureView.1 signatureView;
    @NotNull
    private final centerPanel.1 centerPanel;

    /*
     * WARNING - void declaration
     */
    public SqlExtractFunctionDialog(@NotNull SqlExtractFunctionInfo originalInfo, @NotNull SqlExtractFunctionHelper helper, @NotNull Function1<? super SqlExtractFunctionInfo, Unit> doRefactor) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)originalInfo, (String)"originalInfo");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter(doRefactor, (String)"doRefactor");
        super(originalInfo.getCodeInfo().getProject());
        this.originalInfo = originalInfo;
        this.helper = helper;
        this.doRefactor = doRefactor;
        this.functionNameField = new EditorTextField(this.originalInfo.getName());
        this.tableModel = new ListTableModel(new ColumnInfo[0]);
        Object object = this.originalInfo.getCodeInfo().getProject();
        SqlFileType sqlFileType = SqlFileType.INSTANCE;
        this.signatureView = new MethodSignatureComponent(this, (Project)object, sqlFileType){
            final /* synthetic */ SqlExtractFunctionDialog this$0;
            {
                this.this$0 = $receiver;
                super("", $super_call_param$1, (FileType)$super_call_param$2);
            }

            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
                return SqlExtractFunctionDialog.access$setupHighlighting(this.this$0, editorEx);
            }
        };
        this.centerPanel = new JSplitPane(this){
            {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)SqlExtractFunctionDialog.access$createTopPanel($receiver), "North");
                panel.add((Component)SqlExtractFunctionDialog.access$createParametersTable($receiver), "Center");
                this.setTopComponent(panel);
                this.setBottomComponent(SqlExtractFunctionDialog.access$createSignaturePanel($receiver));
            }
        };
        this.setTitle(SqlBundle.message((String)"extract.routine", (Object[])new Object[0]));
        this.init();
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.centerPanel);
        object = this.originalInfo.getCodeInfo().getParameterInfos();
        ListTableModel<ParameterModel> listTableModel = this.tableModel;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            SqlExtractableParameterInfo sqlExtractableParameterInfo = (SqlExtractableParameterInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ParameterModel((SqlExtractableParameterInfo)p0));
        }
        listTableModel.addRows((Collection)((List)destination$iv$iv));
        this.updateSignature();
    }

    private final EditorEx setupHighlighting(EditorEx $this$setupHighlighting) {
        EditorEx editorEx;
        EditorEx $this$setupHighlighting_u24lambda_u240 = editorEx = $this$setupHighlighting;
        boolean bl = false;
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)((Language)this.originalInfo.getCodeInfo().getDialect()), (Project)$this$setupHighlighting_u24lambda_u240.getProject(), null);
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme editorColorsScheme2 = editorColorsScheme;
        $this$setupHighlighting_u24lambda_u240.setHighlighter(EditorHighlighterFactory.Companion.getInstance().createEditorHighlighter(syntaxHighlighter, editorColorsScheme2));
        return editorEx;
    }

    @NotNull
    protected JSplitPane createCenterPanel() {
        return this.centerPanel;
    }

    @NotNull
    public EditorTextField getPreferredFocusedComponent() {
        return this.functionNameField;
    }

    private final JComponent createTopPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JBLabel nameLabel = new JBLabel(SqlBundle.message((String)"SqlExtractFunctionDialog.label.name", (Object[])new Object[0]));
        panel.add((Component)nameLabel, "North");
        panel.add((Component)this.functionNameField, "South");
        nameLabel.setLabelFor((Component)this.functionNameField);
        this.functionNameField.selectAll();
        this.functionNameField.addDocumentListener(new DocumentListener(this){
            final /* synthetic */ SqlExtractFunctionDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                SqlExtractFunctionDialog.access$updateSignature(this.this$0);
            }
        });
        return panel;
    }

    private final JComponent createParametersTable() {
        JBListTable myParametersList = this.createParametersListTable();
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)myParametersList.getTable())).disableAddAction().disableRemoveAction().createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel decoratedParameters = jPanel;
        this.tableModel.addTableModelListener(arg_0 -> SqlExtractFunctionDialog.createParametersTable$lambda$0(this, arg_0));
        decoratedParameters.setPreferredSize(new Dimension(500, 200));
        decoratedParameters.setMinimumSize(new Dimension(-1, 20));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)SeparatorFactory.createSeparator((String)RefactoringBundle.message((String)"parameters.border.title"), null), "North");
        panel.add((Component)decoratedParameters, "Center");
        return panel;
    }

    private final JComponent createSignaturePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)SeparatorFactory.createSeparator((String)RefactoringBundle.message((String)"signature.preview.border.title"), (JComponent)((JComponent)((Object)this.signatureView))), "North");
        panel.add((Component)((Object)this.signatureView), "Center");
        this.signatureView.setPreferredSize(new Dimension(-1, 130));
        this.signatureView.setMinimumSize(new Dimension(-1, 20));
        return panel;
    }

    private final JBListTable createParametersListTable() {
        TableView tableView = new TableView(this.tableModel);
        Disposable disposable = this.getDisposable();
        return new JBListTable(this, (TableView<ParameterModel>)tableView, disposable){
            final /* synthetic */ SqlExtractFunctionDialog this$0;
            {
                this.this$0 = $receiver;
                super((JBTable)$super_call_param$1, $super_call_param$2);
            }

            protected JBTableRowRenderer getRowRenderer(int row) {
                return (arg_0, arg_1, arg_2, arg_3) -> createParametersListTable.1.getRowRenderer$lambda$0(this.this$0, row, this, arg_0, arg_1, arg_2, arg_3);
            }

            private final String render(ParameterModel $this$render, int spaceLength) {
                DdlBuilder ddlBuilder;
                DdlBuilder $this$render_u24lambda_u241 = ddlBuilder = SqlExtractableCodeInfoKt.createBuilder((SqlExtractFunctionInfo)SqlExtractFunctionDialog.access$getOriginalInfo$p(this.this$0));
                boolean bl = false;
                $this$render_u24lambda_u241.ref(ObjectKind.VARIABLE, null, $this$render.getName());
                $this$render_u24lambda_u241.space(spaceLength);
                $this$render_u24lambda_u241.type($this$render.getInfo().getDasType().toDataType());
                String string = ddlBuilder.getStatement();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
                return string;
            }

            static /* synthetic */ String render$default(createParametersListTable.1 var0, ParameterModel parameterModel, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = 1;
                }
                return var0.render(parameterModel, n);
            }

            private final int getMaxParamLength() {
                List list = SqlExtractFunctionDialog.access$getTableModel$p(this.this$0).getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
                Integer n = (Integer)SequencesKt.maxOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> createParametersListTable.1._get_maxParamLength_$lambda$2(this, arg_0)));
                return n != null ? n : 0;
            }

            private final String renderPadded(ParameterModel $this$renderPadded) {
                String s = createParametersListTable.1.render$default(this, $this$renderPadded, 0, 1, null);
                int diff = this.getMaxParamLength() - s.length();
                return diff > 0 ? this.render($this$renderPadded, diff + 1) : s;
            }

            private final createParametersListTable.createParameterView.1 createParameterView(ParameterModel param) {
                return new EditorTextField(this, param, this.this$0){
                    final /* synthetic */ SqlExtractFunctionDialog this$0;
                    {
                        this.this$0 = $receiver2;
                        this.setText(createParametersListTable.1.access$renderPadded($receiver, $param));
                        this.setFont(EditorFontType.getGlobalPlainFont());
                    }

                    protected Document createDocument() {
                        SqlCodeFragment sqlCodeFragment = SqlPsiElementFactory.createFragmentFromText((String)"", (SqlLanguageDialect)((SqlLanguageDialect)SqlExtractFunctionDialog.access$getOriginalInfo$p(this.this$0).getCodeInfo().getDialect()), (IElementType)((IElementType)SqlCompositeElementTypes.SQL_PARAMETER_DEFINITION), (Project)this.getProject(), null);
                        Intrinsics.checkNotNullExpressionValue((Object)sqlCodeFragment, (String)"createFragmentFromText(...)");
                        SqlCodeFragment codeFragment = sqlCodeFragment;
                        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument((PsiFile)codeFragment);
                    }

                    protected EditorEx createEditor() {
                        EditorEx editorEx = super.createEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
                        return SqlExtractFunctionDialog.access$setupHighlighting(this.this$0, editorEx);
                    }
                };
            }

            private final JCheckBox createAvailableCheckBox(ParameterModel param) {
                JCheckBox jCheckBox = new JCheckBox();
                SqlExtractFunctionDialog sqlExtractFunctionDialog = this.this$0;
                JCheckBox $this$createAvailableCheckBox_u24lambda_u243 = jCheckBox;
                boolean bl = false;
                $this$createAvailableCheckBox_u24lambda_u243.setSelected(param.isSelected());
                $this$createAvailableCheckBox_u24lambda_u243.addChangeListener(arg_0 -> createParametersListTable.1.createAvailableCheckBox$lambda$3$0(param, $this$createAvailableCheckBox_u24lambda_u243, sqlExtractFunctionDialog, arg_0));
                return jCheckBox;
            }

            protected createParametersListTable.getRowEditor.1 getRowEditor(int row) {
                return new JBTableRowEditor(this.this$0, row, this){
                    private EditorTextField nameEditor;
                    private EditorTextField internalNameEditor;
                    private final ParameterModel item;
                    final /* synthetic */ SqlExtractFunctionDialog this$0;
                    final /* synthetic */ createParametersListTable.1 this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.item = (ParameterModel)SqlExtractFunctionDialog.access$getTableModel$p($receiver).getItem($row);
                    }

                    public void prepareEditor(JTable t, int row) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        this.setLayout(new BorderLayout());
                        this.add(this.createEditorPanel(), "Center");
                        JPanel panel = new JPanel(new BorderLayout());
                        ParameterModel parameterModel = this.item;
                        Intrinsics.checkNotNullExpressionValue((Object)parameterModel, (String)"item");
                        panel.add((Component)createParametersListTable.1.access$createAvailableCheckBox(this.this$1, parameterModel), "Center");
                        this.add(panel, "West");
                    }

                    public JBTableRow getValue() {
                        return createParametersListTable.getRowEditor.1::getValue$lambda$0;
                    }

                    public JComponent getPreferredFocusedComponent() {
                        EditorTextField editorTextField = this.nameEditor;
                        if (editorTextField == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"nameEditor");
                            editorTextField = null;
                        }
                        JComponent jComponent = editorTextField.getFocusTarget();
                        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getFocusTarget(...)");
                        return jComponent;
                    }

                    public JComponent[] getFocusableComponents() {
                        Object[] objectArray = new JComponent[2];
                        EditorTextField editorTextField = this.nameEditor;
                        if (editorTextField == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"nameEditor");
                            editorTextField = null;
                        }
                        objectArray[0] = editorTextField.getFocusTarget();
                        EditorTextField editorTextField2 = this.internalNameEditor;
                        objectArray[1] = editorTextField2 != null ? editorTextField2.getFocusTarget() : null;
                        Collection $this$toTypedArray$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        return thisCollection$iv.toArray(new JComponent[0]);
                    }

                    private final JPanel createEditorPanel() {
                        JTextField jTextField;
                        JPanel editorPanel = new JPanel(new BorderLayout());
                        ParameterModel parameterModel = this.item;
                        Intrinsics.checkNotNullExpressionValue((Object)parameterModel, (String)"item");
                        this.nameEditor = this.createEditor((KMutableProperty0<String>)((KMutableProperty0)new MutablePropertyReference0Impl(parameterModel){

                            public Object get() {
                                return ((ParameterModel)this.receiver).getName();
                            }

                            public void set(Object value) {
                                ((ParameterModel)this.receiver).setName((String)value);
                            }
                        }));
                        String string = SqlBundle.message((String)"SqlExtractFunctionDialog.label.name", (Object[])new Object[0]);
                        EditorTextField editorTextField = this.nameEditor;
                        if (editorTextField == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"nameEditor");
                            editorTextField = null;
                        }
                        editorPanel.add((Component)JBTableRowEditor.createLabeledPanel((String)string, (JComponent)((JComponent)editorTextField)), "West");
                        String string2 = SqlExtractableCodeInfoKt.createBuilder((SqlExtractFunctionInfo)SqlExtractFunctionDialog.access$getOriginalInfo$p(this.this$0)).type(this.item.getInfo().getDasType().toDataType()).getStatement();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStatement(...)");
                        String typeText = string2;
                        JTextField $this$createEditorPanel_u24lambda_u241 = jTextField = new JTextField(typeText);
                        boolean bl = false;
                        $this$createEditorPanel_u24lambda_u241.setEditable(false);
                        $this$createEditorPanel_u24lambda_u241.setPreferredSize(new Dimension(150, $this$createEditorPanel_u24lambda_u241.getPreferredSize().height));
                        JTextField typeEditor = jTextField;
                        editorPanel.add((Component)JBTableRowEditor.createLabeledPanel((String)SqlBundle.message((String)"SqlExtractFunctionDialog.label.type", (Object[])new Object[0]), (JComponent)typeEditor), "East");
                        return editorPanel;
                    }

                    private final EditorTextField createEditor(KMutableProperty0<String> value) {
                        EditorTextField editorTextField = new EditorTextField((String)value.get());
                        SqlExtractFunctionDialog sqlExtractFunctionDialog = this.this$0;
                        EditorTextField $this$createEditor_u24lambda_u242 = editorTextField;
                        boolean bl = false;
                        $this$createEditor_u24lambda_u242.addDocumentListener(new DocumentListener(value, $this$createEditor_u24lambda_u242, sqlExtractFunctionDialog){
                            final /* synthetic */ KMutableProperty0<String> $value;
                            final /* synthetic */ EditorTextField $this_apply;
                            final /* synthetic */ SqlExtractFunctionDialog this$0;
                            {
                                this.$value = $value;
                                this.$this_apply = $receiver;
                                this.this$0 = $receiver2;
                            }

                            public void documentChanged(DocumentEvent event) {
                                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                                String string = this.$this_apply.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                this.$value.set((Object)string);
                                SqlExtractFunctionDialog.access$updateSignature(this.this$0);
                            }
                        });
                        return editorTextField;
                    }

                    private static final Object getValue$lambda$0(int it) {
                        return null;
                    }
                };
            }

            private static final JComponent getRowRenderer$lambda$0(SqlExtractFunctionDialog this$0, int $row, createParametersListTable.1 this$1, JTable jTable, int n, boolean selected, boolean focused) {
                JPanel jPanel;
                ParameterModel item = (ParameterModel)SqlExtractFunctionDialog.access$getTableModel$p(this$0).getItem($row);
                JPanel $this$getRowRenderer_u24lambda_u240_u240 = jPanel = new JPanel(new BorderLayout());
                boolean bl = false;
                Intrinsics.checkNotNull((Object)item);
                $this$getRowRenderer_u24lambda_u240_u240.add((Component)((Object)this$1.createParameterView(item)), "Center");
                $this$getRowRenderer_u24lambda_u240_u240.add((Component)this$1.createAvailableCheckBox(item), "West");
                $this$getRowRenderer_u24lambda_u240_u240.setBackground(selected && focused ? UIUtil.getTableSelectionBackground((boolean)true) : UIUtil.getTableBackground());
                return jPanel;
            }

            private static final int _get_maxParamLength_$lambda$2(createParametersListTable.1 this$0, ParameterModel it) {
                Intrinsics.checkNotNull((Object)it);
                return createParametersListTable.1.render$default(this$0, it, 0, 1, null).length();
            }

            private static final void createAvailableCheckBox$lambda$3$0(ParameterModel $param, JCheckBox $this_apply, SqlExtractFunctionDialog this$0, ChangeEvent it) {
                $param.setSelected($this_apply.isSelected());
                SqlExtractFunctionDialog.access$updateSignature(this$0);
            }

            public static final /* synthetic */ String access$renderPadded(createParametersListTable.1 $this, ParameterModel $receiver) {
                return $this.renderPadded($receiver);
            }

            public static final /* synthetic */ JCheckBox access$createAvailableCheckBox(createParametersListTable.1 $this, ParameterModel param) {
                return $this.createAvailableCheckBox(param);
            }
        };
    }

    private final void updateSignature() {
        SqlExtractFunctionInfo routineInfo = this.createFunctionInfo();
        this.signatureView.setText(this.helper.generateRoutine(routineInfo, true).getText());
        this.getOKAction().setEnabled(this.isOKActionEnabled());
    }

    public boolean isOKActionEnabled() {
        SqlExtractFunctionInfo routineInfo = this.createFunctionInfo();
        return ((CharSequence)routineInfo.getName()).length() > 0;
    }

    protected void doOKAction() {
        ConflictsDialog dialog;
        SqlExtractFunctionInfo functionInfo = this.createFunctionInfo();
        MultiMap conflicts = SqlExtractableCodeInfoKt.analyzeConflicts((SqlExtractFunctionInfo)functionInfo);
        if (!conflicts.isEmpty() && !(dialog = new ConflictsDialog(this.originalInfo.getCodeInfo().getProject(), conflicts, () -> SqlExtractFunctionDialog.doOKAction$lambda$0(this, functionInfo))).showAndGet()) {
            if (dialog.isShowConflicts()) {
                this.close(1);
            }
            return;
        }
        super.doOKAction();
        this.doRefactor.invoke((Object)functionInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final SqlExtractFunctionInfo createFunctionInfo() {
        Collection<SqlExtractableParameterInfo> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SqlExtractableCodeInfo sqlExtractableCodeInfo = this.originalInfo.getCodeInfo();
        String string = this.functionNameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        List list = this.tableModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Iterable iterable = list;
        String string2 = string;
        SqlExtractableCodeInfo sqlExtractableCodeInfo2 = sqlExtractableCodeInfo;
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParameterModel parameterModel = (ParameterModel)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.createInfo());
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        String string3 = string2;
        SqlExtractableCodeInfo sqlExtractableCodeInfo3 = sqlExtractableCodeInfo2;
        return new SqlExtractFunctionInfo(sqlExtractableCodeInfo3, string3, collection2);
    }

    private static final void createParametersTable$lambda$0(SqlExtractFunctionDialog this$0, TableModelEvent it) {
        this$0.updateSignature();
    }

    private static final void doOKAction$lambda$0(SqlExtractFunctionDialog this$0, SqlExtractFunctionInfo $functionInfo) {
        this$0.doRefactor.invoke((Object)$functionInfo);
    }

    public static final /* synthetic */ void access$updateSignature(SqlExtractFunctionDialog $this) {
        $this.updateSignature();
    }

    public static final /* synthetic */ SqlExtractFunctionInfo access$getOriginalInfo$p(SqlExtractFunctionDialog $this) {
        return $this.originalInfo;
    }

    public static final /* synthetic */ ListTableModel access$getTableModel$p(SqlExtractFunctionDialog $this) {
        return $this.tableModel;
    }

    public static final /* synthetic */ EditorEx access$setupHighlighting(SqlExtractFunctionDialog $this, EditorEx $receiver) {
        return $this.setupHighlighting($receiver);
    }

    public static final /* synthetic */ JComponent access$createTopPanel(SqlExtractFunctionDialog $this) {
        return $this.createTopPanel();
    }

    public static final /* synthetic */ JComponent access$createParametersTable(SqlExtractFunctionDialog $this) {
        return $this.createParametersTable();
    }

    public static final /* synthetic */ JComponent access$createSignaturePanel(SqlExtractFunctionDialog $this) {
        return $this.createSignaturePanel();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0013\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionDialog$ParameterModel;", "", "info", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableParameterInfo;", "<init>", "(Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableParameterInfo;)V", "getInfo", "()Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableParameterInfo;", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "isSelected", "", "()Z", "setSelected", "(Z)V", "createInfo", "intellij.database.sql.impl"})
    public static final class ParameterModel {
        @NotNull
        private final SqlExtractableParameterInfo info;
        @NotNull
        private String name;
        private boolean isSelected;

        public ParameterModel(@NotNull SqlExtractableParameterInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            this.info = info;
            this.name = this.info.getName();
            this.isSelected = true;
        }

        @NotNull
        public final SqlExtractableParameterInfo getInfo() {
            return this.info;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        public final boolean isSelected() {
            return this.isSelected;
        }

        public final void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        @NotNull
        public final SqlExtractableParameterInfo createInfo() {
            return SqlExtractableCodeInfoKt.copy((SqlExtractableParameterInfo)this.info, (String)this.name);
        }
    }
}

