/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.suppression;

import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.inspections.suppression.SqlSuppressInspectionFix;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStatementSuppressInspectionFix
extends SqlSuppressInspectionFix {
    public SqlStatementSuppressInspectionFix(@NotNull String toolId, @Nullable ObjectPath path) {
        if (toolId == null) {
            SqlStatementSuppressInspectionFix.$$$reportNull$$$0(0);
        }
        super(toolId, SqlStatement.class, path);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            SqlStatementSuppressInspectionFix.$$$reportNull$$$0(1);
        }
        return currentFile;
    }

    @Override
    @NotNull
    public String getText() {
        String string = SqlBundle.message((String)"intention.name.for.statement", (Object[])new Object[]{super.getText()});
        if (string == null) {
            SqlStatementSuppressInspectionFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void createSuppression(final @NotNull Project project, final @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
        if (project == null) {
            SqlStatementSuppressInspectionFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            SqlStatementSuppressInspectionFix.$$$reportNull$$$0(4);
        }
        if (container == null) {
            SqlStatementSuppressInspectionFix.$$$reportNull$$$0(5);
        }
        JBIterable containers = SqlImplUtil.sqlParents((PsiElement)container).filter(SqlStatement.class);
        Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(container.getContainingFile());
        Stream editors = doc != null ? EditorFactory.getInstance().editors(doc) : Stream.empty();
        Editor editor = editors.findFirst().orElse(null);
        if (containers.size() <= 1 || editor == null) {
            this.addSuppression(project, element, container);
            return;
        }
        IntroduceTargetChooser.showChooser((Editor)editor, (List)containers.toList(), (Pass)new Pass<PsiElement>(){

            public void pass(PsiElement statement) {
                SqlStatementSuppressInspectionFix.this.addSuppression(project, element, statement);
            }
        }, expression -> StringUtil.first((String)expression.getText().replaceAll("\\s+", " "), (int)50, (boolean)true), (String)SqlBundle.message((String)"popup.title.statements", (Object[])new Object[0]), (int)0, (NotNullFunction)ScopeHighlighter.NATURAL_RANGER);
    }

    private void addSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) {
        if (project == null) {
            SqlStatementSuppressInspectionFix.$$$reportNull$$$0(6);
        }
        if (element == null) {
            SqlStatementSuppressInspectionFix.$$$reportNull$$$0(7);
        }
        if (container == null) {
            SqlStatementSuppressInspectionFix.$$$reportNull$$$0(8);
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getText(), null, () -> {
            PsiParserFacade parserFacade = PsiParserFacade.getInstance((Project)project);
            String text = this.getSuppressionText(this.myID);
            PsiComment comment = parserFacade.createLineOrBlockCommentFromText(element.getContainingFile().getLanguage(), text);
            container.getParent().addBefore((PsiElement)comment, container);
        }, (PsiFile[])new PsiFile[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/suppression/SqlStatementSuppressInspectionFix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/suppression/SqlStatementSuppressInspectionFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSuppression";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addSuppression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

