/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.comment;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.comment.JSChangeToDocCommentIntention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSChangeToEndOfLineCommentIntention
extends JSIntention {
    @IntentionName
    @NotNull
    public String getText() {
        String string = JSIntentionBundle.message("comment.change-to-end-of-line-comment.display-name", new Object[0]);
        if (string == null) {
            JSChangeToEndOfLineCommentIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("comment.change-to-end-of-line-comment.family-name", new Object[0]);
        if (string == null) {
            JSChangeToEndOfLineCommentIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        return new CStyleCommentPredicate();
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSChangeToEndOfLineCommentIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSChangeToEndOfLineCommentIntention.$$$reportNull$$$0(3);
        }
        PsiElement parent = element.getParent();
        assert (parent != null);
        String commentText = element.getText();
        String text = commentText.substring(2, commentText.length() - 2);
        String[] lines = text.split("\n");
        PsiElement prevSibling = element.getPrevSibling();
        String indent = JSChangeToDocCommentIntention.getIndentFromWhiteSpace(prevSibling);
        List<String> newComments = JSChangeToEndOfLineCommentIntention.buildCommentStrings(lines, indent);
        PsiElement elementParent = element.getParent();
        if (newComments.size() == 1) {
            element.replace((PsiElement)JSPsiElementFactory.createPsiComment((String)newComments.get(0), (PsiElement)element));
            return;
        }
        for (int i = 0; i < newComments.size(); ++i) {
            String comment = newComments.get(i);
            PsiElement newElement = elementParent.addBefore((PsiElement)JSPsiElementFactory.createPsiComment((String)comment, (PsiElement)element), element);
            if (i == 0) continue;
            PsiElement sibling = newElement.getPrevSibling();
            if (sibling instanceof PsiWhiteSpace) {
                sibling.replace(JSChangeUtil.createTokenElement((PsiElement)element, (IElementType)TokenType.WHITE_SPACE, (CharSequence)("\n" + indent)));
                continue;
            }
            elementParent.addBefore(JSChangeUtil.createTokenElement((PsiElement)element, (IElementType)TokenType.WHITE_SPACE, (CharSequence)indent), newElement);
        }
        JSRefactoringUtil.removeElementWithLinebreak((PsiElement)element);
    }

    @NotNull
    private static List<String> buildCommentStrings(String @NotNull [] lines, @NotNull String indent) {
        if (indent == null) {
            JSChangeToEndOfLineCommentIntention.$$$reportNull$$$0(4);
        }
        if (lines == null) {
            JSChangeToEndOfLineCommentIntention.$$$reportNull$$$0(5);
        }
        ArrayList<String> commentStrings = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String trim = line.trim();
            if (!trim.isEmpty()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("//");
                String lineText = JSChangeToEndOfLineCommentIntention.processLineText(line, indent);
                buffer.append(lineText);
                commentStrings.add(buffer.toString());
                continue;
            }
            if (i == 0 || i == lines.length - 1) continue;
            commentStrings.add("//");
        }
        ArrayList<String> arrayList = commentStrings;
        if (arrayList == null) {
            JSChangeToEndOfLineCommentIntention.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static String processLineText(@NotNull String line, @NotNull String indent) {
        String lineText;
        if (line == null) {
            JSChangeToEndOfLineCommentIntention.$$$reportNull$$$0(7);
        }
        if (indent == null) {
            JSChangeToEndOfLineCommentIntention.$$$reportNull$$$0(8);
        }
        String string = lineText = line.startsWith(indent) ? line.substring(indent.length()) : line;
        if (line.startsWith(" *")) {
            lineText = line.substring(2);
        } else if (line.startsWith("*")) {
            lineText = line.substring(1);
        }
        String string2 = StringUtil.trimTrailing((String)lineText);
        if (string2 == null) {
            JSChangeToEndOfLineCommentIntention.$$$reportNull$$$0(9);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/comment/JSChangeToEndOfLineCommentIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/comment/JSChangeToEndOfLineCommentIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommentStrings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "processLineText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildCommentStrings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processLineText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    private static class CStyleCommentPredicate
    implements JSElementPredicate {
        private CStyleCommentPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                CStyleCommentPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof PsiComment)) {
                return false;
            }
            PsiComment comment = (PsiComment)element;
            IElementType type = comment.getTokenType();
            if (!JSTokenTypes.C_STYLE_COMMENT.equals(type)) {
                return false;
            }
            PsiElement sibling = PsiTreeUtil.nextLeaf((PsiElement)comment);
            if (!(sibling instanceof PsiWhiteSpace)) {
                return false;
            }
            String whitespaceText = sibling.getText();
            return whitespaceText.indexOf(10) >= 0 || whitespaceText.indexOf(13) >= 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/comment/JSChangeToEndOfLineCommentIntention$CStyleCommentPredicate", "satisfiedBy"));
        }
    }
}

