---
c: Copyright (C) Daniel Stenberg, <daniel@haxx.se>, et al.
SPDX-License-Identifier: curl
Title: CURLINFO_PRIVATE
Section: 3
Source: libcurl
See-also:
  - CURLOPT_PRIVATE (3)
  - curl_easy_getinfo (3)
  - curl_easy_setopt (3)
Protocol:
  - All
Added-in: 7.10.3
---

# NAME

CURLINFO_PRIVATE - private pointer

# SYNOPSIS

~~~c
#include <curl/curl.h>

CURLcode curl_easy_getinfo(CURL *handle, CURLINFO_PRIVATE, char **private);
~~~

# DESCRIPTION

Pass a pointer to a char pointer to receive the pointer to the private data
associated with the curl handle (set with the CURLOPT_PRIVATE(3)).
Please note that for internal reasons, the value is returned as a char
pointer, although effectively being a 'void *'.

# %PROTOCOLS%

# EXAMPLE

~~~c
int main(void)
{
  CURL *curl = curl_easy_init();
  if(curl) {
    CURLcode result;
    void *pointer = (void *)0x2345454;
    curl_easy_setopt(curl, CURLOPT_URL, "https://example.com/foo.bin");

    /* set the private pointer */
    curl_easy_setopt(curl, CURLOPT_PRIVATE, pointer);
    result = curl_easy_perform(curl);

    /* extract the private pointer again */
    result = curl_easy_getinfo(curl, CURLINFO_PRIVATE, &pointer);

    if(result)
      printf("error: %s\n", curl_easy_strerror(result));

    curl_easy_cleanup(curl);
  }
}
~~~

# %AVAILABILITY%

# RETURN VALUE

curl_easy_getinfo(3) returns a CURLcode indicating success or error.

CURLE_OK (0) means everything was OK, non-zero means an error occurred, see
libcurl-errors(3).
