/*  This file is part of FreeDoko.
    FreeDoko is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version (see <http://www.gnu.org/licenses/>).

    Diese Datei ist Teil von FreeDoko.
    FreeDoko ist Freie Software: Sie können es unter den Bedingungen der GNU General Public License, wie von der Free Software Foundation, Version 3 der Lizenz oder (nach Ihrer Wahl) jeder neueren veröffentlichten Version, weiter verteilen und/oder modifizieren (siehe <https://www.gnu.org/licenses/>).
    */

#include "pfund_for_sure.h"

#include "../../ai.h"

#include "../../../../card/trick.h"

namespace Heuristics {

auto PfundForSure::is_valid(GameTypeGroup const game_type,
                            PlayerTypeGroup const player_group) -> bool
{
  return is_with_partner(game_type, player_group);
}


PfundForSure::PfundForSure(Ai const& ai) :
  Pfund(ai, Aiconfig::Heuristic::pfund_for_sure)
{ }


PfundForSure::~PfundForSure() = default;


auto PfundForSure::conditions_met(Trick const& trick) -> bool
{
  return (   !condition_startcard(trick)
          && condition_winnerplayer_surely_same_team(trick)
          && !condition_opposite_or_unknown_team_can_jab(trick));
}


auto PfundForSure::card_to_play(Trick const& trick) -> Card
{
  {
    auto const pfund = high_pfund(trick);
    if (pfund) {
      rationale_.add(_("Heuristic::return::high pfund: %s", _(pfund)));
      return pfund;
    }
  }
  {
    auto const pfund = small_pfund(trick);
    if (!pfund) {
      rationale_.add(_("Heuristic::reject::no pfund found"));
      return {};
    }
    rationale_.add(_("Heuristic::return::small pfund: %s", _(pfund)));
    return pfund;
  }
}

} // namespace Heuristics
