/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.EOFException;
import java.io.IOError;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.function.IntSupplier;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Terminal;
import org.jline.utils.InfoCmp;
import org.jline.utils.InputStreamReader;

public class MouseSupport {
    public static boolean hasMouseSupport(Terminal terminal2) {
        return terminal2.getStringCapability(InfoCmp.Capability.key_mouse) != null;
    }

    public static boolean trackMouse(Terminal terminal2, Terminal.MouseTracking tracking) {
        if (MouseSupport.hasMouseSupport(terminal2)) {
            switch (tracking) {
                case Off: {
                    terminal2.writer().write("\u001b[?1000l");
                    break;
                }
                case Normal: {
                    terminal2.writer().write("\u001b[?1005h\u001b[?1000h");
                    break;
                }
                case Button: {
                    terminal2.writer().write("\u001b[?1005h\u001b[?1002h");
                    break;
                }
                case Any: {
                    terminal2.writer().write("\u001b[?1005h\u001b[?1003h");
                }
            }
            terminal2.flush();
            return true;
        }
        return false;
    }

    public static MouseEvent readMouse(Terminal terminal2, MouseEvent last) {
        return MouseSupport.readMouse(() -> MouseSupport.readExt(terminal2), last);
    }

    public static MouseEvent readMouse(IntSupplier reader, MouseEvent last) {
        MouseEvent.Button button;
        MouseEvent.Type type;
        int cb = reader.getAsInt() - 32;
        int cx = reader.getAsInt() - 32 - 1;
        int cy = reader.getAsInt() - 32 - 1;
        EnumSet<MouseEvent.Modifier> modifiers = EnumSet.noneOf(MouseEvent.Modifier.class);
        if ((cb & 4) == 4) {
            modifiers.add(MouseEvent.Modifier.Shift);
        }
        if ((cb & 8) == 8) {
            modifiers.add(MouseEvent.Modifier.Alt);
        }
        if ((cb & 0x10) == 16) {
            modifiers.add(MouseEvent.Modifier.Control);
        }
        if ((cb & 0x40) == 64) {
            type = MouseEvent.Type.Wheel;
            button = (cb & 1) == 1 ? MouseEvent.Button.WheelDown : MouseEvent.Button.WheelUp;
        } else {
            int b = cb & 3;
            switch (b) {
                case 0: {
                    button = MouseEvent.Button.Button1;
                    if (last.getButton() == button && (last.getType() == MouseEvent.Type.Pressed || last.getType() == MouseEvent.Type.Dragged)) {
                        type = MouseEvent.Type.Dragged;
                        break;
                    }
                    type = MouseEvent.Type.Pressed;
                    break;
                }
                case 1: {
                    button = MouseEvent.Button.Button2;
                    if (last.getButton() == button && (last.getType() == MouseEvent.Type.Pressed || last.getType() == MouseEvent.Type.Dragged)) {
                        type = MouseEvent.Type.Dragged;
                        break;
                    }
                    type = MouseEvent.Type.Pressed;
                    break;
                }
                case 2: {
                    button = MouseEvent.Button.Button3;
                    if (last.getButton() == button && (last.getType() == MouseEvent.Type.Pressed || last.getType() == MouseEvent.Type.Dragged)) {
                        type = MouseEvent.Type.Dragged;
                        break;
                    }
                    type = MouseEvent.Type.Pressed;
                    break;
                }
                default: {
                    if (last.getType() == MouseEvent.Type.Pressed || last.getType() == MouseEvent.Type.Dragged) {
                        button = last.getButton();
                        type = MouseEvent.Type.Released;
                        break;
                    }
                    button = MouseEvent.Button.NoButton;
                    type = MouseEvent.Type.Moved;
                }
            }
        }
        return new MouseEvent(type, button, modifiers, cx, cy);
    }

    private static int readExt(Terminal terminal2) {
        try {
            int c = terminal2.encoding() != StandardCharsets.UTF_8 ? new InputStreamReader(terminal2.input(), StandardCharsets.UTF_8).read() : terminal2.reader().read();
            if (c < 0) {
                throw new EOFException();
            }
            return c;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

