/*
 * Decompiled with CFR 0.152.
 */
package mill.main.server;

import geny.Writable;
import geny.Writable$;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import mill.api.SystemStreams;
import mill.main.client.BuildInfo;
import mill.main.client.InputPumper;
import mill.main.client.ProxyStream;
import mill.main.client.Util;
import mill.main.client.lock.Lock;
import mill.main.client.lock.Locks;
import mill.main.server.Server$;
import mill.moduledefs.Scaladoc;
import os.Path;
import os.PathChunk;
import os.PermSet;
import os.RelPath$;
import os.Source;
import os.Source$;
import os.exists$;
import os.read$;
import os.read$inputStream$;
import os.write$;
import os.write$append$;
import os.write$over$;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.VolatileBooleanRef;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Random$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import upickle.default$;

@Scaladoc(value="/**\n * Models a long-lived server that receives requests from a client and calls a [[main0]]\n * method to run the commands in-process. Provides the command args, env variables,\n * JVM properties, wrapped input/output streams, and other metadata related to the\n * client command\n */")
@ScalaSignature(bytes="\u0006\u0005\t}a!B\u0010!\u0003\u00039\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u0011Y\u0002!\u0011!Q\u0001\n]B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\")q\t\u0001C\u0001\u0011\"9!\f\u0001a\u0001\n\u0003Y\u0006b\u0002/\u0001\u0001\u0004%\t!\u0018\u0005\u0007G\u0002\u0001\u000b\u0015\u0002#\t\u000b!\u0004A\u0011A5\t\u000f)\u0004\u0001\u0019!C\u0001W\"9A\u000e\u0001a\u0001\n\u0003i\u0007BB8\u0001A\u0003&1\nC\u0003q\u0001\u0019\u00051\u000eC\u0004r\u0001\t\u0007I\u0011\u0001:\t\ry\u0004\u0001\u0015!\u0003t\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001BBA\u0007\u0001\u0011\u0005\u0011\u000eC\u0004\u0002\u0010\u0001!\t!!\u0005\t\r\u00055\u0002\u0001\"\u0001j\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!!\u000f\u0001\t\u0003\tY\u0004C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005M\u0004A\"\u0001\u0002v\u001d9\u00111\u001a\u0011\t\u0002\u00055gAB\u0010!\u0011\u0003\ty\r\u0003\u0004H5\u0011\u0005\u0011\u0011\u001b\u0005\b\u0003'TB\u0011AAk\u0011\u001d\tyO\u0007C\u0001\u0003cD\u0011Ba\u0001\u001b#\u0003%\tA!\u0002\u0003\rM+'O^3s\u0015\t\t#%\u0001\u0004tKJ4XM\u001d\u0006\u0003G\u0011\nA!\\1j]*\tQ%\u0001\u0003nS2d7\u0001A\u000b\u0003Q5\u001b\"\u0001A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g\u0003%\u0019XM\u001d<fe\u0012K'\u000f\u0005\u00022i5\t!GC\u00014\u0003\ty7/\u0003\u00026e\t!\u0001+\u0019;i\u0003M\t7mY3qiRKW.Z8vi6KG\u000e\\5t!\tQ\u0003(\u0003\u0002:W\t\u0019\u0011J\u001c;\u0002\u000b1|7m[:\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014\u0001\u00027pG.T!\u0001\u0011\u0012\u0002\r\rd\u0017.\u001a8u\u0013\t\u0011UHA\u0003M_\u000e\\7/\u0001\u000fuKN$Hj\\4Fm\u0016tw\u000b[3o'\u0016\u0014h/\u001a:JI^\u0013xN\\4\u0011\u0005)*\u0015B\u0001$,\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD#B%W/bK\u0006c\u0001&\u0001\u00176\t\u0001\u0005\u0005\u0002M\u001b2\u0001A!\u0002(\u0001\u0005\u0004y%!\u0001+\u0012\u0005A\u001b\u0006C\u0001\u0016R\u0013\t\u00116FA\u0004O_RD\u0017N\\4\u0011\u0005)\"\u0016BA+,\u0005\r\te.\u001f\u0005\u0006_\u0015\u0001\r\u0001\r\u0005\u0006m\u0015\u0001\ra\u000e\u0005\u0006u\u0015\u0001\ra\u000f\u0005\b\u0007\u0016\u0001\n\u00111\u0001E\u0003\u001d\u0011XO\u001c8j]\u001e,\u0012\u0001R\u0001\feVtg.\u001b8h?\u0012*\u0017\u000f\u0006\u0002_CB\u0011!fX\u0005\u0003A.\u0012A!\u00168ji\"9!mBA\u0001\u0002\u0004!\u0015a\u0001=%c\u0005A!/\u001e8oS:<\u0007\u0005\u000b\u0002\tKB\u0011!FZ\u0005\u0003O.\u0012\u0001B^8mCRLG.Z\u0001\u000bKbLGoU3sm\u0016\u0014H#\u00010\u0002\u0015M$\u0018\r^3DC\u000eDW-F\u0001L\u00039\u0019H/\u0019;f\u0007\u0006\u001c\u0007.Z0%KF$\"A\u00188\t\u000f\t\\\u0011\u0011!a\u0001\u0017\u0006Y1\u000f^1uK\u000e\u000b7\r[3!\u0003-\u0019H/\u0019;f\u0007\u0006\u001c\u0007.\u001a\u0019\u0002\u0011M,'O^3s\u0013\u0012,\u0012a\u001d\t\u0003int!!^=\u0011\u0005Y\\S\"A<\u000b\u0005a4\u0013A\u0002\u001fs_>$h(\u0003\u0002{W\u00051\u0001K]3eK\u001aL!\u0001`?\u0003\rM#(/\u001b8h\u0015\tQ8&A\u0005tKJ4XM]%eA\u0005Q1/\u001a:wKJdun\u001a\u0019\u0015\u0007y\u000b\u0019\u0001\u0003\u0004\u0002\u0006A\u0001\ra]\u0001\u0002g\u0006I1/\u001a:wKJdun\u001a\u000b\u0004=\u0006-\u0001BBA\u0003#\u0001\u00071/A\u0002sk:\fQ\u0004\u001d:pqfLe\u000e];u'R\u0014X-Y7UQJ|Wo\u001a5Qk6\u0004XM\u001d\u000b\u0005\u0003'\t\u0019\u0003\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\u0005%|'BAA\u000f\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0012q\u0003\u0002\u0011!&\u0004X\rZ%oaV$8\u000b\u001e:fC6Dq!!\n\u0014\u0001\u0004\t9#\u0001\u0002j]B!\u0011QCA\u0015\u0013\u0011\tY#a\u0006\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0012o\u0006$8\r[*feZ,'/\u00133GS2,\u0017!E2iK\u000e\\7+\u001a:wKJLEMR5mKR\u0011\u00111\u0007\t\u0005U\u0005U2/C\u0002\u00028-\u0012aa\u00149uS>t\u0017\u0001F5oi\u0016\u0014(/\u001e9u/&$\b\u000eV5nK>,H/\u0006\u0003\u0002>\u0005\rCCBA \u0003\u000b\ny\u0005E\u0003+\u0003k\t\t\u0005E\u0002M\u0003\u0007\"QA\u0014\fC\u0002=Cq!a\u0012\u0017\u0001\u0004\tI%A\u0003dY>\u001cX\r\u0005\u0003+\u0003\u0017r\u0016bAA'W\tIa)\u001e8di&|g\u000e\r\u0005\b\u0003#2\u0002\u0019AA*\u0003\u0005!\b#\u0002\u0016\u0002L\u0005\u0005\u0013!\u00035b]\u0012dWMU;o)\u0015q\u0016\u0011LA5\u0011\u001d\tYf\u0006a\u0001\u0003;\nAb\u00197jK:$8k\\2lKR\u0004B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0005\u0003G\nY\"A\u0002oKRLA!a\u001a\u0002b\t11k\\2lKRDq!a\u001b\u0018\u0001\u0004\ti'A\fj]&$\u0018.\u00197TsN$X-\u001c)s_B,'\u000f^5fgB)A/a\u001ctg&\u0019\u0011\u0011O?\u0003\u00075\u000b\u0007/A\u0003nC&t\u0007\u0007\u0006\u000b\u0002x\u0005u\u0014qQAE\u0003\u001b\u000bi*!)\u0002,\u0006=\u0016\u0011\u0017\t\u0006U\u0005eDiS\u0005\u0004\u0003wZ#A\u0002+va2,'\u0007C\u0004\u0002\u0000a\u0001\r!!!\u0002\t\u0005\u0014xm\u001d\t\u0005U\u0005\r5/C\u0002\u0002\u0006.\u0012Q!\u0011:sCfDQA\u001b\rA\u0002-Ca!a#\u0019\u0001\u0004!\u0015aD7bS:Le\u000e^3sC\u000e$\u0018N^3\t\u000f\u0005=\u0005\u00041\u0001\u0002\u0012\u000691\u000f\u001e:fC6\u001c\b\u0003BAJ\u00033k!!!&\u000b\u0007\u0005]E%A\u0002ba&LA!a'\u0002\u0016\ni1+_:uK6\u001cFO]3b[NDq!a(\u0019\u0001\u0004\ti'A\u0002f]ZDq!a)\u0019\u0001\u0004\t)+A\u0004tKRLE\r\\3\u0011\u000b)\n9\u000b\u00120\n\u0007\u0005%6FA\u0005Gk:\u001cG/[8oc!9\u0011Q\u0016\rA\u0002\u00055\u0014aF;tKJ\u001c\u0006/Z2jM&,G\r\u0015:pa\u0016\u0014H/[3t\u0011\u001d\tY\u0007\u0007a\u0001\u0003[Bq!a-\u0019\u0001\u0004\t),\u0001\u0006tsN$X-\\#ySR\u0004RAKAToACs\u0001AA]\u0003\u000b\f9\r\u0005\u0003\u0002<\u0006\u0005WBAA_\u0015\r\ty\fJ\u0001\u000b[>$W\u000f\\3eK\u001a\u001c\u0018\u0002BAb\u0003{\u0013\u0001bU2bY\u0006$wnY\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u0013\f!1G\u0018+U)\u0001#\u0006I'pI\u0016d7\u000fI1!Y>tw-\f7jm\u0016$\u0007e]3sm\u0016\u0014\b\u0005\u001e5bi\u0002\u0012XmY3jm\u0016\u001c\bE]3rk\u0016\u001cHo\u001d\u0011ge>l\u0007%\u0019\u0011dY&,g\u000e\u001e\u0011b]\u0012\u00043-\u00197mg\u0002\n\u0007eW.nC&t\u0007'X/\u000bA)\u0002S.\u001a;i_\u0012\u0004Co\u001c\u0011sk:\u0004C\u000f[3!G>lW.\u00198eg\u0002Jg.\f9s_\u000e,7o\u001d\u0018!!J|g/\u001b3fg\u0002\"\b.\u001a\u0011d_6l\u0017M\u001c3!CJ<7\u000f\f\u0011f]Z\u0004c/\u0019:jC\ndWm\u001d\u0017\u000bA)\u0002#JV'!aJ|\u0007/\u001a:uS\u0016\u001cH\u0006I<sCB\u0004X\r\u001a\u0011j]B,HoL8viB,H\u000fI:ue\u0016\fWn\u001d\u0017!C:$\u0007e\u001c;iKJ\u0004S.\u001a;bI\u0006$\u0018\r\t:fY\u0006$X\r\u001a\u0011u_\u0002\"\b.\u001a\u0006!U\u0001\u001aG.[3oi\u0002\u001aw.\\7b]\u0012T\u0001EK\u0018\u0002\rM+'O^3s!\tQ%d\u0005\u0002\u001bSQ\u0011\u0011QZ\u0001\nY>\u001c7N\u00117pG.,B!a6\u0002^R!\u0011\u0011\\At)\u0011\tY.a8\u0011\u00071\u000bi\u000eB\u0003O9\t\u0007q\n\u0003\u0005\u0002Rq!\t\u0019AAq!\u0015Q\u00131]An\u0013\r\t)o\u000b\u0002\ty\tLh.Y7f}!1a\b\ba\u0001\u0003S\u00042\u0001PAv\u0013\r\ti/\u0010\u0002\u0005\u0019>\u001c7.\u0001\u0007uefdunY6CY>\u001c7.\u0006\u0003\u0002t\u0006mH\u0003BA{\u0005\u0003!B!a>\u0002~B)!&!\u000e\u0002zB\u0019A*a?\u0005\u000b9k\"\u0019A(\t\u0011\u0005ES\u0004\"a\u0001\u0003\u007f\u0004RAKAr\u0003sDaAP\u000fA\u0002\u0005%\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0003\u0003\b\tuQC\u0001B\u0005U\r!%1B\u0016\u0003\u0005\u001b\u0001BAa\u0004\u0003\u001a5\u0011!\u0011\u0003\u0006\u0005\u0005'\u0011)\"A\u0005v]\u000eDWmY6fI*\u0019!qC\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u001c\tE!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)aJ\bb\u0001\u001f\u0002")
public abstract class Server<T> {
    private final Path serverDir;
    private final int acceptTimeoutMillis;
    private final Locks locks;
    private final boolean testLogEvenWhenServerIdWrong;
    private volatile boolean running;
    private T stateCache;
    private final String serverId;

    public static <T> boolean $lessinit$greater$default$4() {
        return Server$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T> Option<T> tryLockBlock(Lock lock, Function0<T> t) {
        return Server$.MODULE$.tryLockBlock(lock, t);
    }

    public static <T> T lockBlock(Lock lock, Function0<T> t) {
        return Server$.MODULE$.lockBlock(lock, t);
    }

    public boolean running() {
        return this.running;
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    public void exitServer() {
        this.running_$eq(false);
    }

    public T stateCache() {
        return this.stateCache;
    }

    public void stateCache_$eq(T x$1) {
        this.stateCache = x$1;
    }

    public abstract T stateCache0();

    public String serverId() {
        return this.serverId;
    }

    public void serverLog0(String s2) {
        if (exists$.MODULE$.apply(this.serverDir) || this.testLogEvenWhenServerIdWrong) {
            Path x$1 = this.serverDir.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"server.log"}))));
            Source.WritableSource<String> x$2 = Source$.MODULE$.WritableSource(new StringBuilder(1).append(s2).append("\n").toString(), (Function1<String, Writable.StringWritable> & Serializable)s -> Writable$.MODULE$.StringWritable((String)s));
            boolean x$3 = true;
            PermSet x$4 = write$append$.MODULE$.apply$default$3();
            write$append$.MODULE$.apply(x$1, x$2, x$4, true);
            return;
        }
    }

    public void serverLog(String s) {
        this.serverLog0(new StringBuilder(1).append(this.serverId()).append(" ").append(s).toString());
    }

    public void run() {
        this.serverLog(new StringBuilder(18).append("running server in ").append(this.serverDir).toString());
        scala.collection.immutable.Map initialSystemProperties = package$.MODULE$.props().toMap($less$colon$less$.MODULE$.refl());
        try {
            try {
                Server$.MODULE$.tryLockBlock(this.locks.processLock, () -> {
                    this.serverLog("server file locked");
                    this.watchServerIdFile();
                    ServerSocket serverSocket = new ServerSocket(0, 0, InetAddress.getByName(null));
                    write$over$.MODULE$.apply($this.serverDir.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"socketPort"})))), Source$.MODULE$.WritableSource(Integer.toString(serverSocket.getLocalPort()), (Function1<String, Writable.StringWritable> & Serializable)s -> Writable$.MODULE$.StringWritable((String)s)), write$over$.MODULE$.apply$default$3(), write$over$.MODULE$.apply$default$4(), write$over$.MODULE$.apply$default$5(), write$over$.MODULE$.apply$default$6());
                    this.serverLog(new StringBuilder(18).append("listening on port ").append(serverSocket.getLocalPort()).toString());
                    while (this.running()) {
                        boolean bl;
                        Option option = this.interruptWithTimeout(() -> serverSocket.close(), (Function0<Socket> & Serializable)() -> serverSocket.accept());
                        if (None$.MODULE$.equals(option)) {
                            bl = false;
                        } else if (option instanceof Some) {
                            Some some = (Some)option;
                            this.serverLog("handling run");
                            try (Socket sock = (Socket)some.value();){
                                try {
                                    this.handleRun(sock, initialSystemProperties);
                                }
                                catch (Throwable e) {
                                    this.serverLog(new StringBuilder(1).append(e.toString()).append("\n").append(Predef$.MODULE$.wrapRefArray((Object[])e.getStackTrace()).mkString("\n")).toString());
                                }
                            }
                            bl = true;
                        } else {
                            throw new MatchError(option);
                        }
                        if (bl) continue;
                    }
                    this.serverLog("server loop ended");
                }).getOrElse((Function0<Nothing$> & Serializable)() -> {
                    throw new Exception("Mill server process already present");
                });
            }
            catch (Throwable e) {
                this.serverLog(new StringBuilder(19).append("server loop error: ").append(e).toString());
                this.serverLog(new StringBuilder(25).append("server loop stack trace: ").append(Predef$.MODULE$.wrapRefArray((Object[])e.getStackTrace()).mkString("\n")).toString());
                throw e;
            }
        }
        finally {
            this.serverLog("finally exitServer");
            this.exitServer();
        }
    }

    public PipedInputStream proxyInputStreamThroughPumper(InputStream in) {
        PipedInputStream pipedInput = new PipedInputStream();
        PipedOutputStream pipedOutput = new PipedOutputStream();
        pipedOutput.connect(pipedInput);
        InputPumper pumper = new InputPumper(() -> in, () -> pipedOutput, Predef$.MODULE$.boolean2Boolean(false));
        Thread pumperThread = new Thread((Runnable)pumper, "proxyInputStreamThroughPumper");
        pumperThread.setDaemon(true);
        pumperThread.start();
        return pipedInput;
    }

    public void watchServerIdFile() {
        write$over$.MODULE$.apply(this.serverDir.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"serverId"})))), Source$.MODULE$.WritableSource(this.serverId(), (Function1<String, Writable.StringWritable> & Serializable)s -> Writable$.MODULE$.StringWritable((String)s)), write$over$.MODULE$.apply$default$3(), write$over$.MODULE$.apply$default$4(), write$over$.MODULE$.apply$default$5(), write$over$.MODULE$.apply$default$6());
        Thread serverIdThread = new Thread(() -> {
            while (this.running()) {
                Option<String> option = this.checkServerIdFile();
                if (None$.MODULE$.equals(option)) {
                    Thread.sleep(100L);
                    continue;
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String msg = (String)some.value();
                    this.serverLog(msg);
                    this.exitServer();
                    continue;
                }
                throw new MatchError(option);
            }
        }, new StringBuilder(26).append("Server ID Checker Thread: ").append(this.serverDir).toString());
        serverIdThread.start();
    }

    public Option<String> checkServerIdFile() {
        Try try_ = Try$.MODULE$.apply((Function0<String> & Serializable)() -> read$.MODULE$.apply($this.serverDir.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"serverId"}))))));
        if (try_ instanceof Failure) {
            return new Some<String>("serverId file missing");
        }
        if (try_ instanceof Success) {
            String s;
            Success success = (Success)try_;
            String string = s = (String)success.value();
            String string2 = this.serverId();
            return Option$.MODULE$.when(string == null ? string2 != null : !string.equals(string2), (Function0<String> & Serializable)() -> new StringBuilder(48).append("serverId file contents ").append(s).append(" does not match serverId ").append(this.serverId()).toString());
        }
        throw new MatchError(try_);
    }

    public <T> Option<T> interruptWithTimeout(Function0<BoxedUnit> close2, Function0<T> t) {
        Option option;
        VolatileBooleanRef interrupt = VolatileBooleanRef.create(true);
        VolatileBooleanRef interrupted = VolatileBooleanRef.create(false);
        Thread thread = new Thread(() -> {
            try {
                Thread.sleep($this.acceptTimeoutMillis);
            }
            catch (InterruptedException t) {
                // empty catch block
            }
            if (interrupt$1.elem) {
                interrupted$1.elem = true;
                this.serverLog(new StringBuilder(21).append("Interrupting after ").append($this.acceptTimeoutMillis).append("ms").toString());
                close2.apply$mcV$sp();
                return;
            }
        }, "MillSocketTimeoutInterruptThread");
        thread.start();
        try {
            Option res;
            Option option2;
            try {
                option2 = new Some<T>(t.apply());
            }
            catch (Throwable e) {
                option2 = res = None$.MODULE$;
            }
            option = interrupted.elem ? None$.MODULE$ : res;
        }
        finally {
            interrupt.elem = false;
            thread.interrupt();
        }
        return option;
    }

    public void handleRun(Socket clientSocket, scala.collection.immutable.Map<String, String> initialSystemProperties) {
        OutputStream currentOutErr = clientSocket.getOutputStream();
        try {
            PrintStream stdout = new PrintStream(new ProxyStream.Output(currentOutErr, 1), true);
            PrintStream stderr = new PrintStream(new ProxyStream.Output(currentOutErr, -1), true);
            PipedInputStream proxiedSocketInput = this.proxyInputStreamThroughPumper(clientSocket.getInputStream());
            InputStream argStream = read$inputStream$.MODULE$.apply(this.serverDir.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"runArgs"})))));
            boolean interactive = argStream.read() != 0;
            String clientMillVersion = Util.readString(argStream);
            String serverMillVersion = BuildInfo.millVersion;
            String string = clientMillVersion;
            String string2 = serverMillVersion;
            if (string == null ? string2 != null : !string.equals(string2)) {
                stderr.println(new StringBuilder(47).append("Mill version changed (").append(serverMillVersion).append(" -> ").append(clientMillVersion).append("), re-starting server").toString());
                write$.MODULE$.apply(this.serverDir.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"exitCode"})))), Source$.MODULE$.WritableSource(Integer.toString(Util.ExitServerCodeWhenVersionMismatch()).getBytes(), (Function1<byte[], Writable.ByteArrayWritable> & Serializable)a -> Writable$.MODULE$.ByteArrayWritable((byte[])a)), write$.MODULE$.apply$default$3(), write$.MODULE$.apply$default$4());
                System.exit(Util.ExitServerCodeWhenVersionMismatch());
            }
            String[] args = Util.parseArgs(argStream);
            Map<String, String> env = Util.parseMap(argStream);
            this.serverLog(new StringBuilder(5).append("args ").append(default$.MODULE$.write(args, default$.MODULE$.write$default$2(), default$.MODULE$.write$default$3(), default$.MODULE$.write$default$4(), default$.MODULE$.ArrayWriter(default$.MODULE$.StringWriter()))).toString());
            this.serverLog(new StringBuilder(4).append("env ").append(default$.MODULE$.write(CollectionConverters$.MODULE$.MapHasAsScala(env).asScala(), default$.MODULE$.write$default$2(), default$.MODULE$.write$default$3(), default$.MODULE$.write$default$4(), default$.MODULE$.MapWriter3(default$.MODULE$.StringWriter(), default$.MODULE$.StringWriter()))).toString());
            Map<String, String> userSpecifiedProperties = Util.parseMap(argStream);
            argStream.close();
            VolatileBooleanRef done = VolatileBooleanRef.create(false);
            VolatileBooleanRef idle = VolatileBooleanRef.create(false);
            Thread t = new Thread(() -> {
                try {
                    Tuple2 tuple2 = this.main0(args, this.stateCache(), interactive, new SystemStreams(stdout, stderr, proxiedSocketInput), CollectionConverters$.MODULE$.MapHasAsScala(env).asScala().toMap($less$colon$less$.MODULE$.refl()), (Function1<Object, BoxedUnit>)(Function1<Object, Object> & Serializable)x$1 -> {
                        idle.elem = BoxesRunTime.unboxToBoolean(x$1);
                        return BoxedUnit.UNIT;
                    }, CollectionConverters$.MODULE$.MapHasAsScala(userSpecifiedProperties).asScala().toMap($less$colon$less$.MODULE$.refl()), initialSystemProperties, (Function1<Object, Nothing$> & Serializable)exitCode -> Server.$anonfun$handleRun$4(this, BoxesRunTime.unboxToInt(exitCode)));
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    boolean result2 = tuple2._1$mcZ$sp();
                    Object newStateCache = tuple2._2();
                    Tuple2 tuple22 = new Tuple2(BoxesRunTime.boxToBoolean(result2), newStateCache);
                    boolean result3 = tuple22._1$mcZ$sp();
                    Object newStateCache2 = tuple22._2();
                    this.stateCache_$eq(newStateCache2);
                    String exitCode2 = result3 ? "0" : "1";
                    this.serverLog(new StringBuilder(9).append("exitCode ").append(exitCode2).toString());
                    write$over$.MODULE$.apply($this.serverDir.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"exitCode"})))), Source$.MODULE$.WritableSource(exitCode2, (Function1<String, Writable.StringWritable> & Serializable)s -> Writable$.MODULE$.StringWritable((String)s)), write$over$.MODULE$.apply$default$3(), write$over$.MODULE$.apply$default$4(), write$over$.MODULE$.apply$default$5(), write$over$.MODULE$.apply$default$6());
                }
                finally {
                    done$1.elem = true;
                    idle$1.elem = true;
                }
            }, "MillServerActionRunner");
            t.start();
            while (!done.elem && !this.locks.clientLock.probe()) {
                Thread.sleep(1L);
            }
            if (!idle.elem) {
                this.serverLog("client interrupted while server was executing command");
                this.exitServer();
            }
            t.interrupt();
            Thread.sleep(5L);
            try {
                t.stop();
            }
            catch (Throwable throwable) {
                Error error;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof UnsupportedOperationException) {
                }
                if (throwable2 instanceof Error && (error = (Error)throwable2).getMessage().contains("Cleaner terminated abnormally")) {
                }
                throw throwable;
            }
            System.out.flush();
            System.err.flush();
        }
        finally {
            ProxyStream.sendEnd(currentOutErr);
        }
    }

    public abstract Tuple2<Object, T> main0(String[] var1, T var2, boolean var3, SystemStreams var4, scala.collection.immutable.Map<String, String> var5, Function1<Object, BoxedUnit> var6, scala.collection.immutable.Map<String, String> var7, scala.collection.immutable.Map<String, String> var8, Function1<Object, Nothing$> var9);

    public static final /* synthetic */ Nothing$ $anonfun$handleRun$4(Server $this, int exitCode) {
        write$over$.MODULE$.apply($this.serverDir.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"exitCode"})))), Source$.MODULE$.WritableSource(Integer.toString(exitCode), (Function1<String, Writable.StringWritable> & Serializable)s -> Writable$.MODULE$.StringWritable((String)s)), write$over$.MODULE$.apply$default$3(), write$over$.MODULE$.apply$default$4(), write$over$.MODULE$.apply$default$5(), write$over$.MODULE$.apply$default$6());
        return package$.MODULE$.exit(exitCode);
    }

    public Server(Path serverDir, int acceptTimeoutMillis, Locks locks, boolean testLogEvenWhenServerIdWrong) {
        this.serverDir = serverDir;
        this.acceptTimeoutMillis = acceptTimeoutMillis;
        this.locks = locks;
        this.testLogEvenWhenServerIdWrong = testLogEvenWhenServerIdWrong;
        this.running = true;
        this.stateCache = this.stateCache0();
        this.serverId = Long.toHexString(Random$.MODULE$.nextLong());
    }
}

