/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjar.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;

public class ClassHeaderReader {
    private int access;
    private String thisClass;
    private String superClass;
    private String[] interfaces;
    private InputStream in;
    private byte[] b = new byte[8192];
    private int[] items = new int[1000];
    private int bsize = 0;
    private MyByteArrayInputStream bin = new MyByteArrayInputStream();
    private DataInputStream data = new DataInputStream(this.bin);
    private static final int CHUNK = 2048;

    public int getAccess() {
        return this.access;
    }

    public String getClassName() {
        return this.thisClass;
    }

    public String getSuperName() {
        return this.superClass;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream inputStream) throws IOException {
        try {
            int n;
            int n2;
            this.in = inputStream;
            this.bsize = 0;
            this.access = 0;
            this.superClass = null;
            this.thisClass = null;
            this.interfaces = null;
            try {
                this.buffer(4);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.b[0] != -54 || this.b[1] != -2 || this.b[2] != -70 || this.b[3] != -66) {
                throw new ClassFormatError("Bad magic number");
            }
            this.buffer(6);
            this.readUnsignedShort(4);
            this.readUnsignedShort(6);
            int n3 = this.readUnsignedShort(8);
            this.items = (int[])ClassHeaderReader.resizeArray(this.items, n3);
            int n4 = 10;
            for (n2 = 1; n2 < n3; ++n2) {
                this.buffer(n4 + 3);
                byte by = this.b[n4];
                this.items[n2] = n4 + 1;
                switch (by) {
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        n = 4;
                        break;
                    }
                    case 5: 
                    case 6: {
                        n = 8;
                        ++n2;
                        break;
                    }
                    case 1: {
                        n = 2 + this.readUnsignedShort(n4 + 1);
                        break;
                    }
                    case 7: 
                    case 8: {
                        n = 2;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown constant pool tag " + by);
                    }
                }
                n4 += n + 1;
            }
            this.buffer(n4 + 8);
            this.access = this.readUnsignedShort(n4);
            this.thisClass = this.readClass(n4 + 2);
            this.superClass = this.readClass(n4 + 4);
            n2 = this.readUnsignedShort(n4 + 6);
            this.buffer((n4 += 8) + n2 * 2);
            this.interfaces = new String[n2];
            for (n = 0; n < n2; ++n) {
                this.interfaces[n] = this.readClass(n4);
                n4 += 2;
            }
        }
        finally {
            inputStream.close();
        }
    }

    private String readClass(int n) throws IOException {
        if ((n = this.readUnsignedShort(n)) == 0) {
            return null;
        }
        n = this.readUnsignedShort(this.items[n]);
        this.bin.readFrom(this.b, this.items[n]);
        return this.data.readUTF();
    }

    private int readUnsignedShort(int n) {
        byte[] byArray = this.b;
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private void buffer(int n) throws IOException {
        if (n > this.b.length) {
            this.b = (byte[])ClassHeaderReader.resizeArray(this.b, this.b.length * 2);
        }
        if (n > this.bsize) {
            int n2 = (int)(2048.0 * Math.ceil((float)n / 2048.0f));
            this.bsize += ClassHeaderReader.read(this.in, this.b, this.bsize, n2 - this.bsize);
            if (n > this.bsize) {
                throw new EOFException();
            }
        }
    }

    private static int read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n + n3, n2 - n3)) != -1; n3 += n4) {
        }
        return n3;
    }

    private static Object resizeArray(Object object, int n) {
        if (Array.getLength(object) < n) {
            Object object2 = Array.newInstance(object.getClass().getComponentType(), n);
            System.arraycopy(object, 0, object2, 0, Array.getLength(object));
            return object2;
        }
        return object;
    }

    private static class MyByteArrayInputStream
    extends ByteArrayInputStream {
        public MyByteArrayInputStream() {
            super(new byte[0]);
        }

        public void readFrom(byte[] byArray, int n) {
            this.buf = byArray;
            this.pos = n;
            this.count = byArray.length;
        }
    }
}

