/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjar;

import com.eed3si9n.jarjar.PatternElement;
import com.eed3si9n.jarjar.Wildcard;
import com.eed3si9n.jarjar.Zap;
import com.eed3si9n.jarjar.util.EntryStruct;
import com.eed3si9n.jarjar.util.JarProcessor;
import java.io.IOException;
import java.util.List;

class ZapProcessor
implements JarProcessor {
    private List<Wildcard> wildcards;
    private static final String RESOURCE_SUFFIX = "RESOURCE";

    public ZapProcessor(List<Zap> list2) {
        this.wildcards = PatternElement.createWildcards(list2);
    }

    @Override
    public boolean process(EntryStruct entryStruct) throws IOException {
        String string = entryStruct.name;
        String string2 = string.endsWith(".class") ? string.substring(0, string.length() - 6) : ZapProcessor.replaceResourceName(string);
        return !this.zap(string2);
    }

    private static String replaceResourceName(String string) {
        int n = string.lastIndexOf(47);
        String string2 = n < 0 ? RESOURCE_SUFFIX : string.substring(0, n + 1) + RESOURCE_SUFFIX;
        boolean bl = string2.startsWith("/");
        return bl ? string2.substring(1) : string2;
    }

    private boolean zap(String string) {
        for (Wildcard wildcard : this.wildcards) {
            if (!wildcard.matches(string)) continue;
            return true;
        }
        return false;
    }
}

