/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8.utils.typedarrays;

import com.eclipsesource.v8.utils.typedarrays.ArrayBuffer;
import com.eclipsesource.v8.utils.typedarrays.TypedArray;
import java.nio.ByteBuffer;

public class UInt32Array
extends TypedArray {
    public UInt32Array(ByteBuffer buffer) {
        super(buffer);
    }

    public UInt32Array(ArrayBuffer arrayBuffer) {
        this(arrayBuffer.getByteBuffer());
    }

    public long get(int index) {
        return 0xFFFFFFFF & this.buffer.asIntBuffer().get(index);
    }

    @Override
    public int length() {
        return this.buffer.asIntBuffer().limit();
    }

    public void put(int index, long value) {
        this.buffer.asIntBuffer().put(index, (int)(0xFFFFFFFFFFFFFFFFL & value));
    }

    @Override
    public int getType() {
        return 15;
    }
}

