import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { type Matcher } from '../matchEvent';
type AnalyticsData = {
    [key: string]: any;
};
type AnalyticsDecoratorProps = {
    match: Matcher;
    matchPrivate: boolean;
    data?: AnalyticsData;
    getData?: (name: string, data: AnalyticsData) => AnalyticsData;
    children: React.ReactNode;
};
type AnalyticsDecoratorContext = {
    onAnalyticsEvent?: (name: string, data: AnalyticsData, isPrivate: boolean) => void;
    getParentAnalyticsData?: (name: string, isPrivate: boolean) => AnalyticsData;
};
export declare const ContextTypes: {
    onAnalyticsEvent: PropTypes.Requireable<(...args: any[]) => any>;
    getParentAnalyticsData: PropTypes.Requireable<(...args: any[]) => any>;
};
/**
 * The Decorator component extends analytics event data
 * for any events fired by its descendents,
 * then passes the event up the hierarchy
 */
export declare class AnalyticsDecorator extends Component<AnalyticsDecoratorProps> {
    static defaultProps: {
        match: string;
        matchPrivate: boolean;
    };
    static contextTypes: {
        onAnalyticsEvent: PropTypes.Requireable<(...args: any[]) => any>;
        getParentAnalyticsData: PropTypes.Requireable<(...args: any[]) => any>;
    };
    static childContextTypes: {
        onAnalyticsEvent: PropTypes.Requireable<(...args: any[]) => any>;
        getParentAnalyticsData: PropTypes.Requireable<(...args: any[]) => any>;
    };
    getChildContext(): AnalyticsDecoratorContext;
    getDecoratedAnalyticsData: (name: string, srcData: AnalyticsData, isPrivate: boolean) => AnalyticsData;
    onAnalyticsEvent: (name: string, srcData: AnalyticsData, isPrivate: boolean) => void;
    getParentAnalyticsData: (name: string, isPrivate: boolean) => AnalyticsData;
    render(): React.ReactNode;
}
export default AnalyticsDecorator;
