/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer;

public class SourcePrinter {
    private final String indentation;
    private final String endOfLineCharacter;
    private int level = 0;
    private boolean indented = false;
    private final StringBuilder buf = new StringBuilder();

    SourcePrinter(String indentation, String endOfLineCharacter) {
        this.indentation = indentation;
        this.endOfLineCharacter = endOfLineCharacter;
    }

    public SourcePrinter indent() {
        ++this.level;
        return this;
    }

    public SourcePrinter unindent() {
        --this.level;
        return this;
    }

    private void makeIndent() {
        for (int i = 0; i < this.level; ++i) {
            this.buf.append(this.indentation);
        }
    }

    public SourcePrinter print(String arg) {
        if (!this.indented) {
            this.makeIndent();
            this.indented = true;
        }
        this.buf.append(arg);
        return this;
    }

    public SourcePrinter println(String arg) {
        this.print(arg);
        this.println();
        return this;
    }

    public SourcePrinter println() {
        this.buf.append(this.endOfLineCharacter);
        this.indented = false;
        return this;
    }

    public String getSource() {
        return this.buf.toString();
    }

    public String toString() {
        return this.getSource();
    }
}

