// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// REQUIRES: amdgpu-registered-target

// expected-no-diagnostics
#ifndef HEADER
#define HEADER

// RUN: %clang_cc1 -verify -fopenmp -x c -triple powerpc64le-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm-bc %s -o %t-ppc-host-amd.bc
// RUN: %clang_cc1 -verify -fopenmp -x c -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm %s -fopenmp-is-target-device -fopenmp-host-ir-file-path %t-ppc-host-amd.bc -o - | FileCheck %s --check-prefix=CHECK-AMD


void write_to_aligned_array(int *a, int N) {
  int *aptr __attribute__ ((aligned(64))) = a;
  #pragma omp target teams distribute parallel for map(tofrom: aptr[0:N])
  for(int i = 0; i < N; i++) {
    aptr[i] = i;
  }
}

#endif
// CHECK-AMD-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_write_to_aligned_array_l14
// CHECK-AMD-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i64 noundef [[N:%.*]], ptr noundef [[APTR:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-AMD-NEXT:  entry:
// CHECK-AMD-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-AMD-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-AMD-NEXT:    [[APTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-AMD-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-AMD-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-AMD-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-AMD-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-AMD-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-AMD-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-AMD-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-AMD-NEXT:    [[N_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_ADDR]] to ptr
// CHECK-AMD-NEXT:    [[APTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[APTR_ADDR]] to ptr
// CHECK-AMD-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-AMD-NEXT:    [[DOTCAPTURE_EXPR__ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_]] to ptr
// CHECK-AMD-NEXT:    [[DOTCAPTURE_EXPR_1_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_1]] to ptr
// CHECK-AMD-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-AMD-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-AMD-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-AMD-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-AMD-NEXT:    store i64 [[N]], ptr [[N_ADDR_ASCAST]], align 8
// CHECK-AMD-NEXT:    store ptr [[APTR]], ptr [[APTR_ADDR_ASCAST]], align 8
// CHECK-AMD-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-AMD-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-AMD-NEXT:    [[TMP0:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// CHECK-AMD-NEXT:    store i32 [[TMP0]], ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// CHECK-AMD-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// CHECK-AMD-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP1]], 0
// CHECK-AMD-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK-AMD-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK-AMD-NEXT:    store i32 [[SUB2]], ptr [[DOTCAPTURE_EXPR_1_ASCAST]], align 4
// CHECK-AMD-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-AMD-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-AMD-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_1_ASCAST]], align 4
// CHECK-AMD-NEXT:    store i32 [[TMP2]], ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-AMD-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-AMD-NEXT:    store i32 [[TMP3]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-AMD-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-AMD-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-AMD-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-AMD-NEXT:    [[TMP5:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-AMD-NEXT:    [[TMP6:%.*]] = add i32 [[TMP5]], [[TMP4]]
// CHECK-AMD-NEXT:    [[TMP7:%.*]] = mul i32 [[TMP6]], 1
// CHECK-AMD-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-AMD-NEXT:    [[TMP9:%.*]] = add i32 [[TMP7]], [[TMP8]]
// CHECK-AMD-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-AMD-NEXT:    br label [[FOR_COND:%.*]]
// CHECK-AMD:       for.cond:
// CHECK-AMD-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-AMD-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-AMD-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK-AMD-NEXT:    br i1 [[CMP]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK-AMD:       for.body:
// CHECK-AMD-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-AMD-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 1
// CHECK-AMD-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-AMD-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-AMD-NEXT:    [[TMP13:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-AMD-NEXT:    [[TMP14:%.*]] = load ptr, ptr [[APTR_ADDR_ASCAST]], align 8
// CHECK-AMD-NEXT:    [[TMP15:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-AMD-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP15]] to i64
// CHECK-AMD-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP14]], i64 [[IDXPROM]]
// CHECK-AMD-NEXT:    store i32 [[TMP13]], ptr [[ARRAYIDX]], align 4
// CHECK-AMD-NEXT:    br label [[FOR_INC:%.*]]
// CHECK-AMD:       for.inc:
// CHECK-AMD-NEXT:    [[NVPTX_NUM_THREADS3:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-AMD-NEXT:    [[TMP16:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-AMD-NEXT:    [[TMP17:%.*]] = mul i32 [[NVPTX_NUM_THREADS3]], [[TMP16]]
// CHECK-AMD-NEXT:    [[TMP18:%.*]] = mul i32 [[TMP17]], 1
// CHECK-AMD-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-AMD-NEXT:    [[TMP20:%.*]] = add i32 [[TMP18]], [[TMP19]]
// CHECK-AMD-NEXT:    store i32 [[TMP20]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-AMD-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK-AMD:       for.end:
// CHECK-AMD-NEXT:    ret void
//
