use bat::{
    assets::HighlightingAssets, config::Config, controller::Controller, output::OutputHandle, Input,
};

fn main() {
    let mut buffer = String::new();
    let config = Config {
        colored_output: true,
        ..Default::default()
    };
    let assets = HighlightingAssets::from_binary();
    let controller = Controller::new(&config, &assets);
    let input = Input::from_file(file!());
    controller
        .run(
            vec![input.into()],
            Some(&mut OutputHandle::FmtWrite(&mut buffer)),
        )
        .unwrap();

    println!("{buffer}");
}
