/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringStyleTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NoFieldNamesToStringStyleTest
extends AbstractLangTest {
    private final Integer base = 5;
    private final String baseStr = this.base.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this.base));

    @BeforeEach
    public void setUp() {
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.NO_FIELD_NAMES_STYLE);
    }

    @AfterEach
    public void tearDown() {
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    @Test
    public void testAppendSuper() {
        Assertions.assertEquals((Object)(this.baseStr + "[]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[<null>]").toString());
        Assertions.assertEquals((Object)(this.baseStr + "[hello]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").append("a", (Object)"hello").toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>,hello]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[<null>]").append("a", (Object)"hello").toString());
        Assertions.assertEquals((Object)(this.baseStr + "[hello]"), (Object)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
    }

    @Test
    public void testArray() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assertions.assertEquals((Object)(this.baseStr + "[<size=0>]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[0], false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{}]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[0], true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<size=1>]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[]{i3}, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{3}]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[]{i3}, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<size=2>]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[]{i3, i4}, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[]{i3, i4}, true).toString());
    }

    @Test
    public void testBlank() {
        Assertions.assertEquals((Object)(this.baseStr + "[]"), (Object)new ToStringBuilder((Object)this.base).toString());
    }

    @Test
    public void testCollection() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assertions.assertEquals((Object)(this.baseStr + "[<size=0>]"), (Object)new ToStringBuilder((Object)this.base).append("a", Collections.emptyList(), false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[[]]"), (Object)new ToStringBuilder((Object)this.base).append("a", Collections.emptyList(), true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<size=1>]"), (Object)new ToStringBuilder((Object)this.base).append("a", Collections.singletonList(i3), false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[[3]]"), (Object)new ToStringBuilder((Object)this.base).append("a", Collections.singletonList(i3), true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<size=2>]"), (Object)new ToStringBuilder((Object)this.base).append("a", Arrays.asList(i3, i4), false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[[3, 4]]"), (Object)new ToStringBuilder((Object)this.base).append("a", Arrays.asList(i3, i4), true).toString());
    }

    @Test
    public void testLong() {
        Assertions.assertEquals((Object)(this.baseStr + "[3]"), (Object)new ToStringBuilder((Object)this.base).append(3L).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[3]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[3,4]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    @Test
    public void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        Assertions.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testLongArrayArray() {
        long[][] array = new long[][]{{1L, 2L}, null, {5L}};
        Assertions.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testMap() {
        Assertions.assertEquals((Object)(this.baseStr + "[<size=0>]"), (Object)new ToStringBuilder((Object)this.base).append("a", Collections.emptyMap(), false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{}]"), (Object)new ToStringBuilder((Object)this.base).append("a", Collections.emptyMap(), true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<size=1>]"), (Object)new ToStringBuilder((Object)this.base).append("a", Collections.singletonMap("k", "v"), false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{k=v}]"), (Object)new ToStringBuilder((Object)this.base).append("a", Collections.singletonMap("k", "v"), true).toString());
    }

    @Test
    public void testObject() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[3]"), (Object)new ToStringBuilder((Object)this.base).append((Object)i3).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append("a", null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[3]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[3,4]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<Integer>]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString());
    }

    @Test
    public void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        Assertions.assertEquals((Object)(this.baseStr + "[{<null>,5,{3,6}}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{<null>,5,{3,6}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testPerson() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person();
        p.name = "Ron Paul";
        p.age = 72;
        p.smoker = false;
        String pBaseStr = p.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(p));
        Assertions.assertEquals((Object)(pBaseStr + "[Ron Paul,72,false]"), (Object)new ToStringBuilder((Object)p).append("name", (Object)p.name).append("age", p.age).append("smoker", p.smoker).toString());
    }
}

