/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.stream.Stream;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.RandomUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class RandomUtilsTest
extends AbstractLangTest {
    private static final double DELTA = 1.0E-5;

    static Stream<RandomUtils> randomProvider() {
        return Stream.of(RandomUtils.secure(), RandomUtils.secureStrong(), RandomUtils.insecure());
    }

    @Test
    public void testBoolean() {
        boolean result = RandomUtils.nextBoolean();
        Assertions.assertTrue((result || !result ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testBoolean(RandomUtils ru) {
        boolean result = ru.randomBoolean();
        Assertions.assertTrue((result || !result ? 1 : 0) != 0);
    }

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new RandomUtils());
    }

    @Test
    public void testExtremeRangeDouble() {
        double result = RandomUtils.nextDouble((double)0.0, (double)Double.MAX_VALUE);
        Assertions.assertTrue((result >= 0.0 && result <= Double.MAX_VALUE ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testExtremeRangeDouble(RandomUtils ru) {
        double result = ru.randomDouble(0.0, Double.MAX_VALUE);
        Assertions.assertTrue((result >= 0.0 && result <= Double.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testExtremeRangeFloat() {
        float result = RandomUtils.nextFloat((float)0.0f, (float)Float.MAX_VALUE);
        Assertions.assertTrue((result >= 0.0f && result <= Float.MAX_VALUE ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testExtremeRangeFloat(RandomUtils ru) {
        float result = ru.randomFloat(0.0f, Float.MAX_VALUE);
        Assertions.assertTrue((result >= 0.0f && result <= Float.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testExtremeRangeInt() {
        int result = RandomUtils.nextInt((int)0, (int)Integer.MAX_VALUE);
        MatcherAssert.assertThat((String)"result >= 0 && result < Integer.MAX_VALUE", (Object)result, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(Integer.MAX_VALUE))));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testExtremeRangeInt(RandomUtils ru) {
        int result = ru.randomInt(0, Integer.MAX_VALUE);
        MatcherAssert.assertThat((String)"result >= 0 && result < Integer.MAX_VALUE", (Object)result, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(Integer.MAX_VALUE))));
    }

    @Test
    public void testExtremeRangeLong() {
        long result = RandomUtils.nextLong((long)0L, (long)Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"result >= 0 && result < Long.MAX_VALUE", (Object)result, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(Long.MAX_VALUE))));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testExtremeRangeLong(RandomUtils ru) {
        long result = ru.randomLong(0L, Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"result >= 0 && result < Long.MAX_VALUE", (Object)result, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(Long.MAX_VALUE))));
    }

    @Test
    public void testLargeValueRangeLong() {
        long startInclusive = 12900000000001L;
        long endExclusive = 12900000000016L;
        int n = 15000;
        for (int i = 0; i < 15000; ++i) {
            Assertions.assertNotEquals((long)12900000000016L, (long)RandomUtils.nextLong((long)12900000000001L, (long)12900000000016L));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testLargeValueRangeLong(RandomUtils ru) {
        long startInclusive = 12900000000001L;
        long endExclusive = 12900000000016L;
        int n = 15000;
        for (int i = 0; i < 15000; ++i) {
            Assertions.assertNotEquals((long)12900000000016L, (long)ru.randomLong(12900000000001L, 12900000000016L));
        }
    }

    @Test
    public void testNextBytes() {
        byte[] result = RandomUtils.nextBytes((int)20);
        Assertions.assertEquals((int)20, (int)result.length);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextBytes(RandomUtils ru) {
        byte[] result = ru.randomBytes(20);
        Assertions.assertEquals((int)20, (int)result.length);
    }

    @Test
    public void testNextBytesNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextBytes((int)-1));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextBytesNegative(RandomUtils ru) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ru.randomBytes(-1));
    }

    @Test
    public void testNextDouble() {
        double result = RandomUtils.nextDouble((double)33.0, (double)42.0);
        MatcherAssert.assertThat((String)"result >= 33d && result < 42d", (Object)result, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(33.0)), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(42.0))));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextDouble(RandomUtils ru) {
        double result = ru.randomDouble(33.0, 42.0);
        MatcherAssert.assertThat((String)"result >= 33d && result < 42d", (Object)result, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(33.0)), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(42.0))));
    }

    @Test
    public void testNextDoubleLowerGreaterUpper() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextDouble((double)2.0, (double)1.0));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextDoubleLowerGreaterUpper(RandomUtils ru) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ru.randomDouble(2.0, 1.0));
    }

    @Test
    public void testNextDoubleMinimalRange() {
        Assertions.assertEquals((double)42.1, (double)RandomUtils.nextDouble((double)42.1, (double)42.1), (double)1.0E-5);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextDoubleMinimalRange(RandomUtils ru) {
        Assertions.assertEquals((double)42.1, (double)ru.randomDouble(42.1, 42.1), (double)1.0E-5);
    }

    @Test
    public void testNextDoubleNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextDouble((double)-1.0, (double)1.0));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextDoubleNegative(RandomUtils ru) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ru.randomDouble(-1.0, 1.0));
    }

    @Test
    public void testNextDoubleRandomResult() {
        double randomResult = RandomUtils.nextDouble();
        MatcherAssert.assertThat((String)"randomResult >= 0 0 && randomResult < Double.MAX_VALUE", (Object)randomResult, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(0.0)), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(Double.MAX_VALUE))));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextDoubleRandomResult(RandomUtils ru) {
        double randomResult = ru.randomDouble();
        MatcherAssert.assertThat((String)"randomResult >= 0 0 && randomResult < Double.MAX_VALUE", (Object)randomResult, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(0.0)), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(Double.MAX_VALUE))));
    }

    @Test
    public void testNextFloat() {
        float result = RandomUtils.nextFloat((float)33.0f, (float)42.0f);
        MatcherAssert.assertThat((String)"result >= 33f && result < 42f", (Object)Float.valueOf(result), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(33.0f)), (Matcher)Matchers.lessThan((Comparable)Float.valueOf(42.0f))));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextFloat(RandomUtils ru) {
        float result = ru.randomFloat(33.0f, 42.0f);
        MatcherAssert.assertThat((String)"result >= 33f && result < 42f", (Object)Float.valueOf(result), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(33.0f)), (Matcher)Matchers.lessThan((Comparable)Float.valueOf(42.0f))));
    }

    @Test
    public void testNextFloatLowerGreaterUpper() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextFloat((float)2.0f, (float)1.0f));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextFloatLowerGreaterUpper(RandomUtils ru) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ru.randomFloat(2.0f, 1.0f));
    }

    @Test
    public void testNextFloatMinimalRange() {
        Assertions.assertEquals((double)42.1f, (double)RandomUtils.nextFloat((float)42.1f, (float)42.1f), (double)1.0E-5);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextFloatMinimalRange(RandomUtils ru) {
        Assertions.assertEquals((double)42.1f, (double)ru.randomFloat(42.1f, 42.1f), (double)1.0E-5);
    }

    @Test
    public void testNextFloatNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextFloat((float)-1.0f, (float)1.0f));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextFloatNegative(RandomUtils ru) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ru.randomFloat(-1.0f, 1.0f));
    }

    @Test
    public void testNextFloatRandomResult() {
        float randomResult = RandomUtils.nextFloat();
        MatcherAssert.assertThat((String)"randomResult >= 0 && randomResult < Double.MAX_VALUE", (Object)Float.valueOf(randomResult), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)), (Matcher)Matchers.lessThan((Comparable)Float.valueOf(Float.MAX_VALUE))));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextFloatRandomResult(RandomUtils ru) {
        float randomResult = ru.randomFloat();
        MatcherAssert.assertThat((String)"randomResult >= 0 && randomResult < Double.MAX_VALUE", (Object)Float.valueOf(randomResult), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)), (Matcher)Matchers.lessThan((Comparable)Float.valueOf(Float.MAX_VALUE))));
    }

    @Test
    public void testNextInt() {
        int result = RandomUtils.nextInt((int)33, (int)42);
        MatcherAssert.assertThat((String)"result >= 33 && result < 42", (Object)result, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(33)), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(42))));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextInt(RandomUtils ru) {
        int result = ru.randomInt(33, 42);
        MatcherAssert.assertThat((String)"result >= 33 && result < 42", (Object)result, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(33)), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(42))));
    }

    @Test
    public void testNextIntLowerGreaterUpper() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextInt((int)2, (int)1));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextIntLowerGreaterUpper(RandomUtils ru) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ru.randomInt(2, 1));
    }

    @Test
    public void testNextIntMinimalRange() {
        Assertions.assertEquals((int)42, (int)RandomUtils.nextInt((int)42, (int)42));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextIntMinimalRange(RandomUtils ru) {
        Assertions.assertEquals((int)42, (int)ru.randomInt(42, 42));
    }

    @Test
    public void testNextIntNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextInt((int)-1, (int)1));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextIntNegative(RandomUtils ru) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ru.randomInt(-1, 1));
    }

    @Test
    public void testNextIntRandomResult() {
        int randomResult = RandomUtils.nextInt();
        Assertions.assertTrue((randomResult > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((randomResult < Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextIntRandomResult(RandomUtils ru) {
        int randomResult = ru.randomInt();
        Assertions.assertTrue((randomResult > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((randomResult < Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testNextLong() {
        long result = RandomUtils.nextLong((long)33L, (long)42L);
        MatcherAssert.assertThat((String)"result >= 33L && result < 42L", (Object)result, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(33L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(42L))));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextLong(RandomUtils ru) {
        long result = ru.randomLong(33L, 42L);
        MatcherAssert.assertThat((String)"result >= 33L && result < 42L", (Object)result, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(33L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(42L))));
    }

    @Test
    public void testNextLongLowerGreaterUpper() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextLong((long)2L, (long)1L));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextLongLowerGreaterUpper(RandomUtils ru) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ru.randomLong(2L, 1L));
    }

    @Test
    public void testNextLongMinimalRange() {
        Assertions.assertEquals((long)42L, (long)RandomUtils.nextLong((long)42L, (long)42L));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextLongMinimalRange(RandomUtils ru) {
        Assertions.assertEquals((long)42L, (long)ru.randomLong(42L, 42L));
    }

    @Test
    public void testNextLongNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextLong((long)-1L, (long)1L));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextLongNegative(RandomUtils ru) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ru.randomLong(-1L, 1L));
    }

    @Test
    public void testNextLongRandomResult() {
        long randomResult = RandomUtils.nextLong();
        MatcherAssert.assertThat((String)"randomResult >= 0 && randomResult < Long.MAX_VALUE", (Object)randomResult, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(Long.MAX_VALUE))));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testNextLongRandomResult(RandomUtils ru) {
        long randomResult = ru.randomLong();
        MatcherAssert.assertThat((String)"randomResult >= 0 && randomResult < Long.MAX_VALUE", (Object)randomResult, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(Long.MAX_VALUE))));
    }

    @Test
    public void testZeroLengthNextBytes() {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])RandomUtils.nextBytes((int)0));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testZeroLengthNextBytes(RandomUtils ru) {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])ru.randomBytes(0));
    }
}

