/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.ValuePatternComponent;
import java.text.ParseException;
import java.util.Random;

final class RandomCharactersValuePatternComponent
extends ValuePatternComponent {
    private static final long serialVersionUID = 1653000400888202919L;
    @NotNull
    private final char[] characterSet;
    private final int numCharacters;
    @NotNull
    private final Random seedRandom;
    @NotNull
    private final ThreadLocal<Random> threadLocalRandoms;

    RandomCharactersValuePatternComponent(@NotNull String pattern, long randomSeed) throws ParseException {
        String numCharactersString;
        this.seedRandom = new Random(randomSeed);
        this.threadLocalRandoms = new ThreadLocal();
        int secondColonPos = pattern.indexOf(58, 7);
        if (secondColonPos < 0) {
            this.characterSet = "abcdefghijklmnopqrstuvwxyz".toCharArray();
            numCharactersString = pattern.substring(7);
        } else {
            numCharactersString = pattern.substring(7, secondColonPos);
            String characterSetString = pattern.substring(secondColonPos + 1);
            this.characterSet = characterSetString.toCharArray();
        }
        try {
            this.numCharacters = Integer.parseInt(numCharactersString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ParseException(UtilityMessages.ERR_RANDOM_CHARS_VALUE_PATTERN_CANNOT_PARSE_LENGTH.get(pattern, numCharactersString), 7);
        }
        if (this.numCharacters <= 0) {
            throw new ParseException(UtilityMessages.ERR_RANDOM_CHARS_VALUE_PATTERN_INVALID_LENGTH.get(pattern, this.numCharacters), 7);
        }
        if (this.characterSet.length == 0) {
            throw new ParseException(UtilityMessages.ERR_RANDOM_CHARS_VALUE_PATTERN_EMPTY_CHAR_SET.get(pattern), secondColonPos + 1);
        }
    }

    @Override
    void append(@NotNull StringBuilder buffer) {
        Random random = this.getRandom();
        for (int i = 0; i < this.numCharacters; ++i) {
            buffer.append(this.characterSet[random.nextInt(this.characterSet.length)]);
        }
    }

    @Override
    boolean supportsBackReference() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Random getRandom() {
        Random random = this.threadLocalRandoms.get();
        if (random == null) {
            Random random2 = this.seedRandom;
            synchronized (random2) {
                random = new Random(this.seedRandom.nextLong());
            }
            this.threadLocalRandoms.set(random);
        }
        return random;
    }
}

