/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.semantics;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.semantics.SemanticTag;

@NonNullByDefault
public class SemanticTagImpl
implements SemanticTag {
    private static final String TAGS_BUNDLE_NAME = "tags";
    private String uid;
    private String name;
    private String parent;
    private String label;
    private String description;
    private List<String> synonyms;

    public SemanticTagImpl(String uid, @Nullable String label, @Nullable String description, @Nullable List<String> synonyms) {
        this(uid, label, description);
        if (synonyms != null) {
            this.synonyms = new ArrayList<String>();
            for (String synonym : synonyms) {
                this.synonyms.add(synonym.trim());
            }
        }
    }

    public SemanticTagImpl(String uid, @Nullable String label, @Nullable String description, @Nullable String synonyms) {
        this(uid, label, description);
        if (synonyms != null && !synonyms.isBlank()) {
            this.synonyms = new ArrayList<String>();
            String[] stringArray = synonyms.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String synonym = stringArray[n2];
                this.synonyms.add(synonym.trim());
                ++n2;
            }
        }
    }

    private SemanticTagImpl(String uid, @Nullable String label, @Nullable String description) {
        this.uid = uid;
        int idx = uid.lastIndexOf("_");
        if (idx < 0) {
            this.name = uid.trim();
            this.parent = "";
        } else {
            this.name = uid.substring(idx + 1).trim();
            this.parent = uid.substring(0, idx).trim();
        }
        this.label = label == null ? "" : label.trim();
        this.description = description == null ? "" : description.trim();
        this.synonyms = List.of();
    }

    public String getUID() {
        return this.uid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getParentUID() {
        return this.parent;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getSynonyms() {
        return this.synonyms;
    }

    @Override
    public SemanticTag localized(Locale locale) {
        String description;
        List<String> synonyms;
        String label;
        ResourceBundle rb = ResourceBundle.getBundle(TAGS_BUNDLE_NAME, locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));
        try {
            String entry = rb.getString(this.uid);
            int idx = entry.indexOf(",");
            if (idx >= 0) {
                label = entry.substring(0, idx);
                String synonymsCsv = entry.substring(idx + 1);
                synonyms = synonymsCsv.isBlank() ? null : List.of(synonymsCsv.split(","));
            } else {
                label = entry;
                synonyms = null;
            }
        }
        catch (MissingResourceException e) {
            label = this.getLabel();
            synonyms = this.getSynonyms();
        }
        try {
            description = rb.getString(this.uid + "__description");
        }
        catch (MissingResourceException e) {
            description = this.getDescription();
        }
        return new SemanticTagImpl(this.uid, label, description, synonyms);
    }
}

