/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.asamk.signal.json.JsonAttachment;
import org.asamk.signal.json.JsonPreview;
import org.asamk.signal.manager.api.Color;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.MessageEnvelope;

record JsonStoryMessage(boolean allowsReplies, @JsonInclude(value=JsonInclude.Include.NON_NULL) String groupId, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonAttachment fileAttachment, @JsonInclude(value=JsonInclude.Include.NON_NULL) TextAttachment textAttachment) {
    static JsonStoryMessage from(MessageEnvelope.Story storyMessage) {
        return new JsonStoryMessage(storyMessage.allowsReplies(), storyMessage.groupId().map(GroupId::toBase64).orElse(null), storyMessage.fileAttachment().map(JsonAttachment::from).orElse(null), storyMessage.textAttachment().map(TextAttachment::from).orElse(null));
    }

    public record TextAttachment(String text, @JsonInclude(value=JsonInclude.Include.NON_NULL) String style, @JsonInclude(value=JsonInclude.Include.NON_NULL) String textForegroundColor, @JsonInclude(value=JsonInclude.Include.NON_NULL) String textBackgroundColor, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonPreview preview, @JsonInclude(value=JsonInclude.Include.NON_NULL) Gradient backgroundGradient, @JsonInclude(value=JsonInclude.Include.NON_NULL) String backgroundColor) {
        static TextAttachment from(MessageEnvelope.Story.TextAttachment textAttachment) {
            return new TextAttachment(textAttachment.text().orElse(null), textAttachment.style().map(Enum::name).orElse(null), textAttachment.textForegroundColor().map(Color::toHexColor).orElse(null), textAttachment.textBackgroundColor().map(Color::toHexColor).orElse(null), textAttachment.preview().map(JsonPreview::from).orElse(null), textAttachment.backgroundGradient().map(Gradient::from).orElse(null), textAttachment.backgroundColor().map(Color::toHexColor).orElse(null));
        }

        public record Gradient(String startColor, String endColor, List<String> colors, List<Float> positions, Integer angle) {
            static Gradient from(MessageEnvelope.Story.TextAttachment.Gradient gradient) {
                boolean isLegacyGradient = gradient.colors().size() == 2 && gradient.positions().size() == 2 && ((Float)gradient.positions().get(0)).floatValue() == 0.0f && ((Float)gradient.positions().get(1)).floatValue() == 1.0f;
                return new Gradient(isLegacyGradient ? ((Color)gradient.colors().get(0)).toHexColor() : null, isLegacyGradient ? ((Color)gradient.colors().get(1)).toHexColor() : null, gradient.colors().stream().map(Color::toHexColor).toList(), gradient.positions(), gradient.angle().orElse(null));
            }
        }
    }
}

